/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class BibUserString
implements BibValue {
    private TeXObject string;

    public BibUserString(TeXObject teXObject) {
        this.string = teXObject;
    }

    @Override
    public TeXObject getContents() {
        return this.string;
    }

    @Override
    public String applyDelim(byte by) {
        String string = this.string.format();
        switch (by) {
            case 0: {
                return string;
            }
            case 1: {
                if (string.startsWith("{") && string.endsWith("}")) {
                    return string;
                }
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    return String.format("{%s}", string.substring(1, string.length() - 1));
                }
                return String.format("{%s}", string);
            }
            case 2: {
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    return string;
                }
                if (string.startsWith("{") && string.endsWith("}")) {
                    return String.format("\"%s\"", string.substring(1, string.length() - 1));
                }
                return String.format("\"%s\"", string);
            }
        }
        throw new IllegalArgumentException("Invalid argument " + by);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.string.format());
    }

    @Override
    public TeXObjectList expand(TeXParser teXParser) throws IOException {
        if (this.string instanceof Group) {
            return ((Group)this.string).toList();
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        if (!(this.string instanceof TeXObjectList)) {
            teXObjectList.add(this.string);
            return teXObjectList;
        }
        TeXObjectList teXObjectList2 = (TeXObjectList)this.string;
        if (teXObjectList2.isEmpty()) {
            return teXObjectList;
        }
        TeXObject teXObject = (TeXObject)teXObjectList2.firstElement();
        TeXObject teXObject2 = (TeXObject)teXObjectList2.lastElement();
        int n = 0;
        int n2 = teXObjectList2.size() - 1;
        if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 34 && teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 34) {
            ++n;
            --n2;
        }
        for (int i = n; i <= n2; ++i) {
            i = this.expand(teXParser, teXObjectList2, i, teXObjectList);
        }
        return teXObjectList;
    }

    protected int expand(TeXParser teXParser, TeXObjectList teXObjectList, int n, TeXObjectList teXObjectList2) throws IOException {
        TeXObject teXObject = (TeXObject)teXObjectList.get(n);
        if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList3 = ((TeXObjectList)teXObject).createList();
            for (int i = 0; i < ((TeXObjectList)teXObject).size(); ++i) {
                i = this.expand(teXParser, (TeXObjectList)teXObject, i, teXObjectList3);
            }
            teXObjectList2.add(teXObjectList3);
        } else if (teXObject instanceof CharObject) {
            if (((CharObject)teXObject).getCharCode() == 35 && n < teXObjectList.size() - 1) {
                TeXObject teXObject2 = (TeXObject)teXObjectList.get(n + 1);
                if (teXObject2 instanceof CharObject) {
                    int n2 = ((CharObject)teXObject2).getCharCode();
                    if (n2 == 35 && n < teXObjectList.size() - 2) {
                        teXObject2 = (TeXObject)teXObjectList.get(n + 2);
                        if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() > 48 && ((CharObject)teXObject2).getCharCode() <= 57) {
                            teXObjectList2.add(teXParser.getListener().getParam(((CharObject)teXObject2).getCharCode() - 48));
                            n += 2;
                        } else {
                            teXObjectList2.add(teXObject);
                        }
                    } else if (n2 > 48 && n2 <= 57) {
                        teXObjectList2.add(teXParser.getListener().getParam(n2 - 48));
                        ++n;
                    } else {
                        teXObjectList2.add(teXObject);
                    }
                } else {
                    teXObjectList2.add(teXObject);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
        } else {
            teXObjectList2.add(teXObject);
        }
        return n;
    }
}

