/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.server.IllegalConfigurationException;

public class HTTPServerConfig {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8081;
    static final String LANGUAGE_MODEL_OPTION = "--languageModel";
    protected boolean verbose = false;
    protected boolean publicAccess = false;
    protected int port = 8081;
    protected String allowOriginUrl = null;
    protected int maxTextLength = Integer.MAX_VALUE;
    protected int maxTextHardLength = Integer.MAX_VALUE;
    protected String secretTokenKey = null;
    protected long maxCheckTimeMillis = -1L;
    protected int maxCheckThreads = 10;
    protected Mode mode;
    protected File languageModelDir = null;
    protected int requestLimit;
    protected int requestLimitPeriodInSeconds;
    protected boolean trustXForwardForHeader;
    protected int maxWorkQueueSize;
    protected File rulesConfigFile = null;
    protected int cacheSize = 0;
    protected boolean warmUp = false;

    public HTTPServerConfig() {
        this(8081, false);
    }

    public HTTPServerConfig(int serverPort) {
        this(serverPort, false);
    }

    public HTTPServerConfig(int serverPort, boolean verbose) {
        this.port = serverPort;
        this.verbose = verbose;
    }

    HTTPServerConfig(String[] args) {
        block18: for (int i = 0; i < args.length; ++i) {
            if (args[i].matches("--[a-zA-Z]+=.+")) {
                System.err.println("WARNING: use `--option value`, not `--option=value`, parameters will be ignored otherwise: " + args[i]);
            }
            switch (args[i]) {
                case "--config": {
                    this.parseConfigFile(new File(args[++i]), !ArrayUtils.contains(args, LANGUAGE_MODEL_OPTION));
                    continue block18;
                }
                case "-p": 
                case "--port": {
                    this.port = Integer.parseInt(args[++i]);
                    continue block18;
                }
                case "-v": 
                case "--verbose": {
                    this.verbose = true;
                    continue block18;
                }
                case "--public": {
                    this.publicAccess = true;
                    continue block18;
                }
                case "--allow-origin": {
                    this.allowOriginUrl = args[++i];
                    if (!this.allowOriginUrl.startsWith("--")) continue block18;
                    throw new IllegalArgumentException("Missing argument for '--allow-origin'");
                }
                case "--languageModel": {
                    this.setLanguageModelDirectory(args[++i]);
                }
            }
        }
    }

    private void parseConfigFile(File file, boolean loadLangModel) {
        block23: {
            try {
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(file);){
                    props.load(fis);
                    this.maxTextLength = Integer.parseInt(this.getOptionalProperty(props, "maxTextLength", Integer.toString(Integer.MAX_VALUE)));
                    this.maxTextHardLength = Integer.parseInt(this.getOptionalProperty(props, "maxTextHardLength", Integer.toString(Integer.MAX_VALUE)));
                    this.secretTokenKey = this.getOptionalProperty(props, "secretTokenKey", null);
                    this.maxCheckTimeMillis = Long.parseLong(this.getOptionalProperty(props, "maxCheckTimeMillis", "-1"));
                    this.requestLimit = Integer.parseInt(this.getOptionalProperty(props, "requestLimit", "0"));
                    this.requestLimitPeriodInSeconds = Integer.parseInt(this.getOptionalProperty(props, "requestLimitPeriodInSeconds", "0"));
                    this.trustXForwardForHeader = Boolean.valueOf(this.getOptionalProperty(props, "trustXForwardForHeader", "false"));
                    this.maxWorkQueueSize = Integer.parseInt(this.getOptionalProperty(props, "maxWorkQueueSize", "0"));
                    if (this.maxWorkQueueSize < 0) {
                        throw new IllegalArgumentException("maxWorkQueueSize must be >= 0: " + this.maxWorkQueueSize);
                    }
                    String langModel = this.getOptionalProperty(props, "languageModel", null);
                    if (langModel != null && loadLangModel) {
                        this.setLanguageModelDirectory(langModel);
                    }
                    this.maxCheckThreads = Integer.parseInt(this.getOptionalProperty(props, "maxCheckThreads", "10"));
                    if (this.maxCheckThreads < 1) {
                        throw new IllegalArgumentException("Invalid value for maxCheckThreads, must be >= 1: " + this.maxCheckThreads);
                    }
                    boolean atdMode = this.getOptionalProperty(props, "mode", "LanguageTool").equalsIgnoreCase("AfterTheDeadline");
                    if (atdMode) {
                        throw new IllegalArgumentException("The AfterTheDeadline mode is not supported anymore in LanguageTool 3.8 or later");
                    }
                    String rulesConfigFilePath = this.getOptionalProperty(props, "rulesFile", null);
                    if (rulesConfigFilePath != null) {
                        this.rulesConfigFile = new File(rulesConfigFilePath);
                        if (!this.rulesConfigFile.exists() || !this.rulesConfigFile.isFile()) {
                            throw new RuntimeException("Rules Configuration file can not be found: " + this.rulesConfigFile);
                        }
                    }
                    this.cacheSize = Integer.parseInt(this.getOptionalProperty(props, "cacheSize", "0"));
                    if (this.cacheSize < 0) {
                        throw new IllegalArgumentException("Invalid value for cacheSize: " + this.cacheSize + ", use 0 to deactivate cache");
                    }
                    String warmUpStr = this.getOptionalProperty(props, "warmUp", "false");
                    if (warmUpStr.equals("true")) {
                        this.warmUp = true;
                        break block23;
                    }
                    if (warmUpStr.equals("false")) {
                        this.warmUp = false;
                        break block23;
                    }
                    throw new IllegalArgumentException("Invalid value for warmUp: '" + warmUpStr + "', use 'true' or 'false'");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load properties from '" + file + "'", e);
            }
        }
    }

    private void setLanguageModelDirectory(String langModelDir) {
        this.languageModelDir = new File(langModelDir);
        if (!this.languageModelDir.exists() || !this.languageModelDir.isDirectory()) {
            throw new RuntimeException("LanguageModel directory not found or is not a directory: " + this.languageModelDir);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getAllowOriginUrl() {
        return this.allowOriginUrl;
    }

    public void setMaxTextLength(int len) {
        this.maxTextLength = len;
    }

    public void setMaxTextHardLength(int len) {
        this.maxTextHardLength = len;
    }

    int getMaxTextLength() {
        return this.maxTextLength;
    }

    int getMaxTextHardLength() {
        return this.maxTextHardLength;
    }

    @Nullable
    String getSecretTokenKey() {
        return this.secretTokenKey;
    }

    int getRequestLimit() {
        return this.requestLimit;
    }

    int getRequestLimitPeriodInSeconds() {
        return this.requestLimitPeriodInSeconds;
    }

    void setMaxCheckTimeMillis(int maxCheckTimeMillis) {
        this.maxCheckTimeMillis = maxCheckTimeMillis;
    }

    long getMaxCheckTimeMillis() {
        return this.maxCheckTimeMillis;
    }

    @Nullable
    File getLanguageModelDir() {
        return this.languageModelDir;
    }

    Mode getMode() {
        return this.mode;
    }

    void setMaxCheckThreads(int maxCheckThreads) {
        this.maxCheckThreads = maxCheckThreads;
    }

    int getMaxCheckThreads() {
        return this.maxCheckThreads;
    }

    void setTrustXForwardForHeader(boolean trustXForwardForHeader) {
        this.trustXForwardForHeader = trustXForwardForHeader;
    }

    boolean getTrustXForwardForHeader() {
        return this.trustXForwardForHeader;
    }

    int getMaxWorkQueueSize() {
        return this.maxWorkQueueSize;
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    boolean getWarmUp() {
        return this.warmUp;
    }

    @Nullable
    File getRulesConfigFile() {
        return this.rulesConfigFile;
    }

    protected String getProperty(Properties props, String propertyName, File config) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            throw new IllegalConfigurationException("Property '" + propertyName + "' must be set in " + config);
        }
        return propertyValue;
    }

    protected String getOptionalProperty(Properties props, String propertyName, String defaultValue) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    static enum Mode {
        LanguageTool;

    }
}

