/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.apt.dispatch.IProcessorProvider;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;

public class RoundDispatcher {
    private final Set<TypeElement> _unclaimedAnnotations;
    private final RoundEnvironment _roundEnv;
    private final IProcessorProvider _provider;
    private boolean _searchForStar = false;
    private final PrintWriter _traceProcessorInfo;
    private final PrintWriter _traceRounds;
    private final List<ProcessorInfo> _processors;

    public RoundDispatcher(IProcessorProvider iProcessorProvider, RoundEnvironment roundEnvironment, Set<TypeElement> set, PrintWriter printWriter, PrintWriter printWriter2) {
        this._provider = iProcessorProvider;
        this._processors = iProcessorProvider.getDiscoveredProcessors();
        this._roundEnv = roundEnvironment;
        this._unclaimedAnnotations = new HashSet<TypeElement>(set);
        this._traceProcessorInfo = printWriter;
        this._traceRounds = printWriter2;
    }

    public void round() {
        Object object;
        Object object2;
        if (null != this._traceRounds) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("\tinput files: {");
            object = this._roundEnv.getRootElements().iterator();
            boolean bl = object.hasNext();
            while (bl) {
                ((StringBuilder)object2).append(object.next());
                bl = object.hasNext();
                if (!bl) continue;
                ((StringBuilder)object2).append(',');
            }
            ((StringBuilder)object2).append('}');
            this._traceRounds.println(((StringBuilder)object2).toString());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\tannotations: [");
            Iterator<TypeElement> iterator = this._unclaimedAnnotations.iterator();
            bl = iterator.hasNext();
            while (bl) {
                stringBuilder.append(iterator.next());
                bl = iterator.hasNext();
                if (!bl) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(']');
            this._traceRounds.println(stringBuilder.toString());
            this._traceRounds.println("\tlast round: " + this._roundEnv.processingOver());
        }
        this._searchForStar = this._unclaimedAnnotations.isEmpty();
        object2 = this._processors.iterator();
        while (object2.hasNext()) {
            object = (ProcessorInfo)object2.next();
            this.handleProcessor((ProcessorInfo)object);
        }
        while ((this._searchForStar || !this._unclaimedAnnotations.isEmpty()) && null != (object2 = this._provider.discoverNextProcessor())) {
            this.handleProcessor((ProcessorInfo)object2);
        }
    }

    private void handleProcessor(ProcessorInfo processorInfo) {
        try {
            HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
            boolean bl = processorInfo.computeSupportedAnnotations(this._unclaimedAnnotations, hashSet);
            if (bl) {
                boolean bl2 = processorInfo._processor.process(hashSet, this._roundEnv);
                if (null != this._traceProcessorInfo && !this._roundEnv.processingOver()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Processor ");
                    stringBuilder.append(processorInfo._processor.getClass().getName());
                    stringBuilder.append(" matches [");
                    Iterator iterator = hashSet.iterator();
                    boolean bl3 = iterator.hasNext();
                    while (bl3) {
                        stringBuilder.append(iterator.next());
                        bl3 = iterator.hasNext();
                        if (!bl3) continue;
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append("] and returns ");
                    stringBuilder.append(bl2);
                    this._traceProcessorInfo.println(stringBuilder.toString());
                }
                if (bl2) {
                    this._unclaimedAnnotations.removeAll(hashSet);
                    if (processorInfo.supportsStar()) {
                        this._searchForStar = false;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this._provider.reportProcessorException(processorInfo._processor, new Exception(throwable));
        }
    }
}

