#ifndef EFL_IO_READER_EO_HH
#define EFL_IO_READER_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_io_reader.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
namespace efl { namespace io { 
struct Reader;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Reader> : ::std::true_type {}; } }
namespace efl { namespace io { 
struct Reader;
} } 

namespace eo_cxx {
namespace efl { namespace io { 
struct Reader {
   ::efl::eolian::return_traits<bool>::type can_read_get() const;
   ::efl::eolian::return_traits<void>::type can_read_set( ::efl::eolian::in_traits<bool>::type can_read) const;
   ::efl::eolian::return_traits<bool>::type eos_get() const;
   ::efl::eolian::return_traits<void>::type eos_set( ::efl::eolian::in_traits<bool>::type is_eos) const;
   ::efl::eolian::return_traits<Eina_Error>::type read( ::efl::eolian::inout_traits<Eina_Rw_Slice>::type rw_slice) const;
   static Efl_Class const* _eo_class()
   {
      return EFL_IO_READER_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::io::Reader() const;
   operator ::efl::io::Reader&();
   operator ::efl::io::Reader const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Reader> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Reader const > operator&() const { return {this}; }
   /// @endcond
};
} } 
}
namespace efl { namespace io { 
struct Reader : ::efl::eo::concrete
{
   explicit Reader( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Reader(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Reader(Reader const& other) = default;
   Reader(Reader&& other) = default;
   Reader& operator=(Reader const& other) = default;
   Reader& operator=(Reader&& other) = default;
   Reader()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Reader( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Reader(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<bool>::type can_read_get() const;
   ::efl::eolian::return_traits<void>::type can_read_set( ::efl::eolian::in_traits<bool>::type can_read) const;
   ::efl::eolian::return_traits<bool>::type eos_get() const;
   ::efl::eolian::return_traits<void>::type eos_set( ::efl::eolian::in_traits<bool>::type is_eos) const;
   ::efl::eolian::return_traits<Eina_Error>::type read( ::efl::eolian::inout_traits<Eina_Rw_Slice>::type rw_slice) const;
   static Efl_Class const* _eo_class()
   {
      return EFL_IO_READER_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct can_read_changed_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IO_READER_EVENT_CAN_READ_CHANGED; }
      typedef void parameter_type;
   } const can_read_changed_event;
   static struct eos_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IO_READER_EVENT_EOS; }
      typedef void parameter_type;
   } const eos_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Reader> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Reader const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Reader) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Reader>::value, "");
} } 
#endif
