/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.UnsolicitedNotification;

final class UnsolicitedResponseImpl
implements UnsolicitedNotification {
    private String oid;
    private String[] referrals;
    private byte[] extensionValue;
    private NamingException exception;
    private Control[] controls;
    private static final long serialVersionUID = 5913778898401784775L;

    UnsolicitedResponseImpl(String oid, byte[] berVal, Vector<Vector<String>> ref, int status, String msg, String matchedDN, Control[] controls) {
        this.oid = oid;
        this.extensionValue = berVal;
        if (ref != null && ref.size() > 0) {
            int len = ref.size();
            this.referrals = new String[len];
            for (int i = 0; i < len; ++i) {
                this.referrals[i] = ref.elementAt(i).elementAt(0);
            }
        }
        this.exception = LdapCtx.mapErrorCode(status, msg);
        this.controls = controls;
    }

    @Override
    public String getID() {
        return this.oid;
    }

    @Override
    public byte[] getEncodedValue() {
        return this.extensionValue;
    }

    @Override
    public String[] getReferrals() {
        return this.referrals;
    }

    @Override
    public NamingException getException() {
        return this.exception;
    }

    @Override
    public Control[] getControls() throws NamingException {
        return this.controls;
    }
}

