'''OpenGL extension OES.texture_cube_map

This module customises the behaviour of the 
OpenGL.raw.GLES1.OES.texture_cube_map to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/texture_cube_map.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.OES.texture_cube_map import *
from OpenGL.raw.GLES1.OES.texture_cube_map import _EXTENSION_NAME

def glInitTextureCubeMapOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glTexGenfvOES.params size not checked against 'pname'
glTexGenfvOES=wrapper.wrapper(glTexGenfvOES).setInputArraySize(
    'params', None
)
# INPUT glTexGenivOES.params size not checked against 'pname'
glTexGenivOES=wrapper.wrapper(glTexGenivOES).setInputArraySize(
    'params', None
)
# INPUT glTexGenxvOES.params size not checked against 'pname'
glTexGenxvOES=wrapper.wrapper(glTexGenxvOES).setInputArraySize(
    'params', None
)
# INPUT glGetTexGenfvOES.params size not checked against 'pname'
glGetTexGenfvOES=wrapper.wrapper(glGetTexGenfvOES).setInputArraySize(
    'params', None
)
# INPUT glGetTexGenivOES.params size not checked against 'pname'
glGetTexGenivOES=wrapper.wrapper(glGetTexGenivOES).setInputArraySize(
    'params', None
)
# INPUT glGetTexGenxvOES.params size not checked against 'pname'
glGetTexGenxvOES=wrapper.wrapper(glGetTexGenxvOES).setInputArraySize(
    'params', None
)
### END AUTOGENERATED SECTION