/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import java.io.IOException;

public class DimenRegister
extends Register
implements TeXDimension {
    private TeXGlue dimension;

    public DimenRegister(String string) {
        this(string, 0.0f, FixedUnit.SP);
    }

    public DimenRegister(String string, float f, TeXUnit teXUnit) {
        this(string, new TeXGlue());
        try {
            this.dimension.setDimension(null, new UserDimension(f, teXUnit));
        }
        catch (TeXSyntaxException teXSyntaxException) {
            // empty catch block
        }
    }

    public DimenRegister(String string, TeXGlue teXGlue) {
        super(string);
        this.dimension = teXGlue;
    }

    @Override
    public void setValue(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        if (!(numerical instanceof TeXDimension)) {
            this.dimension.setDimension(teXParser, new UserDimension(numerical.number(teXParser), (TeXUnit)FixedUnit.SP));
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", numerical.toString(teXParser));
        }
        this.setDimension(teXParser, (TeXDimension)numerical);
    }

    @Override
    public void setDimension(TeXParser teXParser, TeXDimension teXDimension) throws TeXSyntaxException {
        this.dimension.setDimension(teXParser, teXDimension);
    }

    public TeXDimension getDimension() {
        return this.dimension;
    }

    @Override
    public float getValue() {
        return this.dimension.getValue();
    }

    @Override
    public TeXUnit getUnit() {
        return this.dimension.getUnit();
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.dimension.number(teXParser);
    }

    @Override
    public TeXObject the(TeXParser teXParser) throws TeXSyntaxException {
        return teXParser.string(this.dimension.toString(teXParser));
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.dimension.advance(teXParser, numerical);
    }

    @Override
    public void multiply(int n) {
        this.dimension.multiply(n);
    }

    @Override
    public void multiply(float f) {
        this.dimension.multiply(f);
    }

    @Override
    public void divide(int n) {
        this.dimension.divide(n);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = teXParser.popStack(teXParser, true);
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXParser.addAll(teXObjectList);
            teXObject = teXParser.popStack(teXParser, true);
        }
        if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 61 && (teXObject = teXParser.popStack(teXParser, true)) instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXParser.addAll(teXObjectList);
            teXObject = teXParser.popStack(teXParser, true);
        }
        if (teXObject instanceof Register) {
            this.setValue(teXParser, (Register)teXObject);
            return;
        }
        teXParser.push(teXObject);
        this.setValue(teXParser, teXParser.popDimension());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject = teXObjectList.popStack(teXParser, true);
        if (teXObject instanceof Expandable && (teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObjectList.addAll(teXObjectList2);
            teXObject = teXObjectList.popStack(teXParser, true);
        }
        if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == 61 && (teXObject = teXObjectList.popStack(teXParser, true)) instanceof Expandable && (teXObjectList2 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObjectList.addAll(teXObjectList2);
            teXObject = teXObjectList.popStack(teXParser, true);
        }
        if (teXObject instanceof Register) {
            this.setValue(teXParser, (Register)teXObject);
            return;
        }
        teXObjectList.push(teXObject);
        this.setValue(teXParser, teXObjectList.popDimension(teXParser));
    }

    @Override
    public Object clone() {
        return new DimenRegister(this.getName(), (TeXGlue)this.dimension.clone());
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,value=%s]", this.getClass().getSimpleName(), this.getName(), this.dimension);
    }
}

