/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.jmlr;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXCls;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.StoreDataCs;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrAddr;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrEmail;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrKeywords;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrName;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrObjectRef;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrObjectTypeRef;
import com.dickimawbooks.texparserlib.latex.jmlr.JmlrProceedings;
import com.dickimawbooks.texparserlib.latex.jmlr.ObsoleteFontCs;
import java.io.IOException;
import java.util.Vector;

public class JmlrCls
extends LaTeXCls {
    private Vector<Group> authors = null;

    public JmlrCls(KeyValList keyValList, LaTeXParserListener laTeXParserListener) throws IOException {
        this(keyValList, "jmlr", laTeXParserListener);
    }

    public JmlrCls(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener) throws IOException {
        super(keyValList, string, laTeXParserListener);
    }

    @Override
    public void addDefinitions() {
        LaTeXParserListener laTeXParserListener = this.getListener();
        this.registerControlSequence(new StoreDataCs("jmlrworkshop"));
        this.registerControlSequence(new StoreDataCs("jmlryear"));
        this.registerControlSequence(new StoreDataCs("jmlrvolume"));
        this.registerControlSequence(new StoreDataCs("jmlrissue"));
        this.registerControlSequence(new StoreDataCs("jmlrpages"));
        this.registerControlSequence(new StoreDataCs("jmlrsubmitted"));
        this.registerControlSequence(new StoreDataCs("jmlrpublished"));
        this.registerControlSequence(new StoreDataCs("jmlrauthors", "@jmlr@authors"));
        this.registerControlSequence(new StoreDataCs("editor"));
        this.registerControlSequence(new StoreDataCs("editors"));
        this.registerControlSequence(new StoreDataCs("title", "@shorttitle", "@title"));
        this.registerControlSequence(new StoreDataCs("author", "@shortauthor", "@author"));
        this.registerControlSequence(new GenericCommand("editorname", null, laTeXParserListener.createString("Editor")));
        this.registerControlSequence(new GenericCommand("editorsname", null, laTeXParserListener.createString("Editors")));
        this.registerControlSequence(new GenericCommand("sectionrefname", null, laTeXParserListener.createString("Section")));
        this.registerControlSequence(new GenericCommand("sectionsrefname", null, laTeXParserListener.createString("Sections")));
        this.registerControlSequence(new GenericCommand("equationrefname", null, laTeXParserListener.createString("Equation")));
        this.registerControlSequence(new GenericCommand("equationsrefname", null, laTeXParserListener.createString("Equations")));
        this.registerControlSequence(new GenericCommand("tablerefname", null, laTeXParserListener.createString("Table")));
        this.registerControlSequence(new GenericCommand("tablesrefname", null, laTeXParserListener.createString("Tables")));
        this.registerControlSequence(new GenericCommand("figurerefname", null, laTeXParserListener.createString("Figure")));
        this.registerControlSequence(new GenericCommand("figuresrefname", null, laTeXParserListener.createString("Figures")));
        this.registerControlSequence(new GenericCommand("algorithmrefname", null, laTeXParserListener.createString("Algorithm")));
        this.registerControlSequence(new GenericCommand("algorithmsrefname", null, laTeXParserListener.createString("Algorithms")));
        this.registerControlSequence(new GenericCommand("theoremrefname", null, laTeXParserListener.createString("Theorem")));
        this.registerControlSequence(new GenericCommand("theoremsrefname", null, laTeXParserListener.createString("Theorems")));
        this.registerControlSequence(new GenericCommand("lemmarefname", null, laTeXParserListener.createString("Lemma")));
        this.registerControlSequence(new GenericCommand("lemmasrefname", null, laTeXParserListener.createString("Lemmas")));
        this.registerControlSequence(new GenericCommand("remarkrefname", null, laTeXParserListener.createString("Remark")));
        this.registerControlSequence(new GenericCommand("remarksrefname", null, laTeXParserListener.createString("Remarks")));
        this.registerControlSequence(new GenericCommand("corollaryrefname", null, laTeXParserListener.createString("Corollary")));
        this.registerControlSequence(new GenericCommand("corollarysrefname", null, laTeXParserListener.createString("Corollaries")));
        this.registerControlSequence(new GenericCommand("definitionrefname", null, laTeXParserListener.createString("Definition")));
        this.registerControlSequence(new GenericCommand("definitionsrefname", null, laTeXParserListener.createString("Definitions")));
        this.registerControlSequence(new GenericCommand("axiomrefname", null, laTeXParserListener.createString("Axiom")));
        this.registerControlSequence(new GenericCommand("axiomsrefname", null, laTeXParserListener.createString("Axioms")));
        this.registerControlSequence(new GenericCommand("examplerefname", null, laTeXParserListener.createString("Example")));
        this.registerControlSequence(new GenericCommand("examplesrefname", null, laTeXParserListener.createString("Examples")));
        this.registerControlSequence(new GenericCommand("appendixrefname", null, laTeXParserListener.createString("Appendix")));
        this.registerControlSequence(new GenericCommand("appendixsrefname", null, laTeXParserListener.createString("Appendices")));
        this.registerControlSequence(new GenericCommand("partrefname", null, laTeXParserListener.createString("Part")));
        this.registerControlSequence(new GenericCommand("partsrefname", null, laTeXParserListener.createString("Parts")));
        this.registerControlSequence(new GenericCommand("@jmlr@reflistsep", null, laTeXParserListener.createString(", ")));
        this.registerControlSequence(new GenericCommand("@jmlr@reflistlastsep", null, laTeXParserListener.createString(" and ")));
        this.registerControlSequence(new JmlrKeywords());
        this.registerControlSequence(new JmlrName(this));
        this.registerControlSequence(new JmlrEmail());
        this.registerControlSequence(new JmlrAddr());
        this.registerControlSequence(new JmlrObjectRef());
        this.registerControlSequence(new JmlrObjectTypeRef("section"));
        this.registerControlSequence(new JmlrObjectTypeRef("equation", laTeXParserListener.createString("("), laTeXParserListener.createString(")")));
        this.registerControlSequence(new JmlrObjectTypeRef("table"));
        this.registerControlSequence(new JmlrObjectTypeRef("figure"));
        this.registerControlSequence(new JmlrObjectTypeRef("algorithm"));
        this.registerControlSequence(new JmlrObjectTypeRef("theorem"));
        this.registerControlSequence(new JmlrObjectTypeRef("lemma"));
        this.registerControlSequence(new JmlrObjectTypeRef("remark"));
        this.registerControlSequence(new JmlrObjectTypeRef("corollary"));
        this.registerControlSequence(new JmlrObjectTypeRef("definition"));
        this.registerControlSequence(new JmlrObjectTypeRef("conjecture"));
        this.registerControlSequence(new JmlrObjectTypeRef("axiom"));
        this.registerControlSequence(new JmlrObjectTypeRef("exampleref"));
        this.registerControlSequence(new JmlrObjectTypeRef("appendix"));
        this.registerControlSequence(new JmlrObjectTypeRef("part"));
    }

    protected void loadPreHyperrefPackages() throws IOException {
        LaTeXParserListener laTeXParserListener = this.getListener();
        laTeXParserListener.usepackage(null, "xkeyval");
        laTeXParserListener.usepackage(null, "calc");
        laTeXParserListener.usepackage(null, "etoolbox");
        laTeXParserListener.usepackage(null, "amsmath");
        laTeXParserListener.usepackage(null, "amssymb");
        LaTeXSty laTeXSty = laTeXParserListener.usepackage(null, "natbib");
        if (laTeXSty == null) {
            laTeXSty = laTeXParserListener.getLoadedPackage("natbib");
        }
        if (laTeXSty != null) {
            laTeXSty.processOption("round");
        }
        laTeXParserListener.usepackage(null, "graphicx");
        laTeXParserListener.usepackage(null, "url");
        KeyValList keyValList = new KeyValList();
        keyValList.put("x11names", new GenericCommand("empty"));
        laTeXParserListener.usepackage(keyValList, "xcolor");
        keyValList = new KeyValList();
        keyValList.put("algo2e", new GenericCommand("empty"));
        keyValList.put("ruled", new GenericCommand("empty"));
        laTeXParserListener.usepackage(keyValList, "algorithm2e");
    }

    @Override
    protected void preOptions() throws IOException {
        LaTeXParserListener laTeXParserListener = this.getListener();
        TeXParser teXParser = laTeXParserListener.getParser();
        this.loadPreHyperrefPackages();
        ControlSequence controlSequence = teXParser.getControlSequence("jmlrprehyperref");
        if (controlSequence == null) {
            this.registerControlSequence(new GenericCommand("jmlrprehyperref"));
        } else {
            controlSequence.process(teXParser);
        }
        laTeXParserListener.usepackage(null, "hyperref");
        laTeXParserListener.usepackage(null, "nameref");
        this.registerControlSequence(new GenericCommand("@jmlrproceedings", null, laTeXParserListener.createString("Journal of Machine Learning Research")));
        this.registerControlSequence(new GenericCommand("@jmlrabbrvproceedings", null, laTeXParserListener.createString("JMLR")));
        this.registerControlSequence(new JmlrProceedings());
        this.registerControlSequence(new ObsoleteFontCs());
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("jmlrproceedings"));
        teXObjectList.add(laTeXParserListener.createGroup("JMLR"));
        teXObjectList.add(laTeXParserListener.createGroup("Journal of Machine Learning Research"));
        this.registerControlSequence(new GenericCommand("jmlrnowcp", null, teXObjectList));
        teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("jmlrproceedings"));
        Group group = laTeXParserListener.createGroup("JMLR ");
        group.add(new TeXCsRef("&"));
        group.add(laTeXParserListener.getLetter(67));
        group.add(laTeXParserListener.getLetter(80));
        teXObjectList.add(group);
        teXObjectList.add(laTeXParserListener.createGroup("JMLR: Workshop and Conference Proceedings"));
        this.registerControlSequence(new GenericCommand("jmlrwcp", null, teXObjectList));
        this.registerControlSequence(new AtSecondOfTwo("ifprint"));
    }

    @Override
    public void processOption(String string) throws IOException {
        LaTeXParserListener laTeXParserListener = this.getListener();
        if (string.equals("nowcp")) {
            laTeXParserListener.getControlSequence("jmlrnowcp").process(laTeXParserListener.getParser());
        } else if (string.equals("wcp")) {
            laTeXParserListener.getControlSequence("jmlrwcp").process(laTeXParserListener.getParser());
        } else if (string.equals("color")) {
            this.registerControlSequence(new AtSecondOfTwo("ifprint"));
        } else if (string.equals("gray")) {
            this.registerControlSequence(new AtFirstOfTwo("ifprint"));
        }
    }

    public void addAuthor(Group group) {
        if (this.authors == null) {
            this.authors = new Vector();
        }
        this.authors.add(group);
    }

    public Vector<Group> getAuthors() {
        return this.authors;
    }
}

