/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.siunitx;

import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.SbChar;
import com.dickimawbooks.texparserlib.SpChar;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.siunitx.SIPrefixCs;
import com.dickimawbooks.texparserlib.latex.siunitx.SIUnitCs;
import com.dickimawbooks.texparserlib.latex.siunitx.Si;
import com.dickimawbooks.texparserlib.latex.siunitx.SiPer;
import com.dickimawbooks.texparserlib.latex.siunitx.SiPower;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.IOException;

public class SIunitxSty
extends LaTeXSty {
    private static final String[][] BASE_UNITS = new String[][]{{"ampere", "A"}, {"candela", "cd"}, {"kelvin", "\u212a"}, {"kilogram", "kg"}, {"gram", "g"}, {"metre", "m"}, {"meter", "m"}, {"mole", "mol"}, {"second", "s"}};
    private static final String[][] DERIVED_UNITS = new String[][]{{"becquerel", "Bq"}, {"degreeCelsius", "\u2103"}, {"coulomb", "C"}, {"farad", "F"}, {"gray", "Gy"}, {"hertz", "Hz"}, {"henry", "H"}, {"joule", "J"}, {"katal", "kat"}, {"lumen", "lm"}, {"lux", "lx"}, {"newton", "N"}, {"ohm", "\u2126"}, {"pascal", "Pa"}, {"radian", "rad"}, {"siemens", "S"}, {"sievert", "Sv"}, {"steradian", "sr"}, {"tesla", "T"}, {"volt", "V"}, {"watt", "W"}, {"weber", "Wb"}};
    private static final String[][] NON_SI_UNITS = new String[][]{{"day", "d"}, {"degree", "\u00b0"}, {"hectare", "ha"}, {"hour", "h"}, {"litre", "l"}, {"liter", "L"}, {"minute", "min"}, {"arcminute", "\u2032"}, {"arcsecond", "\u2033"}, {"tonne", "t"}, {"angstrom", "\u212b"}, {"bar", "bar"}, {"barn", "b"}, {"bel", "B"}, {"decibel", "dB"}, {"knot", "kn"}, {"mmHg", "mmHg"}, {"nauticalmile", "M"}, {"neper", "Np"}, {"astronomicalunit", "ua"}, {"atomicmassunit", "u"}, {"dalton", "Da"}, {"electronvolt", "eV"}, {"bohr", new String(new int[]{119886, 8320}, 0, 2)}, {"clight", new String(new int[]{119888, 8320}, 0, 2)}, {"electronmass", new String(new int[]{119898, 8337}, 0, 2)}, {"elementarycharge", new String(new int[]{119890}, 0, 1)}, {"hartree", new String(new int[]{119864, 8341}, 0, 2)}, {"planckbar", "\u210f"}};
    private static final String[][] ABBREVIATED_UNITS = new String[][]{{"fg", "fg"}, {"pg", "pg"}, {"ng", "ng"}, {"ug", new String(new int[]{181, 103}, 0, 2)}, {"mg", "mg"}, {"g", "g"}, {"kg", "kg"}, {"amu", "u"}, {"pm", "pm"}, {"nm", "nm"}, {"um", new String(new int[]{181, 109}, 0, 2)}, {"mm", "mm"}, {"cm", "cm"}, {"dm", "dm"}, {"m", "m"}, {"km", "km"}, {"as", "as"}, {"fs", "fs"}, {"ps", "ps"}, {"ns", "ns"}, {"us", new String(new int[]{181, 115}, 0, 2)}, {"ms", "ms"}, {"s", "s"}, {"fmol", "fmol"}, {"pmol", "pmol"}, {"nmol", "nmol"}, {"umol", new String(new int[]{181, 109, 111, 108}, 0, 4)}, {"mmol", "mmol"}, {"mol", "mol"}, {"kmol", "kmol"}, {"pA", "pA"}, {"nA", "nA"}, {"uA", new String(new int[]{181, 65}, 0, 2)}, {"A", "A"}, {"kA", "kA"}, {"ul", new String(new int[]{181, 108}, 0, 2)}, {"ml", "ml"}, {"l", "l"}, {"hl", "hl"}, {"uL", new String(new int[]{181, 76}, 0, 2)}, {"mL", "mL"}, {"L", "L"}, {"hL", "hL"}, {"mHz", "mHz"}, {"Hz", "Hz"}, {"kHz", "kHz"}, {"MHz", "MHz"}, {"GHz", "GHz"}, {"THz", "THz"}, {"mN", "mN"}, {"N", "N"}, {"kN", "kN"}, {"MN", "MN"}, {"Pa", "Pa"}, {"kPa", "kPa"}, {"MPa", "MPa"}, {"GPa", "GPa"}, {"mohm", new String(new int[]{109, 8486}, 0, 2)}, {"kohm", new String(new int[]{107, 8486}, 0, 2)}, {"Mohm", new String(new int[]{77, 8486}, 0, 2)}, {"pV", "pV"}, {"nV", "nV"}, {"uV", new String(new int[]{181, 86}, 0, 2)}, {"mV", "mV"}, {"V", "V"}, {"kV", "kV"}, {"W", "W"}, {"uW", new String(new int[]{181, 87}, 0, 2)}, {"mW", "mW"}, {"kW", "kW"}, {"MW", "MW"}, {"GW", "GW"}, {"J", "J"}, {"kJ", "kJ"}, {"eV", "eV"}, {"meV", "meV"}, {"keV", "keV"}, {"MeV", "MeV"}, {"GeV", "GeV"}, {"TeV", "TeV"}, {"kWh", "kWh"}, {"F", "F"}, {"fF", "fF"}, {"pF", "pF"}, {"K", "\u212a"}, {"dB", "dB"}};
    private static final String[][] PREFIXES = new String[][]{{"centi", "c"}, {"kilo", "k"}, {"milli", "m"}, {"mega", "M"}, {"giga", "G"}, {"tera", "T"}, {"yocto", "y"}, {"zepto", "z"}, {"atto", "a"}, {"femto", "f"}, {"pico", "p"}, {"nano", "n"}, {"micro", "\u00b5"}, {"deci", "d"}, {"deca", "da"}, {"hecto", "h"}, {"peta", "P"}, {"exa", "E"}, {"zetta", "Z"}, {"yotta", "Y"}};
    private static final String[][] BINARY_PREFIXES = new String[][]{{"kibi", "Ki"}, {"mebi", "Mi"}, {"gibi", "Gi"}, {"tebi", "Ti"}, {"pebi", "Pi"}, {"exbi", "Ei"}, {"zebi", "Zi"}, {"yobi", "Yi"}};
    public static final int UNIT_SEP = 8287;

    public SIunitxSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener) throws IOException {
        super(keyValList, "siunitx", laTeXParserListener);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new Si(this));
    }

    @Override
    public void processOption(String string) throws IOException {
    }

    @Override
    protected void preOptions() throws IOException {
    }

    public TeXObject parseUnit(TeXParser teXParser, TeXObject teXObject) throws IOException {
        if (teXObject instanceof ControlSequence) {
            TeXObject teXObject2 = this.getUnit((ControlSequence)teXObject);
            return teXObject2 == null ? teXObject : teXObject2;
        }
        if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList = new TeXObjectList();
            this.parseUnits(teXParser, (TeXObjectList)teXObject, teXObjectList);
            return teXObjectList;
        }
        return teXObject;
    }

    private void parseUnits(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        int n = teXObjectList.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                int n2 = ((CharObject)teXObject).getCharCode();
                if (n2 == 46 || n2 == 126) {
                    teXObjectList2.add(this.createUnitSep(teXParser));
                    continue;
                }
                teXObjectList2.add(teXObject);
                continue;
            }
            if (teXObject instanceof SbChar) {
                if (teXParser.isMathMode()) {
                    teXObjectList2.add(teXObject);
                    if (i >= n - 1 || this.isNumber((TeXObject)teXObjectList.get(i + 1))) continue;
                    Group group = SIunitxSty.createText(teXParser);
                    group.add((TeXObject)teXObjectList.get(++i));
                    continue;
                }
                teXObjectList2.add(new TeXCsRef("textsubscript"));
                continue;
            }
            if (teXObject instanceof SpChar) {
                if (teXParser.isMathMode()) {
                    teXObjectList2.add(teXObject);
                    if (i >= n - 1 || this.isNumber((TeXObject)teXObjectList.get(i + 1))) continue;
                    Group group = SIunitxSty.createText(teXParser);
                    group.add((TeXObject)teXObjectList.get(++i));
                    continue;
                }
                teXObjectList2.add(new TeXCsRef("textsuperscript"));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                teXObjectList2.add(this.getFormatting(teXParser, (ControlSequence)teXObject));
                continue;
            }
            teXObjectList2.add(teXObject);
        }
    }

    private TeXObject getFormatting(TeXParser teXParser, ControlSequence controlSequence) throws IOException {
        String string = controlSequence.getName();
        if (string.equals("per")) {
            return new SiPer(this);
        }
        if (string.equals("square")) {
            return new SiPer(this, "square", 2);
        }
        if (string.equals("cubic")) {
            return new SiPer(this, "cubic", 3);
        }
        if (string.equals("squared")) {
            return new SiPower(this, "squared", 2);
        }
        TeXObject teXObject = this.getUnit(controlSequence);
        return teXObject == null ? controlSequence : teXObject;
    }

    public TeXObject createUnitSep(TeXParser teXParser) throws IOException {
        return teXParser.getListener().getOther(8287);
    }

    public static Group createText(TeXParser teXParser) throws IOException {
        Group group = teXParser.getListener().createGroup();
        ControlSequence controlSequence = teXParser.getControlSequence("text");
        if (controlSequence instanceof Undefined) {
            group.add(new TeXCsRef("mathrm"));
        } else {
            group.add(controlSequence);
        }
        return group;
    }

    public static TeXObjectList createText(TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        ControlSequence controlSequence = teXParser.getControlSequence("text");
        if (controlSequence instanceof Undefined) {
            teXObjectList.add(new TeXCsRef("mathrm"));
        } else {
            teXObjectList.add(controlSequence);
        }
        teXObjectList.add(teXObject);
        return teXObjectList;
    }

    private boolean isNumber(TeXObject teXObject) {
        int n;
        if (teXObject instanceof TeXNumber) {
            return true;
        }
        if (!(teXObject instanceof TeXObjectList)) {
            return teXObject instanceof CharObject && Character.isDigit(((CharObject)teXObject).getCharCode());
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        int n2 = teXObjectList.size();
        if (n2 == 0) {
            return false;
        }
        TeXObject teXObject2 = (TeXObject)teXObjectList.get(0);
        if (teXObject2 instanceof CharObject && !Character.isDigit(n = ((CharObject)teXObject2).getCharCode()) && n != 43 && n != 45) {
            return false;
        }
        for (n = 1; n < n2; ++n) {
            if (teXObject2 instanceof CharObject) {
                if (Character.isDigit(((CharObject)teXObject2).getCharCode())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public TeXObject getUnit(ControlSequence controlSequence) {
        String string = controlSequence.getName();
        String string2 = this.getUnit(string, BASE_UNITS);
        if (string2 != null) {
            return new SIUnitCs(this, string, string2);
        }
        string2 = this.getUnit(string, PREFIXES);
        if (string2 != null) {
            return new SIPrefixCs(this, string, string2);
        }
        string2 = this.getUnit(string, BINARY_PREFIXES);
        if (string2 != null) {
            return new SIPrefixCs(this, string, string2);
        }
        string2 = this.getUnit(string, DERIVED_UNITS);
        if (string2 != null) {
            return new SIUnitCs(this, string, string2);
        }
        string2 = this.getUnit(string, NON_SI_UNITS);
        if (string2 != null) {
            return new SIUnitCs(this, string, string2);
        }
        string2 = this.getUnit(string, ABBREVIATED_UNITS);
        if (string2 != null) {
            return new SIUnitCs(this, string, string2);
        }
        return null;
    }

    public String getUnit(String string, String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i][0].equals(string)) continue;
            return stringArray[i][1];
        }
        return null;
    }
}

