/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.CredentialsEndpointProvider;
import com.amazonaws.internal.EC2CredentialsUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
class EC2CredentialsFetcher {
    private static final Log LOG = LogFactory.getLog(EC2CredentialsFetcher.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int EXPIRATION_THRESHOLD = 900000;
    private static final String ACCESS_KEY_ID = "AccessKeyId";
    private static final String SECRET_ACCESS_KEY = "SecretAccessKey";
    private static final String TOKEN = "Token";
    private volatile AWSCredentials credentials;
    private volatile Date credentialsExpiration;
    protected volatile Date lastInstanceProfileCheck;
    private final CredentialsEndpointProvider credentailsEndpointProvider;

    public EC2CredentialsFetcher(CredentialsEndpointProvider credentailsEndpointProvider) {
        this.credentailsEndpointProvider = credentailsEndpointProvider;
    }

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.fetchCredentials();
        }
        if (this.expired()) {
            throw new AmazonClientException("The credentials received have been expired");
        }
        return this.credentials;
    }

    protected boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null && this.isWithinExpirationThreshold()) {
            return true;
        }
        return this.lastInstanceProfileCheck != null && this.isPastRefreshThreshold();
    }

    private synchronized void fetchCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String credentialsResponse = EC2CredentialsUtils.getInstance().readResource(this.credentailsEndpointProvider.getCredentialsEndpoint(), this.credentailsEndpointProvider.getRetryPolicy());
            JsonNode node2 = Jackson.jsonNodeOf(credentialsResponse);
            JsonNode accessKey = node2.get(ACCESS_KEY_ID);
            JsonNode secretKey = node2.get(SECRET_ACCESS_KEY);
            JsonNode token = node2.get(TOKEN);
            if (null == accessKey || null == secretKey) {
                throw new AmazonClientException("Unable to load credentials.");
            }
            this.credentials = null != token ? new BasicSessionCredentials(accessKey.asText(), secretKey.asText(), token.asText()) : new BasicAWSCredentials(accessKey.asText(), secretKey.asText());
            JsonNode expirationJsonNode = node2.get("Expiration");
            if (null != expirationJsonNode) {
                String expiration = expirationJsonNode.asText();
                expiration = expiration.replaceAll("\\+0000$", "Z");
                try {
                    this.credentialsExpiration = DateUtils.parseISO8601Date(expiration);
                }
                catch (Exception ex) {
                    this.handleError("Unable to parse credentials expiration date from Amazon EC2 instance", ex);
                }
            }
        }
        catch (JsonMappingException e2) {
            this.handleError("Unable to parse response returned from service endpoint", e2);
        }
        catch (IOException e3) {
            this.handleError("Unable to load credentials from service endpoint", e3);
        }
        catch (URISyntaxException e4) {
            this.handleError("Unable to load credentials from service endpoint", e4);
        }
    }

    private void handleError(String errorMessage, Exception e2) {
        if (this.credentials == null || this.expired()) {
            throw new AmazonClientException(errorMessage, e2);
        }
        LOG.debug(errorMessage, e2);
    }

    public void refresh() {
        this.credentials = null;
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialsExpiration.getTime() - System.currentTimeMillis() < 900000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private boolean expired() {
        return this.credentialsExpiration != null && this.credentialsExpiration.getTime() < System.currentTimeMillis();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsExpiration;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

