/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.fop.fonts.CIDSet;
import org.apache.fop.fonts.MultiByteFont;

public class CIDSubset
implements CIDSet {
    private Map<Integer, Integer> usedGlyphs = new LinkedHashMap<Integer, Integer>();
    private Map<Integer, Integer> usedGlyphsIndex = new HashMap<Integer, Integer>();
    private int usedGlyphsCount;
    private Map<Integer, Character> usedCharsIndex = new HashMap<Integer, Character>();
    private Map<Character, Integer> charToGIDs = new HashMap<Character, Integer>();
    private final MultiByteFont font;

    public CIDSubset(MultiByteFont mbf) {
        this.font = mbf;
        this.usedGlyphs.put(0, 0);
        this.usedGlyphsIndex.put(0, 0);
        ++this.usedGlyphsCount;
    }

    @Override
    public int getOriginalGlyphIndex(int index) {
        Integer glyphIndex = this.usedGlyphsIndex.get(index);
        if (glyphIndex != null) {
            return glyphIndex;
        }
        return -1;
    }

    @Override
    public char getUnicode(int index) {
        Character mapValue = this.usedCharsIndex.get(index);
        if (mapValue != null) {
            return mapValue.charValue();
        }
        return '\uffff';
    }

    @Override
    public int mapChar(int glyphIndex, char unicode) {
        Integer subsetCharSelector = this.usedGlyphs.get(glyphIndex);
        if (subsetCharSelector == null) {
            int selector = this.usedGlyphsCount++;
            this.usedGlyphs.put(glyphIndex, selector);
            this.usedGlyphsIndex.put(selector, glyphIndex);
            this.usedCharsIndex.put(selector, Character.valueOf(unicode));
            this.charToGIDs.put(Character.valueOf(unicode), glyphIndex);
            return selector;
        }
        return subsetCharSelector;
    }

    @Override
    public Map<Integer, Integer> getGlyphs() {
        return Collections.unmodifiableMap(this.usedGlyphs);
    }

    @Override
    public char getUnicodeFromGID(int glyphIndex) {
        int selector = this.usedGlyphs.get(glyphIndex);
        return this.usedCharsIndex.get(selector).charValue();
    }

    @Override
    public int getGIDFromChar(char ch) {
        return this.charToGIDs.get(Character.valueOf(ch));
    }

    @Override
    public char[] getChars() {
        char[] charArray = new char[this.usedGlyphsCount];
        for (int i = 0; i < this.usedGlyphsCount; ++i) {
            charArray[i] = this.getUnicode(i);
        }
        return charArray;
    }

    @Override
    public int getNumberOfGlyphs() {
        return this.usedGlyphsCount;
    }

    @Override
    public BitSet getGlyphIndices() {
        BitSet bitset = new BitSet();
        for (Integer cid : this.usedGlyphs.keySet()) {
            bitset.set(cid);
        }
        return bitset;
    }

    @Override
    public int[] getWidths() {
        int[] widths = this.font.getWidths();
        int[] tmpWidth = new int[this.getNumberOfGlyphs()];
        int c = this.getNumberOfGlyphs();
        for (int i = 0; i < c; ++i) {
            int nwx = Math.max(0, this.getOriginalGlyphIndex(i));
            tmpWidth[i] = widths[nwx];
        }
        return tmpWidth;
    }
}

