/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import java.util.Arrays;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampCharMap
extends TimestampMap<Character> {
    private char[] values;

    public TimestampCharMap() {
        this.values = new char[0];
    }

    public TimestampCharMap(int capacity) {
        super(capacity);
        this.values = new char[capacity];
    }

    public TimestampCharMap(double[] keys, char[] vals) {
        super(keys);
        this.values = new char[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public char getCharacter(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public char getCharacter(double timestamp, char defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    protected Object getMin(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        double lowBound = interval.getLow();
        double highBound = interval.getHigh();
        int index = Arrays.binarySearch(this.array, lowBound);
        if (index < 0) {
            index = -index - 1;
        }
        char min = '\uffff';
        boolean found = false;
        for (int i = index; i < this.size && this.array[i] <= highBound; ++i) {
            char val = this.values[i];
            min = (char)Math.min(min, val);
            found = true;
        }
        if (!found) {
            return null;
        }
        return Character.valueOf(min);
    }

    @Override
    protected Object getMax(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        double lowBound = interval.getLow();
        double highBound = interval.getHigh();
        int index = Arrays.binarySearch(this.array, lowBound);
        if (index < 0) {
            index = -index - 1;
        }
        char max = '\u0000';
        boolean found = false;
        for (int i = index; i < this.size && this.array[i] <= highBound; ++i) {
            char val = this.values[i];
            max = (char)Math.max(max, val);
            found = true;
        }
        if (!found) {
            return null;
        }
        return Character.valueOf(max);
    }

    @Override
    public Class<Character> getTypeClass() {
        return Character.class;
    }

    public char[] toCharacterArray() {
        return (char[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.FIRST, Estimator.LAST);
    }

    @Override
    protected Character getValue(int index) {
        return Character.valueOf(this.values[index]);
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (char[])array;
    }
}

