/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.CoercingStringValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ComponentVariantResolveMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultMutableIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.IvyDependencyMetadata;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenDependencyMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableComponentVariantResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ModuleMetadataSerializer {
    private static final byte TYPE_IVY = 1;
    private static final byte TYPE_MAVEN = 2;
    private static final byte STRING_ATTRIBUTE = 1;
    private static final byte BOOLEAN_ATTRIBUTE = 2;
    private static final ModuleComponentSelectorSerializer COMPONENT_SELECTOR_SERIALIZER = new ModuleComponentSelectorSerializer();
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator instantiator;

    public ModuleMetadataSerializer(ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator instantiator) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
    }

    public MutableModuleComponentResolveMetadata read(Decoder decoder, ImmutableModuleIdentifierFactory moduleIdentifierFactory) throws IOException {
        return new Reader(decoder, moduleIdentifierFactory, this.attributesFactory, this.instantiator).read();
    }

    public void write(Encoder encoder, ModuleComponentResolveMetadata metadata) throws IOException {
        new Writer(encoder).write(metadata);
    }

    private static class Reader {
        private final Decoder decoder;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final ImmutableAttributesFactory attributesFactory;
        private final NamedObjectInstantiator instantiator;
        private ModuleComponentIdentifier id;
        private ModuleVersionIdentifier mvi;

        private Reader(Decoder decoder, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator instantiator) {
            this.decoder = decoder;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.attributesFactory = attributesFactory;
            this.instantiator = instantiator;
        }

        public MutableModuleComponentResolveMetadata read() throws IOException {
            byte type = this.decoder.readByte();
            switch (type) {
                case 1: {
                    return this.readIvy();
                }
                case 2: {
                    return this.readMaven();
                }
            }
            throw new IllegalArgumentException("Unexpected metadata type found.");
        }

        private void readSharedInfo(MutableModuleComponentResolveMetadata metadata) throws IOException {
            metadata.setContentHash(new HashValue(this.decoder.readBinary()));
            metadata.setMissing(this.decoder.readBoolean());
            metadata.setStatus(this.decoder.readString());
        }

        private MutableModuleComponentResolveMetadata readMaven() throws IOException {
            this.readInfoSection();
            List<ModuleDependencyMetadata> dependencies = this.readDependencies();
            DefaultMutableMavenModuleResolveMetadata metadata = new DefaultMutableMavenModuleResolveMetadata(this.mvi, this.id, (Collection<? extends ModuleDependencyMetadata>)dependencies);
            this.readSharedInfo(metadata);
            metadata.setSnapshotTimestamp(this.readNullableString());
            metadata.setPackaging(this.readNullableString());
            metadata.setRelocated(this.readBoolean());
            this.readVariants(metadata);
            return metadata;
        }

        private void readVariants(MutableComponentVariantResolveMetadata metadata) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                String name = this.decoder.readString();
                ImmutableAttributes attributes = this.readAttributes();
                MutableComponentVariant variant = metadata.addVariant(name, attributes);
                this.readVariantDependencies(variant);
                this.readVariantFiles(variant);
            }
        }

        private ImmutableAttributes readAttributes() throws IOException {
            ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                String name = this.decoder.readString();
                byte type = this.decoder.readByte();
                if (type == 2) {
                    attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, Boolean.class), (Object)this.decoder.readBoolean());
                    continue;
                }
                String value = this.decoder.readString();
                attributes = this.attributesFactory.concat(attributes, Attribute.of((String)name, String.class), (Isolatable)new CoercingStringValueSnapshot(value, this.instantiator));
            }
            return attributes;
        }

        private void readVariantDependencies(MutableComponentVariant variant) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                ModuleComponentSelector selector = COMPONENT_SELECTOR_SERIALIZER.read(this.decoder);
                variant.addDependency(selector.getGroup(), selector.getModule(), selector.getVersionConstraint());
            }
        }

        private void readVariantFiles(MutableComponentVariant variant) throws IOException {
            int count = this.decoder.readSmallInt();
            for (int i = 0; i < count; ++i) {
                variant.addFile(this.decoder.readString(), this.decoder.readString());
            }
        }

        private MutableModuleComponentResolveMetadata readIvy() throws IOException {
            this.readInfoSection();
            Map<NamespaceId, String> extraAttributes = this.readExtraInfo();
            List<Configuration> configurations = this.readConfigurations();
            List<ModuleDependencyMetadata> dependencies = this.readDependencies();
            List<Artifact> artifacts = this.readArtifacts();
            List<Exclude> excludes = this.readAllExcludes();
            DefaultMutableIvyModuleResolveMetadata metadata = new DefaultMutableIvyModuleResolveMetadata(this.mvi, this.id, configurations, dependencies, artifacts);
            this.readSharedInfo(metadata);
            String branch = this.readNullableString();
            metadata.setBranch(branch);
            metadata.setExtraAttributes(extraAttributes);
            metadata.setExcludes(excludes);
            return metadata;
        }

        private void readInfoSection() throws IOException {
            this.id = this.readId();
            this.mvi = this.moduleIdentifierFactory.moduleWithVersion(this.id.getGroup(), this.id.getModule(), this.id.getVersion());
        }

        private ModuleComponentIdentifier readId() throws IOException {
            return DefaultModuleComponentIdentifier.newId(this.readString(), this.readString(), this.readString());
        }

        private Map<NamespaceId, String> readExtraInfo() throws IOException {
            int len = this.readCount();
            LinkedHashMap<NamespaceId, String> result = new LinkedHashMap<NamespaceId, String>(len);
            for (int i = 0; i < len; ++i) {
                NamespaceId namespaceId = new NamespaceId(this.readString(), this.readString());
                String value = this.readString();
                result.put(namespaceId, value);
            }
            return result;
        }

        private List<Configuration> readConfigurations() throws IOException {
            int len = this.readCount();
            ArrayList<Configuration> configurations = new ArrayList<Configuration>(len);
            for (int i = 0; i < len; ++i) {
                Configuration configuration = this.readConfiguration();
                configurations.add(configuration);
            }
            return configurations;
        }

        private Configuration readConfiguration() throws IOException {
            String name = this.readString();
            boolean transitive = this.readBoolean();
            boolean visible = this.readBoolean();
            List<String> extendsFrom = this.readStringList();
            return new Configuration(name, transitive, visible, extendsFrom);
        }

        private List<Artifact> readArtifacts() throws IOException {
            int size = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                result.add(new Artifact(ivyArtifactName, this.readStringSet()));
            }
            return result;
        }

        private List<ModuleDependencyMetadata> readDependencies() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                result.add(this.readDependency());
            }
            return result;
        }

        private ModuleDependencyMetadata readDependency() throws IOException {
            ModuleComponentSelector requested = COMPONENT_SELECTOR_SERIALIZER.read(this.decoder);
            byte type = this.decoder.readByte();
            switch (type) {
                case 1: {
                    SetMultimap<String, String> configMappings = this.readDependencyConfigurationMapping();
                    List<Artifact> artifacts = this.readDependencyArtifactDescriptors();
                    List<Exclude> excludes = this.readExcludeRules();
                    String dynamicConstraintVersion = this.readString();
                    boolean force = this.readBoolean();
                    boolean changing = this.readBoolean();
                    boolean transitive = this.readBoolean();
                    boolean optional = this.readBoolean();
                    return new IvyDependencyMetadata(requested, dynamicConstraintVersion, force, changing, transitive, optional, (Multimap<String, String>)configMappings, artifacts, excludes);
                }
                case 2: {
                    List<Artifact> artifacts = this.readDependencyArtifactDescriptors();
                    List<Exclude> excludes = this.readExcludeRules();
                    MavenScope scope = MavenScope.values()[this.decoder.readSmallInt()];
                    boolean optional = this.decoder.readBoolean();
                    return new MavenDependencyMetadata(scope, optional, requested, artifacts, excludes);
                }
            }
            throw new IllegalArgumentException("Unexpected dependency type found.");
        }

        private SetMultimap<String, String> readDependencyConfigurationMapping() throws IOException {
            int size = this.readCount();
            LinkedHashMultimap result = LinkedHashMultimap.create();
            for (int i = 0; i < size; ++i) {
                String from = this.readString();
                Set<String> to = this.readStringSet();
                result.putAll((Object)from, to);
            }
            return result;
        }

        private List<Artifact> readDependencyArtifactDescriptors() throws IOException {
            int size = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.readString(), this.readString(), this.readNullableString(), this.readNullableString());
                result.add(new Artifact(ivyArtifactName, this.readStringSet()));
            }
            return result;
        }

        private List<Exclude> readExcludeRules() throws IOException {
            int len = this.readCount();
            ArrayList result = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                DefaultExclude rule = this.readExcludeRule();
                result.add(rule);
            }
            return result;
        }

        private DefaultExclude readExcludeRule() throws IOException {
            String moduleOrg = this.readString();
            String moduleName = this.readString();
            String artifact = this.readString();
            String type = this.readString();
            String ext = this.readString();
            String[] confs = this.readStringArray();
            String matcher = this.readString();
            return new DefaultExclude(this.moduleIdentifierFactory.module(moduleOrg, moduleName), artifact, type, ext, confs, matcher);
        }

        private List<Exclude> readAllExcludes() throws IOException {
            int len = this.readCount();
            ArrayList<Exclude> result = new ArrayList<Exclude>(len);
            for (int i = 0; i < len; ++i) {
                result.add(this.readExcludeRule());
            }
            return result;
        }

        private int readCount() throws IOException {
            return this.decoder.readSmallInt();
        }

        private String readString() throws IOException {
            return this.decoder.readString();
        }

        private String readNullableString() throws IOException {
            return this.decoder.readNullableString();
        }

        private boolean readBoolean() throws IOException {
            return this.decoder.readBoolean();
        }

        private String[] readStringArray() throws IOException {
            int size = this.readCount();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = this.readNullableString();
            }
            return array;
        }

        private List<String> readStringList() throws IOException {
            int size = this.readCount();
            ArrayList<String> list = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.readString());
            }
            return list;
        }

        private Set<String> readStringSet() throws IOException {
            int size = this.readCount();
            LinkedHashSet<String> set = new LinkedHashSet<String>(size);
            for (int i = 0; i < size; ++i) {
                set.add(this.readString());
            }
            return set;
        }
    }

    private static class Writer {
        private final Encoder encoder;

        private Writer(Encoder encoder) {
            this.encoder = encoder;
        }

        public void write(ModuleComponentResolveMetadata metadata) throws IOException {
            if (metadata instanceof IvyModuleResolveMetadata) {
                this.write((IvyModuleResolveMetadata)metadata);
            } else if (metadata instanceof MavenModuleResolveMetadata) {
                this.write((MavenModuleResolveMetadata)metadata);
            } else {
                throw new IllegalArgumentException("Unexpected metadata type: " + metadata.getClass());
            }
        }

        private void write(MavenModuleResolveMetadata metadata) throws IOException {
            this.encoder.writeByte((byte)2);
            this.writeInfoSection(metadata);
            this.writeDependencies(metadata.getDependencies());
            this.writeSharedInfo(metadata);
            this.writeNullableString(metadata.getSnapshotTimestamp());
            this.writeNullableString(metadata.getPackaging());
            this.writeBoolean(metadata.isRelocated());
            this.writeVariants(metadata);
        }

        private void writeVariants(ComponentVariantResolveMetadata metadata) throws IOException {
            this.encoder.writeSmallInt(metadata.getVariants().size());
            for (ComponentVariant variant : metadata.getVariants()) {
                this.encoder.writeString((CharSequence)variant.getName());
                this.writeAttributes((AttributeContainer)variant.getAttributes());
                this.writeVariantDependencies((List<? extends ComponentVariant.Dependency>)variant.getDependencies());
                this.writeVariantFiles((List<? extends ComponentVariant.File>)variant.getFiles());
            }
        }

        private void writeVariantDependencies(List<? extends ComponentVariant.Dependency> dependencies) throws IOException {
            this.encoder.writeSmallInt(dependencies.size());
            for (ComponentVariant.Dependency dependency : dependencies) {
                COMPONENT_SELECTOR_SERIALIZER.write(this.encoder, dependency.getGroup(), dependency.getModule(), dependency.getVersionConstraint());
            }
        }

        private void writeAttributes(AttributeContainer attributes) throws IOException {
            this.encoder.writeSmallInt(attributes.keySet().size());
            for (Attribute attribute : attributes.keySet()) {
                this.encoder.writeString((CharSequence)attribute.getName());
                if (attribute.getType().equals(Boolean.class)) {
                    this.encoder.writeByte((byte)2);
                    this.encoder.writeBoolean(((Boolean)attributes.getAttribute(attribute)).booleanValue());
                    continue;
                }
                assert (attribute.getType().equals(String.class));
                this.encoder.writeByte((byte)1);
                this.encoder.writeString((CharSequence)((String)attributes.getAttribute(attribute)));
            }
        }

        private void writeVariantFiles(List<? extends ComponentVariant.File> files) throws IOException {
            this.encoder.writeSmallInt(files.size());
            for (ComponentVariant.File file : files) {
                this.encoder.writeString((CharSequence)file.getName());
                this.encoder.writeString((CharSequence)file.getUri());
            }
        }

        private void write(IvyModuleResolveMetadata metadata) throws IOException {
            this.encoder.writeByte((byte)1);
            this.writeInfoSection(metadata);
            this.writeExtraInfo((Map<NamespaceId, String>)metadata.getExtraAttributes());
            this.writeConfigurations((Collection<Configuration>)metadata.getConfigurationDefinitions().values());
            this.writeDependencies(metadata.getDependencies());
            this.writeArtifacts((List<Artifact>)metadata.getArtifactDefinitions());
            this.writeExcludeRules((List<Exclude>)metadata.getExcludes());
            this.writeSharedInfo(metadata);
            this.writeNullableString(metadata.getBranch());
        }

        private void writeSharedInfo(ModuleComponentResolveMetadata metadata) throws IOException {
            this.encoder.writeBinary(metadata.getContentHash().asByteArray());
            this.encoder.writeBoolean(metadata.isMissing());
            this.encoder.writeString((CharSequence)metadata.getStatus());
        }

        private void writeId(ModuleComponentIdentifier componentIdentifier) throws IOException {
            this.writeString(componentIdentifier.getGroup());
            this.writeString(componentIdentifier.getModule());
            this.writeString(componentIdentifier.getVersion());
        }

        private void writeInfoSection(ModuleComponentResolveMetadata metadata) throws IOException {
            this.writeId(metadata.getComponentId());
        }

        private void writeExtraInfo(Map<NamespaceId, String> extraInfo) throws IOException {
            this.writeCount(extraInfo.size());
            for (Map.Entry<NamespaceId, String> entry : extraInfo.entrySet()) {
                NamespaceId namespaceId = entry.getKey();
                this.writeString(namespaceId.getNamespace());
                this.writeString(namespaceId.getName());
                this.writeString(entry.getValue());
            }
        }

        private void writeConfigurations(Collection<Configuration> configurations) throws IOException {
            this.writeCount(configurations.size());
            for (Configuration conf : configurations) {
                this.writeConfiguration(conf);
            }
        }

        private void writeConfiguration(Configuration conf) throws IOException {
            this.writeString(conf.getName());
            this.writeBoolean(conf.isTransitive());
            this.writeBoolean(conf.isVisible());
            this.writeStringList(conf.getExtendsFrom());
        }

        private void writeArtifacts(List<Artifact> artifacts) throws IOException {
            this.writeCount(artifacts.size());
            for (Artifact artifact : artifacts) {
                IvyArtifactName artifactName = artifact.getArtifactName();
                this.writeString(artifactName.getName());
                this.writeString(artifactName.getType());
                this.writeNullableString(artifactName.getExtension());
                this.writeNullableString(artifactName.getClassifier());
                this.writeStringSet(artifact.getConfigurations());
            }
        }

        private void writeDependencies(List<? extends ModuleDependencyMetadata> dependencies) throws IOException {
            this.writeCount(dependencies.size());
            for (ModuleDependencyMetadata moduleDependencyMetadata : dependencies) {
                this.writeDependency(moduleDependencyMetadata);
            }
        }

        private void writeDependency(ModuleDependencyMetadata dep) throws IOException {
            ModuleComponentSelector selector = dep.getSelector();
            COMPONENT_SELECTOR_SERIALIZER.write(this.encoder, selector);
            if (dep instanceof IvyDependencyMetadata) {
                IvyDependencyMetadata ivyDependency = (IvyDependencyMetadata)dep;
                this.encoder.writeByte((byte)1);
                this.writeDependencyConfigurationMapping(ivyDependency);
                this.writeArtifacts(ivyDependency.getDependencyArtifacts());
                this.writeExcludeRules(ivyDependency.getExcludes());
                this.writeString(ivyDependency.getDynamicConstraintVersion());
                this.writeBoolean(ivyDependency.isForce());
                this.writeBoolean(ivyDependency.isChanging());
                this.writeBoolean(ivyDependency.isTransitive());
                this.writeBoolean(ivyDependency.isOptional());
            } else if (dep instanceof MavenDependencyMetadata) {
                MavenDependencyMetadata mavenDependency = (MavenDependencyMetadata)dep;
                this.encoder.writeByte((byte)2);
                this.writeArtifacts(mavenDependency.getDependencyArtifacts());
                this.writeExcludeRules(mavenDependency.getExcludes());
                this.encoder.writeSmallInt(mavenDependency.getScope().ordinal());
                this.encoder.writeBoolean(mavenDependency.isOptional());
            } else {
                throw new IllegalStateException("Unexpected dependency type");
            }
        }

        private void writeDependencyConfigurationMapping(IvyDependencyMetadata dep) throws IOException {
            SetMultimap<String, String> confMappings = dep.getConfMappings();
            this.writeCount(confMappings.keySet().size());
            for (String conf : confMappings.keySet()) {
                this.writeString(conf);
                this.writeStringSet(confMappings.get((Object)conf));
            }
        }

        private void writeExcludeRules(List<Exclude> excludes) throws IOException {
            this.writeCount(excludes.size());
            for (Exclude exclude : excludes) {
                IvyArtifactName artifact = exclude.getArtifact();
                this.writeString(exclude.getModuleId().getGroup());
                this.writeString(exclude.getModuleId().getName());
                this.writeString(artifact.getName());
                this.writeString(artifact.getType());
                this.writeString(artifact.getExtension());
                this.writeStringArray(exclude.getConfigurations().toArray(new String[0]));
                this.writeString(exclude.getMatcher());
            }
        }

        private void writeCount(int i) throws IOException {
            this.encoder.writeSmallInt(i);
        }

        private void writeString(String str) throws IOException {
            this.encoder.writeString((CharSequence)str);
        }

        private void writeNullableString(String str) throws IOException {
            this.encoder.writeNullableString((CharSequence)str);
        }

        private void writeBoolean(boolean b) throws IOException {
            this.encoder.writeBoolean(b);
        }

        private void writeStringArray(String[] values) throws IOException {
            this.writeCount(values.length);
            for (String configuration : values) {
                this.writeNullableString(configuration);
            }
        }

        private void writeStringList(List<String> values) throws IOException {
            this.writeCount(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }

        private void writeStringSet(Set<String> values) throws IOException {
            this.writeCount(values.size());
            for (String configuration : values) {
                this.writeString(configuration);
            }
        }
    }
}

