/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.OptionalDependenciesHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeState
implements DependencyGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final Long resultId;
    private final ComponentState component;
    private final Set<EdgeState> incomingEdges = new LinkedHashSet<EdgeState>();
    private final List<EdgeState> outgoingEdges = Lists.newLinkedList();
    private final ResolvedConfigurationIdentifier id;
    private final ConfigurationMetadata metaData;
    private final ResolveState resolveState;
    private ModuleExclusion previousTraversalExclusions;

    NodeState(Long resultId, ResolvedConfigurationIdentifier id, ComponentState component, ResolveState resolveState) {
        this(resultId, id, component, resolveState, component.getMetadata().getConfiguration(id.getConfiguration()));
    }

    NodeState(Long resultId, ResolvedConfigurationIdentifier id, ComponentState component, ResolveState resolveState, ConfigurationMetadata md) {
        this.resultId = resultId;
        this.id = id;
        this.component = component;
        this.resolveState = resolveState;
        this.metaData = md;
        component.addConfiguration(this);
    }

    ComponentState getComponent() {
        return this.component;
    }

    @Override
    public Long getNodeId() {
        return this.resultId;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ResolvedConfigurationIdentifier getResolvedConfigurationId() {
        return this.id;
    }

    @Override
    public ComponentState getOwner() {
        return this.component;
    }

    public Set<EdgeState> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<EdgeState> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    public ConfigurationMetadata getMetadata() {
        return this.metaData;
    }

    @Override
    public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
        if (this.metaData instanceof LocalConfigurationMetadata) {
            for (EdgeState incomingEdge : this.incomingEdges) {
                if (!incomingEdge.isTransitive()) continue;
                return ((LocalConfigurationMetadata)this.metaData).getFiles();
            }
        }
        return Collections.emptySet();
    }

    public String toString() {
        return String.format("%s(%s)", this.component, this.id.getConfiguration());
    }

    public boolean isTransitive() {
        return this.metaData.isTransitive();
    }

    public void visitOutgoingDependencies(Collection<EdgeState> target, OptionalDependenciesHandler optionalDependenciesHandler) {
        if (!this.component.isSelected()) {
            LOGGER.debug("version for {} is not selected. ignoring.", (Object)this);
            return;
        }
        boolean hasIncomingEdges = !this.incomingEdges.isEmpty();
        List<EdgeState> transitiveIncoming = this.findTransitiveIncomingEdges(hasIncomingEdges);
        if (transitiveIncoming.isEmpty() && !this.isRoot()) {
            if (this.previousTraversalExclusions != null) {
                this.removeOutgoingEdges();
            }
            if (hasIncomingEdges) {
                LOGGER.debug("{} has no transitive incoming edges. ignoring outgoing edges.", (Object)this);
            } else {
                LOGGER.debug("{} has no incoming edges. ignoring.", (Object)this);
            }
            return;
        }
        ModuleExclusion resolutionFilter = this.getModuleResolutionFilter(transitiveIncoming);
        if (this.previousTraversalExclusions != null) {
            if (this.previousTraversalExclusions.excludesSameModulesAs(resolutionFilter)) {
                LOGGER.debug("Changed edges for {} selects same versions as previous traversal. ignoring", (Object)this);
                this.previousTraversalExclusions = resolutionFilter;
                return;
            }
            this.removeOutgoingEdges();
        }
        this.visitDependencies(resolutionFilter, optionalDependenciesHandler, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitDependencies(ModuleExclusion resolutionFilter, OptionalDependenciesHandler optionalDependenciesHandler, Collection<EdgeState> resultingOutgoingEdges) {
        boolean isOptionalConfiguration = "optional".equals(this.metaData.getName());
        OptionalDependenciesHandler.Visitor optionalDepsVisitor = optionalDependenciesHandler.start(isOptionalConfiguration);
        try {
            for (DependencyMetadata dependencyMetadata : this.metaData.getDependencies()) {
                DependencyState dependencyState = new DependencyState(dependencyMetadata, this.resolveState.getComponentSelectorConverter());
                if (this.isExcluded(resolutionFilter, dependencyState) || optionalDepsVisitor.maybeAddAsOptionalDependency(this, dependencyState)) continue;
                EdgeState dependencyEdge = new EdgeState(this, dependencyState, resolutionFilter, this.resolveState);
                this.outgoingEdges.add(dependencyEdge);
                resultingOutgoingEdges.add(dependencyEdge);
            }
            this.previousTraversalExclusions = resolutionFilter;
        }
        finally {
            optionalDepsVisitor.complete();
        }
    }

    private List<EdgeState> findTransitiveIncomingEdges(boolean hasIncomingEdges) {
        if (!hasIncomingEdges) {
            return Collections.emptyList();
        }
        int size = this.incomingEdges.size();
        if (size == 1) {
            return this.findSingleIncomingEdge();
        }
        ArrayList transitiveIncoming = Lists.newArrayListWithCapacity((int)size);
        for (EdgeState edge : this.incomingEdges) {
            if (!edge.isTransitive()) continue;
            transitiveIncoming.add(edge);
        }
        return transitiveIncoming;
    }

    private List<EdgeState> findSingleIncomingEdge() {
        EdgeState edgeState = this.incomingEdges.iterator().next();
        if (edgeState.isTransitive()) {
            return Collections.singletonList(edgeState);
        }
        return Collections.emptyList();
    }

    private boolean isExcluded(ModuleExclusion selector, DependencyState dependencyState) {
        DependencyMetadata dependency = dependencyState.getDependencyMetadata();
        if (!this.resolveState.getEdgeFilter().isSatisfiedBy((Object)dependency)) {
            LOGGER.debug("{} is filtered.", (Object)dependency);
            return true;
        }
        if (selector == ModuleExclusions.excludeNone()) {
            return false;
        }
        ModuleIdentifier targetModuleId = dependencyState.getModuleIdentifier();
        if (selector.excludeModule(targetModuleId)) {
            LOGGER.debug("{} is excluded from {}.", (Object)targetModuleId, (Object)this);
            return true;
        }
        return false;
    }

    public void addIncomingEdge(EdgeState dependencyEdge) {
        this.incomingEdges.add(dependencyEdge);
        this.resolveState.onMoreSelected(this);
    }

    public void removeIncomingEdge(EdgeState dependencyEdge) {
        this.incomingEdges.remove(dependencyEdge);
        this.resolveState.onFewerSelected(this);
    }

    public boolean isSelected() {
        return !this.incomingEdges.isEmpty();
    }

    private ModuleExclusion getModuleResolutionFilter(List<EdgeState> transitiveEdges) {
        ModuleExclusion resolutionFilter;
        ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
        if (transitiveEdges.isEmpty()) {
            resolutionFilter = ModuleExclusions.excludeNone();
        } else {
            resolutionFilter = transitiveEdges.get(0).getExclusions(moduleExclusions);
            for (int i = 1; i < transitiveEdges.size(); ++i) {
                EdgeState dependencyEdge = transitiveEdges.get(i);
                resolutionFilter = moduleExclusions.union(resolutionFilter, dependencyEdge.getExclusions(moduleExclusions));
            }
        }
        resolutionFilter = moduleExclusions.intersect(resolutionFilter, this.metaData.getExclusions(moduleExclusions));
        return resolutionFilter;
    }

    public void removeOutgoingEdges() {
        for (EdgeState outgoingDependency : this.outgoingEdges) {
            outgoingDependency.removeFromTargetConfigurations();
        }
        this.outgoingEdges.clear();
        this.previousTraversalExclusions = null;
    }

    public void restart(ComponentState selected) {
        if (this.component == selected) {
            this.resolveState.onMoreSelected(this);
        } else if (!this.incomingEdges.isEmpty()) {
            this.restartIncomingEdges(selected);
        }
    }

    private void restartIncomingEdges(ComponentState selected) {
        if (this.incomingEdges.size() == 1) {
            this.incomingEdges.iterator().next().restart(selected);
        } else {
            for (EdgeState dependency : new ArrayList<EdgeState>(this.incomingEdges)) {
                dependency.restart(selected);
            }
        }
        this.incomingEdges.clear();
    }

    public void deselect() {
        this.removeOutgoingEdges();
    }

    void resetSelectionState() {
        this.previousTraversalExclusions = null;
        this.outgoingEdges.clear();
        this.resolveState.onMoreSelected(this);
    }
}

