/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.FilterScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiSwitchLabelStatementImpl
extends CompositePsiElement
implements PsiSwitchLabelStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiSwitchLabelStatementImpl");

    public PsiSwitchLabelStatementImpl() {
        super(SWITCH_LABEL_STATEMENT);
    }

    @Override
    public boolean isDefaultCase() {
        return this.findChildByRoleAsPsiElement(85) != null;
    }

    @Override
    public PsiExpression getCaseValue() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(86);
    }

    @Override
    public PsiSwitchStatement getEnclosingSwitchStatement() {
        CompositeElement guessedSwitch = this.getTreeParent().getTreeParent();
        return guessedSwitch != null && guessedSwitch.getElementType() == SWITCH_STATEMENT ? (PsiSwitchStatement)SourceTreeToPsiMap.treeElementToPsi(guessedSwitch) : null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 84: {
                return this.findChildByType(CASE_KEYWORD);
            }
            case 85: {
                return this.findChildByType(DEFAULT_KEYWORD);
            }
            case 86: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 87: 
        }
        return this.findChildByType(COLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == CASE_KEYWORD) {
            return 84;
        }
        if (i == DEFAULT_KEYWORD) {
            return 85;
        }
        if (i == COLON) {
            return 87;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 86;
        }
        return 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass aClass2;
        PsiExpression expression2;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl", "processDeclarations"));
        }
        if (lastParent == null) {
            return true;
        }
        PsiSwitchStatement switchStatement = this.getEnclosingSwitchStatement();
        if (switchStatement != null && (expression2 = switchStatement.getExpression()) != null && expression2.getType() instanceof PsiClassType && (aClass2 = ((PsiClassType)expression2.getType()).resolve()) != null) {
            aClass2.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.ENUM_CONST, processor), state2, this, place);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSwitchLabelStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSwitchLabelStatement";
    }
}

