/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.psi.KtExpression;

public class AliasingContext {
    @Nullable
    private final Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @Nullable
    private final Map<KtExpression, JsExpression> aliasesForExpressions;
    @Nullable
    private final AliasingContext parent;

    @NotNull
    public static AliasingContext getCleanContext() {
        AliasingContext aliasingContext = new AliasingContext(null, null, null);
        if (aliasingContext == null) {
            AliasingContext.$$$reportNull$$$0(0);
        }
        return aliasingContext;
    }

    private AliasingContext(@Nullable AliasingContext parent2, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors, @Nullable Map<KtExpression, JsExpression> aliasesForExpressions) {
        this.parent = parent2;
        this.aliasesForDescriptors = aliasesForDescriptors;
        this.aliasesForExpressions = aliasesForExpressions;
    }

    @NotNull
    public AliasingContext inner() {
        AliasingContext aliasingContext = new AliasingContext(this, null, null);
        if (aliasingContext == null) {
            AliasingContext.$$$reportNull$$$0(1);
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor2, @NotNull JsExpression alias) {
        if (descriptor2 == null) {
            AliasingContext.$$$reportNull$$$0(2);
        }
        if (alias == null) {
            AliasingContext.$$$reportNull$$$0(3);
        }
        AliasingContext aliasingContext = new AliasingContext(this, Collections.singletonMap(descriptor2, alias), null);
        if (aliasingContext == null) {
            AliasingContext.$$$reportNull$$$0(4);
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withExpressionsAliased(@NotNull Map<KtExpression, JsExpression> aliasesForExpressions) {
        if (aliasesForExpressions == null) {
            AliasingContext.$$$reportNull$$$0(5);
        }
        AliasingContext aliasingContext = new AliasingContext(this, null, aliasesForExpressions);
        if (aliasingContext == null) {
            AliasingContext.$$$reportNull$$$0(6);
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            AliasingContext.$$$reportNull$$$0(7);
        }
        AliasingContext aliasingContext = new AliasingContext(this, aliases, null);
        if (aliasingContext == null) {
            AliasingContext.$$$reportNull$$$0(8);
        }
        return aliasingContext;
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            AliasingContext.$$$reportNull$$$0(9);
        }
        JsExpression alias = this.aliasesForDescriptors != null ? this.aliasesForDescriptors.get(descriptor2.getOriginal()) : null;
        JsExpression result2 = alias != null || this.parent == null ? alias : this.parent.getAliasForDescriptor(descriptor2);
        return result2 != null ? result2.deepCopy() : null;
    }

    @Nullable
    public JsExpression getAliasForExpression(@NotNull KtExpression element) {
        if (element == null) {
            AliasingContext.$$$reportNull$$$0(10);
        }
        JsExpression alias = this.aliasesForExpressions != null ? this.aliasesForExpressions.get(element) : null;
        JsExpression result2 = alias != null || this.parent == null ? alias : this.parent.getAliasForExpression(element);
        return result2 != null ? result2.deepCopy() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/AliasingContext";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasesForExpressions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCleanContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "inner";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/AliasingContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withExpressionsAliased";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withDescriptorsAliased";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withExpressionsAliased";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withDescriptorsAliased";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAliasForDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAliasForExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

