/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.jvm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/serialization/jvm/ClassMapperLite;", "", "()V", "mapClass", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "core"})
public final class ClassMapperLite {
    public static final ClassMapperLite INSTANCE;

    @JvmStatic
    @NotNull
    public static final String mapClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String string = classId.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "classId.asString()");
        String internalName = StringsKt.replace$default(string, '.', '$', false, 4, null);
        String simpleName = StringsKt.removePrefix(internalName, (CharSequence)"kotlin/");
        if (Intrinsics.areEqual(simpleName, internalName) ^ true) {
            JvmPrimitiveType[] jvmPrimitiveTypeArray = JvmPrimitiveType.values();
            for (int i = 0; i < jvmPrimitiveTypeArray.length; ++i) {
                PrimitiveType primitiveType;
                JvmPrimitiveType jvmPrimitive = jvmPrimitiveTypeArray[i];
                PrimitiveType primitiveType2 = primitiveType = jvmPrimitive.getPrimitiveType();
                Intrinsics.checkExpressionValueIsNotNull((Object)primitiveType2, "primitiveType");
                if (Intrinsics.areEqual(simpleName, primitiveType2.getTypeName().asString())) {
                    String string2 = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "jvmPrimitive.desc");
                    return string2;
                }
                if (!Intrinsics.areEqual(simpleName, primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual(simpleName, KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "classId.asSingleFqName().toUnsafe()");
        ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (javaClassId != null) {
            StringBuilder stringBuilder = new StringBuilder().append("L");
            String string3 = javaClassId.asString();
            Intrinsics.checkExpressionValueIsNotNull(string3, "javaClassId.asString()");
            return stringBuilder.append(StringsKt.replace$default(string3, '.', '$', false, 4, null)).append(";").toString();
        }
        return 'L' + internalName + ';';
    }

    private ClassMapperLite() {
    }

    static {
        ClassMapperLite classMapperLite;
        INSTANCE = classMapperLite = new ClassMapperLite();
    }
}

