package Lire::WWW::UserAgent::Browser;
#
# $Id: Browser.pm,v 1.4 2008/02/11 05:38:17 vanbaal Exp $
#
# The data in this module is taken from AWStats. (http://awstats.sf.net/)
# Rewritten by Egon Willighagen for LogReport.org (http://logreport.org/)
#
# Copyright (C) 2000, 2001 - Laurent Destailleur - eldy@users.sourceforge.net
# Copyright (C) 2001, 2002 Stichting LogReport Foundation <logreport@logreport.org>
#
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html.
#
use strict;
use vars qw/ $REVISION/;

BEGIN {
    $REVISION  = '$Id: Browser.pm,v 1.4 2008/02/11 05:38:17 vanbaal Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

my %GeckoBasedBrowsers = (
# the following browsers sometimes are recognized as Mozilla; the engine *is*,
# but the browser is not
"netscape" => "Netscape",
"firefox"  => "Firefox",
"firebird" => "Firefox",
"galeon"   => "Galeon",
"camino"   => "Camino",
"epiphany" => "Epiphany",
);

my %BrowserHash = (
# msie and netscape are detected in getBrowser()
# Unfortunately, the order in this list does not matter:
# the keys method retrieves them in random order, see Perl docs!
"lynx" => "Lynx",
"opera" => "Opera",
"wget" => "Wget",

#

"22acidownload" => "22AciDownload",
"aol\\-iweng" => "AOL-Iweng",
"amaya" => "Amaya",
"amigavoyager" => "AmigaVoyager",
"antfresco" => "ANT Fresco",
"bpftp" => "BPFTP",
"camino" => "Camino",
# "check_http/1.24 (nagios-plugins 1.3.0)"
"check_http" => "Nagios Monitor",
"chimera" => "Chimera",
"cyberdog" => "Cyberdog",
"dreamcast" => "Dreamcast",
"downloadagent" => "DownloadAgent",
"ecatch", "eCatch",
"emailsiphon" => "EmailSiphon",
"epiphany" => "Epiphany",
"fetch" => "FreeBSD's fetch",
"firebird" => "Firefox",
"firefox" => "Firefox",
"friendlyspider" => "FriendlySpider",
"galeon" => "Galeon",
"getright" => "GetRight",
"go!zilla" => "Go!Zilla",
"headdump" => "HeadDump",
"hotjava" => "Sun HotJava",
"ibrowse" => "IBrowse",
"icab" => "iCab",
"intergo" => "InterGO",
"java" => "Java Program",
"konqueror" => "Konqueror",
"libwww" => "LibWWW",
"linemodebrowser" => "W3C Line Mode Browser",
"links" => "Links",
"lotus-notes" => "Lotus Notes web client",
"macweb" => "MacWeb",
"ncsa_mosaic" => "NCSA Mosaic",
"netpositive" => "NetPositive",
"nutscrape", "Nutscrape",
"msfrontpageexpress" => "MS FrontPage Express",
"omniweb" => "OmniWeb",
"safari" => "Safari",
"teleport" => "TelePort Pro (Site grabber)",
"tzgeturl" => "TZGETURL",
"viking" => "Viking",
"w3m"  => "W3m",
"webcapture" => "Acrobat (Site grabber)",
"webfetcher" => "WebFetcher",
"webexplorer" => "IBM-WebExplorer",
"webmirror" => "WebMirror",
"webvcr" => "WebVCR",

# Music only browsers

"real" => "RealAudio or compatible player",
"winamp" => "WinAmp",
"windows-media-player" => "Windows Media Player",
"audion" => "Audion",
"freeamp" => "FreeAmp",
"itunes" => "Apple iTunes",
"jetaudio" => "JetAudio",
"mint_audio" => "Mint Audio",
"mpg123" => "mpg123",
"nsplayer" => "NetShow Player",
"sonique" => "Sonique media player",
"uplayer" => "Ultra Player",
"xmms" => "XMMS",
"xaudio" => "Some XAudio Engine based MPEG player",

# Other kind of browsers
"offline_explorer" => "Offline Explorer",
"debian_apt" => "Debian APT",
"webzip" => "WebZIP",

# Other engine OS (PDA, phonecells, TV)

"mmef" => "Microsoft Mobile Explorer",
"mspie" => "MS Pocket Internet Explorer",
"webtv" => "WebTV browser",
);

# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getBrowser {
    my ( $ua) = @_;

    # IE ? (For higher speed, we start whith IE, the most often used.
    #       This avoid other tests if found)
    if (($ua =~ /msie/) && ($ua !~ /webtv/) &&
        ($ua !~ /omniweb/) && ($ua !~ /opera/)) {
        return "MS Internet Explorer";
    }

    # Mozilla ?
    if (($ua =~ /gecko/) && ($ua !~ /khtml/)) {
        foreach my $b (keys %GeckoBasedBrowsers) {
            return $GeckoBasedBrowsers{$b} if index( $ua, $b ) >= 0;
        }
        return "Mozilla";
    }

    # Netscape ?
    if (($ua =~ /mozilla/) && ($ua !~ /compatible/) &&
        ($ua !~ /opera/) && ( $ua !~ /galeon/) && ($ua !~ /konqueror/) && ($ua !~ /firefox/) && ($ua !~ /epiphany/)) {
        return "Netscape Navigator";
    }

    # Other ?
    foreach my $b (keys %BrowserHash) {
        return $BrowserHash{$b} if index( $ua, $b ) >= 0;
    }

    return undef;
}

1;

