# Namespace for automatic exploitation.  Automatic exploitation
# {MetasploitDataModels::AutomaticExploitation::Match matches}
# {MetasploitDataModels::AutomaticExploitation::Match#matchable services or vulnerbatility} with the
# {MetasploitDataModels::AutomaticExploitation::Match#module_detail Metasploit Module} that can exploit the service or
# vulnerability.  These matches are grouped into a {MetasploitDataModels::AutomaticExploitation::MatchSet a set} that
# can be {MetasploitDataModels::AutomaticExploitation::Run run} multiple times.
module MetasploitDataModels::AutomaticExploitation
  extend ActiveSupport::Autoload

  autoload :Match
  autoload :MatchResult
  autoload :MatchSet
  autoload :Run

  #
  # Module Methods
  #

  # The prefix of the `ActiveRecord::Base#table_name` of subclasses in this namespace.
  #
  # @return [String]
  def self.table_name_prefix
    'automatic_exploitation_'
  end
end
