#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hackage-security
version: 0.5.2.2
id: hackage-security-0.5.2.2-GapNHSRCLZIAZAUlWqGqPt
key: hackage-security-0.5.2.2-GapNHSRCLZIAZAUlWqGqPt
license: BSD3
copyright: Copyright 2015-2016 Well-Typed LLP
maintainer: edsko@well-typed.com
homepage: https://github.com/well-typed/hackage-security
synopsis: Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<http://hackage.haskell.org/>).  It is based on The Update
    Framework (<http://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).
    .
    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.
    .
    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).
category: Distribution
author: Edsko de Vries
exposed: True
indefinite: False
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.IO
    Hackage.Security.Util.Lens Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical
hidden-modules: Hackage.Security.Key Hackage.Security.Trusted.TCB
                Hackage.Security.TUF Hackage.Security.TUF.Common
                Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
                Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
                Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
                Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
                Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
                Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
                Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
                Hackage.Security.Util.JSON Hackage.Security.Util.Stack
                Hackage.Security.Util.TypedEmbedded Prelude
abi: c9dca8b364b0665b8cd7d30ad268f343
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/hackage-security-0.5.2.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/hackage-security-0.5.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/hackage-security-0.5.2.2
hs-libraries: HShackage-security-0.5.2.2-GapNHSRCLZIAZAUlWqGqPt
depends:
    base-4.10.1.0 base16-bytestring-0.1.1.6-Bd4rUARbKHBrsqzcqGjb8
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be
    bytestring-0.10.8.2 Cabal-2.0.1.0 containers-0.5.10.2
    directory-1.3.0.2 ed25519-0.0.5.0-5pFksGKabcUIJjOzH2huYw
    filepath-1.4.1.2 mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1 pretty-1.1.3.3
    cryptohash-sha256-0.11.101.0-D9WEwWp52WRAhUFLlHOr2v
    tar-0.5.0.3-7uH7Usofl2BFmvax6EB94t time-1.8.0.2
    transformers-0.5.2.0 zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM
    template-haskell-2.12.0.0 ghc-prim-0.5.1.1
    network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT
    network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             base16-bytestring-0.1.1.6-Bd4rUARbKHBrsqzcqGjb8=37016c8c32a9f0915ad84c6171e7c01d
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             Cabal-2.0.1.0=a6a7b28e8794af4ab0796ef93b162aed
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             ed25519-0.0.5.0-5pFksGKabcUIJjOzH2huYw=4438940d31b53735299679370e6a50a4
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1=893424ff0bd1ccfdf429c25df7ce2aa4
             pretty-1.1.3.3=229bcf5342145ac1755207fe83d29780
             cryptohash-sha256-0.11.101.0-D9WEwWp52WRAhUFLlHOr2v=efbb8bab174d4005dc6d97a336e34bb7
             tar-0.5.0.3-7uH7Usofl2BFmvax6EB94t=2464e73cf32d7a5f49b381c1dd961d93
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM=fc994ec0331fc01f98e1d968398a1aa2
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT=0b326ed8cea6aef4683ed7796a7691a6
             network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP=a333d9df3290e5924c2ef4f5f4b24781
haddock-interfaces: /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock
haddock-html: /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

