#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-theory
version: 1.2.2
id: tamarin-prover-theory-1.2.2-FNymC9yvxLP1wSIGbs3deL
key: tamarin-prover-theory-1.2.2-FNymC9yvxLP1wSIGbs3deL
license: GPL
copyright: Benedikt Schmidt, Simon Meier, ETH Zurich, 2010-2012
maintainer: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>
homepage: http://www.infsec.ethz.ch/research/software/tamarin
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides the types to represent security
    protocol, and it implements the constraint solver.
category: Theorem Provers
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>
exposed: True
indefinite: False
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.Solver.Types Theory.Constraint.System
    Theory.Constraint.System.Constraints Theory.Constraint.System.Dot
    Theory.Constraint.System.Guarded Theory.Constraint.System.JSON
    Theory.Model Theory.Model.Atom Theory.Model.Fact
    Theory.Model.Formula Theory.Model.Rule Theory.Model.Signature
    Theory.Proof Theory.Text.Parser Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness
abi: 9654242ed64a23c04165b6e4b6c4d809
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/tamarin-prover-theory-1.2.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/tamarin-prover-theory-1.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/tamarin-prover-theory-1.2.2
hs-libraries: HStamarin-prover-theory-1.2.2-FNymC9yvxLP1wSIGbs3deL
depends:
    aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F
    aeson-pretty-0.8.5-LFJu9kVJ6zPIrRgYhOjpbD base-4.10.1.0
    binary-0.8.5.1 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ
    fclabels-2.0.3.2-4PbsFDjds23DVWcXML4X3o
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1
    parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1 process-1.6.1.0
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj transformers-0.5.2.0
    uniplate-1.6.12-KEBCAJdeJV5Cpdl7sQYF8W
    tamarin-prover-utils-1.2.2-29rprtoxIif8oIayhAyrJZ
    tamarin-prover-term-1.2.2-5ZIwASq9hPF5TnD9D6b20Z
abi-depends: aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F=4c58219744f0571919d1814f029cc115
             aeson-pretty-0.8.5-LFJu9kVJ6zPIrRgYhOjpbD=8539f09caee154613432bd791095a2d1
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             dlist-0.8.0.3-3sLvqWTqZxIC2tgTx4QBVJ=478549693a66e61496f47353d337a8f9
             fclabels-2.0.3.2-4PbsFDjds23DVWcXML4X3o=bfd3c04c8c1d27e4dcaaf345498c2321
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             parallel-3.2.1.1-6PIhrl6oqe7Af1Z2sa6T1=f329a0732f0d1ccfb717a7145bfd3a72
             parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1=893424ff0bd1ccfdf429c25df7ce2aa4
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             uniplate-1.6.12-KEBCAJdeJV5Cpdl7sQYF8W=6f59c5761961e06493a2894aa8d8d8b8
             tamarin-prover-utils-1.2.2-29rprtoxIif8oIayhAyrJZ=b788d5f5d829b9cdab72c705751492a0
             tamarin-prover-term-1.2.2-5ZIwASq9hPF5TnD9D6b20Z=60cf43fd4e535dd49dacede95b257afa
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

