/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.testing.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.report.TestResult;
import org.gradle.internal.FileUtils;

public class ClassTestResults
extends CompositeTestResults {
    private final long id;
    private final String name;
    private final PackageTestResults packageResults;
    private final Set<TestResult> results = new TreeSet<TestResult>();
    private final String baseUrl;

    public ClassTestResults(long id, String name, PackageTestResults packageResults) {
        super(packageResults);
        this.id = id;
        this.name = name;
        this.packageResults = packageResults;
        this.baseUrl = "classes/" + FileUtils.toSafeFileName((String)name) + ".html";
    }

    public long getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return "Class " + this.name;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        String simpleName = StringUtils.substringAfterLast((String)this.name, (String)".");
        if (simpleName.equals("")) {
            return this.name;
        }
        return simpleName;
    }

    public PackageTestResults getPackageResults() {
        return this.packageResults;
    }

    public Collection<TestResult> getTestResults() {
        return this.results;
    }

    public TestResult addTest(String testName, long duration) {
        TestResult test = new TestResult(testName, duration, this);
        this.results.add(test);
        return this.addTest(test);
    }
}

