/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.LayerUI;
import org.netbeans.core.multiview.SplitAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

class SplitLayerUI
extends LayerUI<JPanel> {
    private final JComponent splitDragger;
    private Point lastLocation;
    private boolean horizontalSplit = true;
    private final int splitterWidth;
    private final JComponent content;
    private boolean isDragging = false;
    private final AWTEventListener awtListener;
    private static final Color FILL_COLOR = new Color(0, 0, 0, 128);

    public SplitLayerUI(final JComponent jComponent) {
        this.content = jComponent;
        int n = new JSplitPane().getDividerSize();
        this.splitterWidth = Math.max(5, n);
        this.splitDragger = new JLabel(ImageUtilities.loadImageIcon((String)"org/netbeans/core/multiview/resources/splitview.png", (boolean)true));
        this.splitDragger.setToolTipText(NbBundle.getMessage(SplitLayerUI.class, (String)"Hint_SplitView"));
        this.splitDragger.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (!SplitLayerUI.this.isDragging && mouseEvent.getSource() == SplitLayerUI.this.splitDragger) {
                    Rectangle rectangle = SplitLayerUI.this.splitDragger.getBounds();
                    rectangle.setLocation(SplitLayerUI.this.splitDragger.getLocationOnScreen());
                    if (rectangle.contains(mouseEvent.getLocationOnScreen())) {
                        SplitLayerUI.this.isDragging = true;
                        Toolkit.getDefaultToolkit().addAWTEventListener(SplitLayerUI.this.awtListener, 24L);
                    }
                }
                if (SplitLayerUI.this.isDragging) {
                    SplitLayerUI.this.update(mouseEvent.getLocationOnScreen());
                }
            }
        });
        this.awtListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent.getID() == 502) {
                    final int n = SplitLayerUI.this.horizontalSplit ? ((SplitLayerUI)SplitLayerUI.this).lastLocation.x : ((SplitLayerUI)SplitLayerUI.this).lastLocation.y;
                    final int n2 = SplitLayerUI.this.horizontalSplit ? 1 : 0;
                    SplitLayerUI.this.cancelDragging();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jComponent);
                            SplitAction.splitWindow(topComponent, n2, n);
                        }
                    });
                } else if (aWTEvent.getID() == 401 || aWTEvent.getID() == 402) {
                    SplitLayerUI.this.cancelDragging();
                }
            }
        };
    }

    private void cancelDragging() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        this.isDragging = false;
        this.lastLocation = null;
        this.content.repaint();
    }

    JComponent getSplitDragger() {
        return this.splitDragger;
    }

    private void update(Point point) {
        if (null != point) {
            SwingUtilities.convertPointFromScreen(point, this.content);
            this.lastLocation = point;
            this.horizontalSplit = this.calculateOrientation();
            this.lastLocation.x = Math.max(0, this.lastLocation.x);
            this.lastLocation.y = Math.max(0, this.lastLocation.y);
            this.lastLocation.x = Math.min(this.content.getWidth() - this.splitterWidth, this.lastLocation.x);
            this.lastLocation.y = Math.min(this.content.getHeight() - this.splitterWidth, this.lastLocation.y);
            this.content.repaint();
        } else {
            this.lastLocation = null;
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (null != this.lastLocation && this.isDragging) {
            Rectangle rectangle = new Rectangle();
            if (this.horizontalSplit) {
                rectangle.width = this.splitterWidth;
                rectangle.height = jComponent.getHeight();
                rectangle.x = this.lastLocation.x;
            } else {
                rectangle.width = jComponent.getWidth();
                rectangle.height = this.splitterWidth;
                rectangle.y = this.lastLocation.y;
            }
            graphics.setColor(FILL_COLOR);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private boolean calculateOrientation() {
        int n = this.lastLocation.y;
        int n2 = this.content.getWidth() - this.lastLocation.x;
        return n < n2;
    }
}

