#ifndef EFL_GENERATED_ELM_WIN_HH
#define EFL_GENERATED_ELM_WIN_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_win.eo.h"
}

#include "elm_widget.eo.hh"
#include "elm_interface_atspi_window.eo.hh"
#include "elm_interface_atspi_widget_action.eo.hh"
#include <evas_object.eo.hh>
#include <string>

namespace elm {

struct win;

}

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

namespace elm {

struct win
{
   void wm_manual_rotation_done_manual() const;

   /// @param svcname 
   /// @param svcnum 
   /// @param svcsys 
   ///
   bool socket_listen(::efl::eina::string_view svcname_, int svcnum_, bool svcsys_) const;

   /// @param command 
   /// @param params 
   ///
   void illume_command_send(Elm_Illume_Command command_, void * params_) const;

   void activate() const;

   /// @param subobj 
   ///
   void resize_object_add(::evas::object subobj_) const;

   void raise() const;

   void lower() const;

   /// @param subobj 
   ///
   void resize_object_del(::evas::object subobj_) const;

   /// @param h 
   /// @param v 
   ///
   void center(bool h_, bool v_) const;

   /// @param key 
   /// @param modifiers 
   /// @param not_modifiers 
   /// @param proirity 
   /// @param grab_mode 
   ///
   bool keygrab_set(::efl::eina::string_view key_, Evas_Modifier_Mask modifiers_, Evas_Modifier_Mask not_modifiers_, int proirity_, Elm_Win_Keygrab_Mode grab_mode_) const;

   /// @param key 
   /// @param modifiers 
   /// @param not_modifiers 
   ///
   bool keygrab_unset(::efl::eina::string_view key_, Evas_Modifier_Mask modifiers_, Evas_Modifier_Mask not_modifiers_) const;

   bool keyboard_win_get() const;

   void keyboard_win_set(bool is_keyboard_) const;

   bool autodel_get() const;

   void autodel_set(bool autodel_) const;

   bool autohide_get() const;

   void autohide_set(bool autohide_) const;

   bool override_get() const;

   void override_set(bool override_) const;

   bool iconified_get() const;

   void iconified_set(bool iconified_) const;

   bool wm_available_rotations_get(int ** rotations_, unsigned int* count_) const;

   void wm_available_rotations_set(const int * rotations_, unsigned int count_) const;

   int quickpanel_zone_get() const;

   void quickpanel_zone_set(int zone_) const;

   bool maximized_get() const;

   void maximized_set(bool maximized_) const;

   bool modal_get() const;

   void modal_set(bool modal_) const;

   ::efl::eina::string_view icon_name_get() const;

   void icon_name_set(::efl::eina::string_view icon_name_) const;

   bool withdrawn_get() const;

   void withdrawn_set(bool withdrawn_) const;

   ::efl::eina::string_view role_get() const;

   void role_set(::efl::eina::string_view role_) const;

   void size_step_get(int* w_, int* h_) const;

   void size_step_set(int w_, int h_) const;

   ::efl::eina::optional< ::efl::eina::string_view > focus_highlight_style_get() const;

   void focus_highlight_style_set(::efl::eina::optional< ::efl::eina::string_view > style_) const;

   bool borderless_get() const;

   void borderless_set(bool borderless_) const;

   bool screen_constrain_get() const;

   void screen_constrain_set(bool constrain_) const;

   bool available_profiles_get(char *** profiles_, unsigned int* count_) const;

   void available_profiles_set(const char ** profiles_, unsigned int count_) const;

   bool focus_highlight_enabled_get() const;

   void focus_highlight_enabled_set(bool enabled_) const;

   ::efl::eina::string_view title_get() const;

   void title_set(::efl::eina::string_view title_) const;

   bool alpha_get() const;

   void alpha_set(bool alpha_) const;

   bool urgent_get() const;

   void urgent_set(bool urgent_) const;

   int rotation_get() const;

   void rotation_set(int rotation_) const;

   ::evas::object icon_object_get() const;

   void icon_object_set(::evas::object icon_) const;

   int quickpanel_priority_minor_get() const;

   void quickpanel_priority_minor_set(int priority_) const;

   bool sticky_get() const;

   void sticky_set(bool sticky_) const;

   Elm_Win_Keyboard_Mode keyboard_mode_get() const;

   void keyboard_mode_set(Elm_Win_Keyboard_Mode mode_) const;

   bool focus_highlight_animate_get() const;

   void focus_highlight_animate_set(bool animate_) const;

   double aspect_get() const;

   void aspect_set(double aspect_) const;

   int quickpanel_priority_major_get() const;

   void quickpanel_priority_major_set(int priority_) const;

   Elm_Win_Indicator_Opacity_Mode indicator_opacity_get() const;

   void indicator_opacity_set(Elm_Win_Indicator_Opacity_Mode mode_) const;

   bool demand_attention_get() const;

   void demand_attention_set(bool demand_attention_) const;

   int wm_preferred_rotation_get() const;

   void wm_preferred_rotation_set(int rotation_) const;

   int layer_get() const;

   void layer_set(int layer_) const;

   ::efl::eina::string_view profile_get() const;

   void profile_set(::efl::eina::string_view profile_) const;

   bool shaped_get() const;

   void shaped_set(bool shaped_) const;

   bool fullscreen_get() const;

   void fullscreen_set(bool fullscreen_) const;

   bool wm_manual_rotation_done_get() const;

   void wm_manual_rotation_done_set(bool set_) const;

   Elm_Win_Indicator_Mode indicator_mode_get() const;

   void indicator_mode_set(Elm_Win_Indicator_Mode mode_) const;

   bool conformant_get() const;

   void conformant_set(bool conformant_) const;

   void size_base_get(int* w_, int* h_) const;

   void size_base_set(int w_, int h_) const;

   bool quickpanel_get() const;

   void quickpanel_set(bool quickpanel_) const;

   void rotation_with_resize_set(int rotation_) const;

   void prop_focus_skip_set(bool skip_) const;

   void screen_position_get(int* x_, int* y_) const;

   bool wm_rotation_supported_get() const;

   Ecore_X_Window xwindow_get() const;

   bool focus_get() const;

   void screen_size_get(int* x_, int* y_, int* w_, int* h_) const;

   ::evas::object main_menu_get() const;

   Ecore_Wl2_Window * wl_window_get() const;

   Ecore_Cocoa_Window * cocoa_window_get() const;

   Ecore_Win32_Window * win32_window_get() const;

   Ecore_Window window_id_get() const;

   void screen_dpi_get(int* xdpi_, int* ydpi_) const;

   ::evas::object inlined_image_object_get() const;

   void name_set(::efl::eina::optional< ::efl::eina::string_view > name_) const;

   Elm_Win_Type type_get() const;

   void type_set(Elm_Win_Type type_) const;

   bool noblank_get() const;

   void noblank_set(bool noblank_) const;

   void * trap_data_get() const;

#ifdef WIN_PROTECTED
   void fake_canvas_set(Ecore_Evas * oee_) const;
#endif

   template <typename F>
   ::efl::eo::signal_connection
   callback_delete_request_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_DELETE_REQUEST, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_DELETE_REQUEST );
   }

   template <typename T>
   void
   callback_delete_request_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_DELETE_REQUEST, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_moved_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_MOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_MOVED );
   }

   template <typename T>
   void
   callback_moved_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_MOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_withdrawn_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_WITHDRAWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_WITHDRAWN );
   }

   template <typename T>
   void
   callback_withdrawn_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_WITHDRAWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_iconified_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ICONIFIED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ICONIFIED );
   }

   template <typename T>
   void
   callback_iconified_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ICONIFIED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_normal_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_NORMAL, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_NORMAL );
   }

   template <typename T>
   void
   callback_normal_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_NORMAL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_stick_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_STICK, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_STICK );
   }

   template <typename T>
   void
   callback_stick_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_STICK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unstick_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_UNSTICK, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_UNSTICK );
   }

   template <typename T>
   void
   callback_unstick_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_UNSTICK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_fullscreen_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_FULLSCREEN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_FULLSCREEN );
   }

   template <typename T>
   void
   callback_fullscreen_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_FULLSCREEN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unfullscreen_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_UNFULLSCREEN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_UNFULLSCREEN );
   }

   template <typename T>
   void
   callback_unfullscreen_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_UNFULLSCREEN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_maximized_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_MAXIMIZED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_MAXIMIZED );
   }

   template <typename T>
   void
   callback_maximized_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_MAXIMIZED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unmaximized_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_UNMAXIMIZED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_UNMAXIMIZED );
   }

   template <typename T>
   void
   callback_unmaximized_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_UNMAXIMIZED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_ioerr_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_IOERR, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_IOERR );
   }

   template <typename T>
   void
   callback_ioerr_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_IOERR, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_indicator_prop_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_INDICATOR_PROP_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_INDICATOR_PROP_CHANGED );
   }

   template <typename T>
   void
   callback_indicator_prop_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_INDICATOR_PROP_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_rotation_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ROTATION_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ROTATION_CHANGED );
   }

   template <typename T>
   void
   callback_rotation_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ROTATION_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_profile_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_PROFILE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_PROFILE_CHANGED );
   }

   template <typename T>
   void
   callback_profile_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_PROFILE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_wm_rotation_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_WM_ROTATION_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_WM_ROTATION_CHANGED );
   }

   template <typename T>
   void
   callback_wm_rotation_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_WM_ROTATION_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_animator_tick_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ANIMATOR_TICK, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ANIMATOR_TICK );
   }

   template <typename T>
   void
   callback_animator_tick_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ANIMATOR_TICK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_theme_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_THEME_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_THEME_CHANGED );
   }

   template <typename T>
   void
   callback_theme_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_THEME_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_elm_action_block_menu_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ELM_ACTION_BLOCK_MENU, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ELM_ACTION_BLOCK_MENU );
   }

   template <typename T>
   void
   callback_elm_action_block_menu_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ELM_ACTION_BLOCK_MENU, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_WIN_CLASS);
   }

   operator ::elm::win() const;
   operator ::elm::win&();
   operator ::elm::win const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm::win*() const { return static_cast<::elm::win*>(static_cast<D const*>(this)->p); }
      operator ::elm::win const*() const { return static_cast<::elm::win const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm::win const*() const { return static_cast<::elm::win const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}

}
/// @endcond

namespace elm {

/// @brief Class win
struct win
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(efl::gfx::base)
      , EO_CXX_INHERIT(efl::gfx::stack)
      , EO_CXX_INHERIT(elm::widget)
      , EO_CXX_INHERIT(elm_interface_atspi_accessible)
      , EO_CXX_INHERIT(elm_interface_atspi_action)
      , EO_CXX_INHERIT(elm_interface_atspi_component)
      , EO_CXX_INHERIT(elm_interface_atspi_widget_action)
      , EO_CXX_INHERIT(elm_interface_atspi_window)
      , EO_CXX_INHERIT(eo::base)
      , EO_CXX_INHERIT(evas::common_interface)
      , EO_CXX_INHERIT(evas::object)
      , EO_CXX_INHERIT(evas::object_smart)
      , EO_CXX_INHERIT(evas::signal_interface)
{
   /// @cond LOCAL
   struct _c_name
   {

      explicit _c_name(::efl::eina::optional< ::efl::eina::string_view > name_)
         : name_(name_)
      {}
      void operator()()
      {
         ::elm_obj_win_name_set(::efl::eolian::to_c(name_));
      }
      void register_ev_del_free_callback(Eo* _eoptr)
      {
         (void) _eoptr;
      }

      ::efl::eina::optional< ::efl::eina::string_view > name_;
   };
   /// @endcond

   /// @cond LOCAL
   struct _c_type
   {

      explicit _c_type(Elm_Win_Type type_)
         : type_(type_)
      {}
      void operator()()
      {
         ::elm_obj_win_type_set(type_);
      }
      void register_ev_del_free_callback(Eo* _eoptr)
      {
         (void) _eoptr;
      }

      Elm_Win_Type type_;
   };
   /// @endcond

   //@{
   /**
      @brief Constructs a new elm::win object.

      Constructs a new elm::win object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Since this class have necessary constructor methods, you must call each one of them
      in the right place within this constructor parameters.

      Example:
      @code
      elm::win my_win(efl::eo::parent = parent_object,
         my_win.name(name_),
         my_win.type(type_));
      @endcode

      @see win::name
      @see win::type
      @see win(Eo* eo)
   */
   explicit win(::efl::eo::parent_type _p, _c_name _c0, _c_type _c1)
      : win(_ctors_call(_p, _c0, _c1))
   {}

   explicit win(_c_name _c0, _c_type _c1)
      : win(_ctors_call(::efl::eo::parent = nullptr, _c0, _c1))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit win(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit win(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   win(win const& other)
      : win(eo_ref(other._eo_ptr()))
   {}

   ~win() {}

   static _c_name name(::efl::eina::optional< ::efl::eina::string_view > name_);

   static _c_type type(Elm_Win_Type type_);

   void wm_manual_rotation_done_manual() const;

   /// @param svcname 
   /// @param svcnum 
   /// @param svcsys 
   ///
   bool socket_listen(::efl::eina::string_view svcname_, int svcnum_, bool svcsys_) const;

   /// @param command 
   /// @param params 
   ///
   void illume_command_send(Elm_Illume_Command command_, void * params_) const;

   void activate() const;

   /// @param subobj 
   ///
   void resize_object_add(::evas::object subobj_) const;

   void raise() const;

   void lower() const;

   /// @param subobj 
   ///
   void resize_object_del(::evas::object subobj_) const;

   /// @param h 
   /// @param v 
   ///
   void center(bool h_, bool v_) const;

   /// @param key 
   /// @param modifiers 
   /// @param not_modifiers 
   /// @param proirity 
   /// @param grab_mode 
   ///
   bool keygrab_set(::efl::eina::string_view key_, Evas_Modifier_Mask modifiers_, Evas_Modifier_Mask not_modifiers_, int proirity_, Elm_Win_Keygrab_Mode grab_mode_) const;

   /// @param key 
   /// @param modifiers 
   /// @param not_modifiers 
   ///
   bool keygrab_unset(::efl::eina::string_view key_, Evas_Modifier_Mask modifiers_, Evas_Modifier_Mask not_modifiers_) const;

   bool keyboard_win_get() const;

   void keyboard_win_set(bool is_keyboard_) const;

   bool autodel_get() const;

   void autodel_set(bool autodel_) const;

   bool autohide_get() const;

   void autohide_set(bool autohide_) const;

   bool override_get() const;

   void override_set(bool override_) const;

   bool iconified_get() const;

   void iconified_set(bool iconified_) const;

   bool wm_available_rotations_get(int ** rotations_, unsigned int* count_) const;

   void wm_available_rotations_set(const int * rotations_, unsigned int count_) const;

   int quickpanel_zone_get() const;

   void quickpanel_zone_set(int zone_) const;

   bool maximized_get() const;

   void maximized_set(bool maximized_) const;

   bool modal_get() const;

   void modal_set(bool modal_) const;

   ::efl::eina::string_view icon_name_get() const;

   void icon_name_set(::efl::eina::string_view icon_name_) const;

   bool withdrawn_get() const;

   void withdrawn_set(bool withdrawn_) const;

   ::efl::eina::string_view role_get() const;

   void role_set(::efl::eina::string_view role_) const;

   void size_step_get(int* w_, int* h_) const;

   void size_step_set(int w_, int h_) const;

   ::efl::eina::optional< ::efl::eina::string_view > focus_highlight_style_get() const;

   void focus_highlight_style_set(::efl::eina::optional< ::efl::eina::string_view > style_) const;

   bool borderless_get() const;

   void borderless_set(bool borderless_) const;

   bool screen_constrain_get() const;

   void screen_constrain_set(bool constrain_) const;

   bool available_profiles_get(char *** profiles_, unsigned int* count_) const;

   void available_profiles_set(const char ** profiles_, unsigned int count_) const;

   bool focus_highlight_enabled_get() const;

   void focus_highlight_enabled_set(bool enabled_) const;

   ::efl::eina::string_view title_get() const;

   void title_set(::efl::eina::string_view title_) const;

   bool alpha_get() const;

   void alpha_set(bool alpha_) const;

   bool urgent_get() const;

   void urgent_set(bool urgent_) const;

   int rotation_get() const;

   void rotation_set(int rotation_) const;

   ::evas::object icon_object_get() const;

   void icon_object_set(::evas::object icon_) const;

   int quickpanel_priority_minor_get() const;

   void quickpanel_priority_minor_set(int priority_) const;

   bool sticky_get() const;

   void sticky_set(bool sticky_) const;

   Elm_Win_Keyboard_Mode keyboard_mode_get() const;

   void keyboard_mode_set(Elm_Win_Keyboard_Mode mode_) const;

   bool focus_highlight_animate_get() const;

   void focus_highlight_animate_set(bool animate_) const;

   double aspect_get() const;

   void aspect_set(double aspect_) const;

   int quickpanel_priority_major_get() const;

   void quickpanel_priority_major_set(int priority_) const;

   Elm_Win_Indicator_Opacity_Mode indicator_opacity_get() const;

   void indicator_opacity_set(Elm_Win_Indicator_Opacity_Mode mode_) const;

   bool demand_attention_get() const;

   void demand_attention_set(bool demand_attention_) const;

   int wm_preferred_rotation_get() const;

   void wm_preferred_rotation_set(int rotation_) const;

   int layer_get() const;

   void layer_set(int layer_) const;

   ::efl::eina::string_view profile_get() const;

   void profile_set(::efl::eina::string_view profile_) const;

   bool shaped_get() const;

   void shaped_set(bool shaped_) const;

   bool fullscreen_get() const;

   void fullscreen_set(bool fullscreen_) const;

   bool wm_manual_rotation_done_get() const;

   void wm_manual_rotation_done_set(bool set_) const;

   Elm_Win_Indicator_Mode indicator_mode_get() const;

   void indicator_mode_set(Elm_Win_Indicator_Mode mode_) const;

   bool conformant_get() const;

   void conformant_set(bool conformant_) const;

   void size_base_get(int* w_, int* h_) const;

   void size_base_set(int w_, int h_) const;

   bool quickpanel_get() const;

   void quickpanel_set(bool quickpanel_) const;

   void rotation_with_resize_set(int rotation_) const;

   void prop_focus_skip_set(bool skip_) const;

   void screen_position_get(int* x_, int* y_) const;

   bool wm_rotation_supported_get() const;

   Ecore_X_Window xwindow_get() const;

   bool focus_get() const;

   void screen_size_get(int* x_, int* y_, int* w_, int* h_) const;

   ::evas::object main_menu_get() const;

   Ecore_Wl2_Window * wl_window_get() const;

   Ecore_Cocoa_Window * cocoa_window_get() const;

   Ecore_Win32_Window * win32_window_get() const;

   Ecore_Window window_id_get() const;

   void screen_dpi_get(int* xdpi_, int* ydpi_) const;

   ::evas::object inlined_image_object_get() const;

   void name_set(::efl::eina::optional< ::efl::eina::string_view > name_) const;

   Elm_Win_Type type_get() const;

   void type_set(Elm_Win_Type type_) const;

   bool noblank_get() const;

   void noblank_set(bool noblank_) const;

   void * trap_data_get() const;

#ifdef WIN_PROTECTED
   void fake_canvas_set(Ecore_Evas * oee_) const;
#endif

   template <typename F>
   ::efl::eo::signal_connection
   callback_access_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIDGET_EVENT_ACCESS_CHANGED );
   }

   template <typename T>
   void
   callback_access_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_ACCESS_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_active_descendant_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED );
   }

   template <typename T>
   void
   callback_active_descendant_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_added_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED );
   }

   template <typename T>
   void
   callback_added_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ADDED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_animator_tick_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ANIMATOR_TICK, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ANIMATOR_TICK );
   }

   template <typename T>
   void
   callback_animator_tick_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ANIMATOR_TICK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_size_hints_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS );
   }

   template <typename T>
   void
   callback_changed_size_hints_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_children_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED );
   }

   template <typename T>
   void
   callback_children_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_delete_request_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_DELETE_REQUEST, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_DELETE_REQUEST );
   }

   template <typename T>
   void
   callback_delete_request_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_DELETE_REQUEST, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_elm_action_block_menu_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ELM_ACTION_BLOCK_MENU, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ELM_ACTION_BLOCK_MENU );
   }

   template <typename T>
   void
   callback_elm_action_block_menu_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ELM_ACTION_BLOCK_MENU, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_IN );
   }

   template <typename T>
   void
   callback_focus_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_OUT );
   }

   template <typename T>
   void
   callback_focus_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_FOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIDGET_EVENT_FOCUSED );
   }

   template <typename T>
   void
   callback_focused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_FOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_free_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FREE, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_FREE );
   }

   template <typename T>
   void
   callback_free_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FREE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_fullscreen_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_FULLSCREEN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_FULLSCREEN );
   }

   template <typename T>
   void
   callback_fullscreen_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_FULLSCREEN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hide_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HIDE, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_HIDE );
   }

   template <typename T>
   void
   callback_hide_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HIDE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hold_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HOLD, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_HOLD );
   }

   template <typename T>
   void
   callback_hold_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HOLD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_iconified_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ICONIFIED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ICONIFIED );
   }

   template <typename T>
   void
   callback_iconified_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ICONIFIED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_preloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_PRELOADED );
   }

   template <typename T>
   void
   callback_image_preloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_RESIZE );
   }

   template <typename T>
   void
   callback_image_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_unloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_UNLOADED );
   }

   template <typename T>
   void
   callback_image_unloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_indicator_prop_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_INDICATOR_PROP_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_INDICATOR_PROP_CHANGED );
   }

   template <typename T>
   void
   callback_indicator_prop_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_INDICATOR_PROP_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_ioerr_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_IOERR, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_IOERR );
   }

   template <typename T>
   void
   callback_ioerr_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_IOERR, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_KEY_DOWN );
   }

   template <typename T>
   void
   callback_key_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_KEY_UP );
   }

   template <typename T>
   void
   callback_key_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_language_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIDGET_EVENT_LANGUAGE_CHANGED );
   }

   template <typename T>
   void
   callback_language_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_LANGUAGE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_maximized_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_MAXIMIZED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_MAXIMIZED );
   }

   template <typename T>
   void
   callback_maximized_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_MAXIMIZED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_DOWN );
   }

   template <typename T>
   void
   callback_mouse_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_IN );
   }

   template <typename T>
   void
   callback_mouse_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_MOVE );
   }

   template <typename T>
   void
   callback_mouse_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_OUT );
   }

   template <typename T>
   void
   callback_mouse_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_UP );
   }

   template <typename T>
   void
   callback_mouse_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_wheel_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_WHEEL );
   }

   template <typename T>
   void
   callback_mouse_wheel_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MOVE );
   }

   template <typename T>
   void
   callback_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_moved_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_MOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_MOVED );
   }

   template <typename T>
   void
   callback_moved_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_MOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MULTI_DOWN );
   }

   template <typename T>
   void
   callback_multi_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MULTI_MOVE );
   }

   template <typename T>
   void
   callback_multi_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_MULTI_UP );
   }

   template <typename T>
   void
   callback_multi_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_normal_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_NORMAL, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_NORMAL );
   }

   template <typename T>
   void
   callback_normal_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_NORMAL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_profile_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_PROFILE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_PROFILE_CHANGED );
   }

   template <typename T>
   void
   callback_profile_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_PROFILE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_property_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED );
   }

   template <typename T>
   void
   callback_property_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_removed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED );
   }

   template <typename T>
   void
   callback_removed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_REMOVED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_RESIZE );
   }

   template <typename T>
   void
   callback_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_restack_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESTACK, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_RESTACK );
   }

   template <typename T>
   void
   callback_restack_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESTACK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_rotation_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_ROTATION_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_ROTATION_CHANGED );
   }

   template <typename T>
   void
   callback_rotation_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_ROTATION_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_show_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_SHOW, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         EVAS_OBJECT_EVENT_SHOW );
   }

   template <typename T>
   void
   callback_show_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_SHOW, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_state_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED );
   }

   template <typename T>
   void
   callback_state_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_stick_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_STICK, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_STICK );
   }

   template <typename T>
   void
   callback_stick_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_STICK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_theme_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_THEME_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_THEME_CHANGED );
   }

   template <typename T>
   void
   callback_theme_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_THEME_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unfocused_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIDGET_EVENT_UNFOCUSED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIDGET_EVENT_UNFOCUSED );
   }

   template <typename T>
   void
   callback_unfocused_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIDGET_EVENT_UNFOCUSED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unfullscreen_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_UNFULLSCREEN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_UNFULLSCREEN );
   }

   template <typename T>
   void
   callback_unfullscreen_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_UNFULLSCREEN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unmaximized_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_UNMAXIMIZED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_UNMAXIMIZED );
   }

   template <typename T>
   void
   callback_unmaximized_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_UNMAXIMIZED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_unstick_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_UNSTICK, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_UNSTICK );
   }

   template <typename T>
   void
   callback_unstick_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_UNSTICK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_visible_data_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED );
   }

   template <typename T>
   void
   callback_visible_data_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_window_activated_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_ACTIVATED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_ACTIVATED );
   }

   template <typename T>
   void
   callback_window_activated_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_ACTIVATED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_window_created_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_CREATED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_CREATED );
   }

   template <typename T>
   void
   callback_window_created_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_CREATED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_window_deactivated_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_DEACTIVATED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_DEACTIVATED );
   }

   template <typename T>
   void
   callback_window_deactivated_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_DEACTIVATED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_window_destroyed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_DESTROYED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_DESTROYED );
   }

   template <typename T>
   void
   callback_window_destroyed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_DESTROYED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_window_maximized_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_MAXIMIZED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_MAXIMIZED );
   }

   template <typename T>
   void
   callback_window_maximized_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_MAXIMIZED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_window_minimized_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_MINIMIZED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_MINIMIZED );
   }

   template <typename T>
   void
   callback_window_minimized_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_MINIMIZED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_window_restored_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_RESTORED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_RESTORED );
   }

   template <typename T>
   void
   callback_window_restored_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_ATSPI_WINDOW_EVENT_WINDOW_RESTORED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_withdrawn_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_WITHDRAWN, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_WITHDRAWN );
   }

   template <typename T>
   void
   callback_withdrawn_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_WITHDRAWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_wm_rotation_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_WIN_EVENT_WM_ROTATION_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm::win, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm::win, function_type>,
         ELM_WIN_EVENT_WM_ROTATION_CHANGED );
   }

   template <typename T>
   void
   callback_wm_rotation_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_WIN_EVENT_WM_ROTATION_CHANGED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_WIN_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm::win::address_of<address_of>
      , ::eo_cxx::efl::gfx::base::address_of<address_of>
      , ::eo_cxx::efl::gfx::stack::address_of<address_of>
      , ::eo_cxx::elm::widget::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_action::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_component::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_widget_action::address_of<address_of>
      , ::eo_cxx::elm_interface_atspi_window::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::eo_cxx::evas::common_interface::address_of<address_of>
      , ::eo_cxx::evas::object::address_of<address_of>
      , ::eo_cxx::evas::object_smart::address_of<address_of>
      , ::eo_cxx::evas::signal_interface::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm::win* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm::win::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::base::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::stack::address_const_of<address_const_of>
      , ::eo_cxx::elm::widget::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_accessible::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_action::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_component::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_widget_action::address_const_of<address_const_of>
      , ::eo_cxx::elm_interface_atspi_window::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::eo_cxx::evas::common_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::object::address_const_of<address_const_of>
      , ::eo_cxx::evas::object_smart::address_const_of<address_const_of>
      , ::eo_cxx::evas::signal_interface::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm::win const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p, _c_name _c0, _c_type _c1)
   {
      Eo* _ret_eo = eo_add_ref(ELM_WIN_CLASS, _p._eo_raw, _c0(), _c1());

      _c0.register_ev_del_free_callback(_ret_eo);
      _c1.register_ev_del_free_callback(_ret_eo);
      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm::win) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm::win>::value, "");

}


#include "elm_win.eo.impl.hh"

#endif // EFL_GENERATED_ELM_WIN_HH

