/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MutableCallSite;

public class SwitchPoint {
    private static final MethodHandle K_true = MethodHandles.constant(Boolean.TYPE, true);
    private static final MethodHandle K_false = MethodHandles.constant(Boolean.TYPE, false);
    private final MutableCallSite mcs = new MutableCallSite(K_true);
    private final MethodHandle mcsInvoker = this.mcs.dynamicInvoker();

    public boolean hasBeenInvalidated() {
        return this.mcs.getTarget() != K_true;
    }

    public MethodHandle guardWithTest(MethodHandle target, MethodHandle fallback) {
        if (this.mcs.getTarget() == K_false) {
            return fallback;
        }
        return MethodHandles.guardWithTest(this.mcsInvoker, target, fallback);
    }

    public static void invalidateAll(SwitchPoint[] switchPoints) {
        SwitchPoint spt;
        if (switchPoints.length == 0) {
            return;
        }
        MutableCallSite[] sites = new MutableCallSite[switchPoints.length];
        for (int i = 0; i < switchPoints.length && (spt = switchPoints[i]) != null; ++i) {
            sites[i] = spt.mcs;
            spt.mcs.setTarget(K_false);
        }
        MutableCallSite.syncAll(sites);
    }
}

