/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class JumboEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private static final long serialVersionUID = 334349849919042784L;
    private long[] elements;
    private int size = 0;

    JumboEnumSet(Class<E> elementType, Enum[] universe) {
        super(elementType, universe);
        this.elements = new long[universe.length + 63 >>> 6];
    }

    @Override
    void addRange(E from, E to) {
        int toIndex;
        int fromIndex = ((Enum)from).ordinal() >>> 6;
        if (fromIndex == (toIndex = ((Enum)to).ordinal() >>> 6)) {
            this.elements[fromIndex] = -1L >>> ((Enum)from).ordinal() - ((Enum)to).ordinal() - 1 << ((Enum)from).ordinal();
        } else {
            this.elements[fromIndex] = -1L << ((Enum)from).ordinal();
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                this.elements[i] = -1L;
            }
            this.elements[toIndex] = -1L >>> 63 - ((Enum)to).ordinal();
        }
        this.size = ((Enum)to).ordinal() - ((Enum)from).ordinal() + 1;
    }

    @Override
    void addAll() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = -1L;
        }
        int n = this.elements.length - 1;
        this.elements[n] = this.elements[n] >>> -this.universe.length;
        this.size = this.universe.length;
    }

    @Override
    void complement() {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = this.elements[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n = this.elements.length - 1;
        this.elements[n] = this.elements[n] & -1L >>> -this.universe.length;
        this.size = this.universe.length - this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new EnumSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object e) {
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != this.elementType && eClass.getSuperclass() != this.elementType) {
            return false;
        }
        int eOrdinal = ((Enum)e).ordinal();
        return (this.elements[eOrdinal >>> 6] & 1L << eOrdinal) != 0L;
    }

    @Override
    public boolean add(E e) {
        boolean result;
        this.typeCheck(e);
        int eOrdinal = ((Enum)e).ordinal();
        int eWordNum = eOrdinal >>> 6;
        long oldElements = this.elements[eWordNum];
        int n = eWordNum;
        this.elements[n] = this.elements[n] | 1L << eOrdinal;
        boolean bl = result = this.elements[eWordNum] != oldElements;
        if (result) {
            ++this.size;
        }
        return result;
    }

    @Override
    public boolean remove(Object e) {
        boolean result;
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != this.elementType && eClass.getSuperclass() != this.elementType) {
            return false;
        }
        int eOrdinal = ((Enum)e).ordinal();
        int eWordNum = eOrdinal >>> 6;
        long oldElements = this.elements[eWordNum];
        int n = eWordNum;
        this.elements[n] = this.elements[n] & (1L << eOrdinal ^ 0xFFFFFFFFFFFFFFFFL);
        boolean bl = result = this.elements[eWordNum] != oldElements;
        if (result) {
            --this.size;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!(c instanceof JumboEnumSet)) {
            return super.containsAll(c);
        }
        JumboEnumSet es = (JumboEnumSet)c;
        if (es.elementType != this.elementType) {
            return es.isEmpty();
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if ((es.elements[i] & (this.elements[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!(c instanceof JumboEnumSet)) {
            return super.addAll(c);
        }
        JumboEnumSet es = (JumboEnumSet)c;
        if (es.elementType != this.elementType) {
            if (es.isEmpty()) {
                return false;
            }
            throw new ClassCastException(es.elementType + " != " + this.elementType);
        }
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] | es.elements[i];
        }
        return this.recalculateSize();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!(c instanceof JumboEnumSet)) {
            return super.removeAll(c);
        }
        JumboEnumSet es = (JumboEnumSet)c;
        if (es.elementType != this.elementType) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] & (es.elements[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this.recalculateSize();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!(c instanceof JumboEnumSet)) {
            return super.retainAll(c);
        }
        JumboEnumSet es = (JumboEnumSet)c;
        if (es.elementType != this.elementType) {
            boolean changed = this.size != 0;
            this.clear();
            return changed;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            int n = i;
            this.elements[n] = this.elements[n] & es.elements[i];
        }
        return this.recalculateSize();
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, 0L);
        this.size = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof JumboEnumSet)) {
            return super.equals(o);
        }
        JumboEnumSet es = (JumboEnumSet)o;
        if (es.elementType != this.elementType) {
            return this.size == 0 && es.size == 0;
        }
        return Arrays.equals(es.elements, this.elements);
    }

    private boolean recalculateSize() {
        int oldSize = this.size;
        this.size = 0;
        for (long elt : this.elements) {
            this.size += Long.bitCount(elt);
        }
        return this.size != oldSize;
    }

    @Override
    public EnumSet<E> clone() {
        JumboEnumSet result = (JumboEnumSet)super.clone();
        result.elements = (long[])result.elements.clone();
        return result;
    }

    private class EnumSetIterator<E extends Enum<E>>
    implements Iterator<E> {
        long unseen;
        int unseenIndex = 0;
        long lastReturned = 0L;
        int lastReturnedIndex = 0;

        EnumSetIterator() {
            this.unseen = JumboEnumSet.this.elements[0];
        }

        @Override
        public boolean hasNext() {
            while (this.unseen == 0L && this.unseenIndex < JumboEnumSet.this.elements.length - 1) {
                this.unseen = JumboEnumSet.this.elements[++this.unseenIndex];
            }
            return this.unseen != 0L;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.unseen & -this.unseen;
            this.lastReturnedIndex = this.unseenIndex;
            this.unseen -= this.lastReturned;
            return (E)JumboEnumSet.this.universe[(this.lastReturnedIndex << 6) + Long.numberOfTrailingZeros(this.lastReturned)];
        }

        @Override
        public void remove() {
            if (this.lastReturned == 0L) {
                throw new IllegalStateException();
            }
            long oldElements = JumboEnumSet.this.elements[this.lastReturnedIndex];
            long[] lArray = JumboEnumSet.this.elements;
            int n = this.lastReturnedIndex;
            lArray[n] = lArray[n] & (this.lastReturned ^ 0xFFFFFFFFFFFFFFFFL);
            if (oldElements != JumboEnumSet.this.elements[this.lastReturnedIndex]) {
                JumboEnumSet.this.size--;
            }
            this.lastReturned = 0L;
        }
    }
}

