/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ServletRequestCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;

public final class RuntimeCCTNodeProcessor {
    private static final Logger LOGGER = Logger.getLogger(RuntimeCCTNodeProcessor.class.getName());

    private RuntimeCCTNodeProcessor() {
    }

    public static void process(RuntimeCCTNode runtimeCCTNode, Plugin ... pluginArray) {
        ArrayDeque<Item<RuntimeCCTNode>> arrayDeque = new ArrayDeque<Item<RuntimeCCTNode>>();
        for (Plugin plugin : pluginArray) {
            if (plugin == null) continue;
            plugin.onStart();
        }
        arrayDeque.push(new SimpleItem(arrayDeque, runtimeCCTNode, pluginArray));
        int n = runtimeCCTNode instanceof SimpleCPUCCTNode ? ((SimpleCPUCCTNode)runtimeCCTNode).getMaxMethodId() : Integer.MAX_VALUE;
        RuntimeCCTNodeProcessor.processStack(n, arrayDeque, pluginArray);
        for (Plugin plugin : pluginArray) {
            if (plugin == null) continue;
            plugin.onStop();
        }
    }

    private static void processStack(int n, Deque<Item<RuntimeCCTNode>> deque, Plugin ... pluginArray) {
        while (!deque.isEmpty()) {
            Item<RuntimeCCTNode> item = deque.pollLast();
            if (item == null) continue;
            item.process(n);
        }
    }

    private static class BackoutItem
    extends Item<RuntimeCCTNode> {
        public BackoutItem(RuntimeCCTNode runtimeCCTNode, Plugin ... pluginArray) {
            super(runtimeCCTNode, pluginArray);
        }

        @Override
        void process(int n) {
            for (Plugin plugin : this.plugins) {
                if (plugin == null) continue;
                plugin.onBackout(this.instance);
            }
        }
    }

    private static class SimpleItem
    extends Item<RuntimeCCTNode> {
        private final Deque<Item<RuntimeCCTNode>> stack;

        public SimpleItem(Deque<Item<RuntimeCCTNode>> deque, RuntimeCCTNode runtimeCCTNode, Plugin ... pluginArray) {
            super(runtimeCCTNode, pluginArray);
            this.stack = deque;
        }

        @Override
        void process(int n) {
            this.stack.add(new BackoutItem(this.instance, this.plugins));
            for (RuntimeCCTNode object : this.instance.getChildren()) {
                if (object instanceof MethodCPUCCTNode && ((MethodCPUCCTNode)object).getMethodId() >= n) continue;
                this.stack.add(new SimpleItem(this.stack, object, this.plugins));
            }
            for (Plugin plugin : this.plugins) {
                if (plugin == null) continue;
                plugin.onNode(this.instance);
            }
        }
    }

    private static abstract class Item<T extends RuntimeCCTNode> {
        protected final T instance;
        protected final Plugin[] plugins;

        public Item(T t, Plugin ... pluginArray) {
            this.instance = t;
            this.plugins = pluginArray;
        }

        abstract void process(int var1);
    }

    public static abstract class PluginAdapter
    implements Plugin {
        @Override
        public final void onBackout(RuntimeCCTNode runtimeCCTNode) {
            if (runtimeCCTNode instanceof MethodCPUCCTNode) {
                this.onBackout((MethodCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof MarkedCPUCCTNode) {
                this.onBackout((MarkedCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof ThreadCPUCCTNode) {
                this.onBackout((ThreadCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof SimpleCPUCCTNode) {
                this.onBackout((SimpleCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof ServletRequestCPUCCTNode) {
                this.onBackout((ServletRequestCPUCCTNode)runtimeCCTNode);
            } else {
                LOGGER.log(Level.WARNING, "Can not process uncrecoginzed node class {0}", runtimeCCTNode.getClass());
            }
        }

        @Override
        public final void onNode(RuntimeCCTNode runtimeCCTNode) {
            if (runtimeCCTNode instanceof MethodCPUCCTNode) {
                this.onNode((MethodCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof MarkedCPUCCTNode) {
                this.onNode((MarkedCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof ThreadCPUCCTNode) {
                this.onNode((ThreadCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof SimpleCPUCCTNode) {
                this.onNode((SimpleCPUCCTNode)runtimeCCTNode);
            } else if (runtimeCCTNode instanceof ServletRequestCPUCCTNode) {
                this.onNode((ServletRequestCPUCCTNode)runtimeCCTNode);
            } else {
                LOGGER.log(Level.WARNING, "Can not process uncrecoginzed node class {0}", runtimeCCTNode.getClass());
            }
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onStop() {
        }

        protected void onNode(MethodCPUCCTNode methodCPUCCTNode) {
        }

        protected void onNode(MarkedCPUCCTNode markedCPUCCTNode) {
        }

        protected void onNode(ThreadCPUCCTNode threadCPUCCTNode) {
        }

        protected void onNode(SimpleCPUCCTNode simpleCPUCCTNode) {
        }

        protected void onNode(ServletRequestCPUCCTNode servletRequestCPUCCTNode) {
        }

        protected void onBackout(MethodCPUCCTNode methodCPUCCTNode) {
        }

        protected void onBackout(MarkedCPUCCTNode markedCPUCCTNode) {
        }

        protected void onBackout(ThreadCPUCCTNode threadCPUCCTNode) {
        }

        protected void onBackout(SimpleCPUCCTNode simpleCPUCCTNode) {
        }

        protected void onBackout(ServletRequestCPUCCTNode servletRequestCPUCCTNode) {
        }
    }

    public static interface Plugin {
        public void onStart();

        public void onStop();

        public void onNode(RuntimeCCTNode var1);

        public void onBackout(RuntimeCCTNode var1);
    }
}

