/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.sparklines;

import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.gephi.utils.sparklines.SparklineGraph;
import org.gephi.utils.sparklines.SparklineParameters;

public class SparklineComponent
extends JComponent {
    private Number[] xValues;
    private Number[] yValues;
    private Number yMinValue;
    private Number yMaxValue;
    private SparklineParameters sparklineParameters;

    public SparklineComponent(Number[] yValues, SparklineParameters sparklineParameters, boolean updateMouseXPosition) {
        this(null, yValues, null, null, sparklineParameters, updateMouseXPosition);
    }

    public SparklineComponent(Number[] yValues, Number yMinValue, Number yMaxValue, SparklineParameters sparklineParameters, boolean updateMouseXPosition) {
        this(null, yValues, yMinValue, yMaxValue, sparklineParameters, updateMouseXPosition);
    }

    public SparklineComponent(Number[] xValues, Number[] yValues, SparklineParameters sparklineParameters, boolean updateMouseXPosition) {
        this(xValues, yValues, null, null, sparklineParameters, updateMouseXPosition);
    }

    public SparklineComponent(Number[] xValues, Number[] yValues, Number yMinValue, Number yMaxValue, SparklineParameters sparklineParameters, boolean updateMouseXPosition) {
        this.xValues = xValues;
        this.yValues = yValues;
        this.yMinValue = yMinValue;
        this.yMaxValue = yMaxValue;
        this.sparklineParameters = sparklineParameters;
        if (updateMouseXPosition) {
            this.initEvents();
        }
    }

    private void initEvents() {
        MouseEvents listener = new MouseEvents();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.sparklineParameters.setWidth(this.getWidth());
        this.sparklineParameters.setHeight(this.getHeight());
        BufferedImage image = SparklineGraph.draw(this.xValues, this.yValues, this.yMinValue, this.yMaxValue, this.sparklineParameters);
        g.drawImage(image, 0, 0, this);
    }

    class MouseEvents
    extends MouseAdapter
    implements MouseMotionListener {
        MouseEvents() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SparklineComponent.this.sparklineParameters.setHighlightedValueXPosition(e.getX());
            SparklineComponent.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SparklineComponent.this.sparklineParameters.setHighlightedValueXPosition(null);
            SparklineComponent.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SparklineComponent.this.sparklineParameters.setHighlightedValueXPosition(e.getX());
            SparklineComponent.this.repaint();
        }
    }
}

