/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.forceAtlas2;

import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.forceAtlas2.ForceFactory;
import org.gephi.layout.plugin.forceAtlas2.Region;

public class NodesThread
implements Runnable {
    private Node[] nodes;
    private int from;
    private int to;
    private Region rootRegion;
    private boolean barnesHutOptimize;
    private ForceFactory.RepulsionForce Repulsion;
    private double barnesHutTheta;
    private double gravity;
    private ForceFactory.RepulsionForce GravityForce;
    private double scaling;

    public NodesThread(Node[] nodes, int from, int to, boolean barnesHutOptimize, double barnesHutTheta, double gravity, ForceFactory.RepulsionForce GravityForce, double scaling, Region rootRegion, ForceFactory.RepulsionForce Repulsion) {
        this.nodes = nodes;
        this.from = from;
        this.to = to;
        this.rootRegion = rootRegion;
        this.barnesHutOptimize = barnesHutOptimize;
        this.Repulsion = Repulsion;
        this.barnesHutTheta = barnesHutTheta;
        this.gravity = gravity;
        this.GravityForce = GravityForce;
        this.scaling = scaling;
    }

    @Override
    public void run() {
        Node n;
        int nIndex;
        if (this.barnesHutOptimize) {
            for (nIndex = this.from; nIndex < this.to; ++nIndex) {
                n = this.nodes[nIndex];
                this.rootRegion.applyForce(n, this.Repulsion, this.barnesHutTheta);
            }
        } else {
            for (int n1Index = this.from; n1Index < this.to; ++n1Index) {
                Node n1 = this.nodes[n1Index];
                for (int n2Index = 0; n2Index < n1Index; ++n2Index) {
                    Node n2 = this.nodes[n2Index];
                    this.Repulsion.apply(n1, n2);
                }
            }
        }
        for (nIndex = this.from; nIndex < this.to; ++nIndex) {
            n = this.nodes[nIndex];
            this.GravityForce.apply(n, this.gravity / this.scaling);
        }
    }
}

