/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.BuildAdapter;
import org.gradle.api.Action;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.internal.Actions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSrcBuildListenerFactory {
    private final Action<ProjectInternal> buildSrcRootProjectConfiguration;

    public BuildSrcBuildListenerFactory() {
        this((Action<ProjectInternal>)Actions.doNothing());
    }

    public BuildSrcBuildListenerFactory(Action<ProjectInternal> buildSrcRootProjectConfiguration) {
        this.buildSrcRootProjectConfiguration = buildSrcRootProjectConfiguration;
    }

    Listener create(boolean rebuild) {
        return new Listener(rebuild, this.buildSrcRootProjectConfiguration);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Listener
    extends BuildAdapter
    implements ModelConfigurationListener {
        private Set<File> classpath;
        private final boolean rebuild;
        private final Action<ProjectInternal> rootProjectConfiguration;

        private Listener(boolean rebuild, Action<ProjectInternal> rootProjectConfiguration) {
            this.rebuild = rebuild;
            this.rootProjectConfiguration = rootProjectConfiguration;
        }

        public void projectsLoaded(Gradle gradle) {
            this.rootProjectConfiguration.execute((Object)((ProjectInternal)gradle.getRootProject()));
        }

        @Override
        public void onConfigure(GradleInternal gradle) {
            BuildableJavaComponent mainComponent = this.mainComponentOf(gradle);
            gradle.getStartParameter().setTaskNames(this.rebuild ? mainComponent.getRebuildTasks() : mainComponent.getBuildTasks());
            this.classpath = mainComponent.getRuntimeClasspath().getFiles();
        }

        public Collection<File> getRuntimeClasspath() {
            return this.classpath;
        }

        private BuildableJavaComponent mainComponentOf(GradleInternal gradle) {
            return ((ComponentRegistry)gradle.getRootProject().getServices().get(ComponentRegistry.class)).getMainComponent();
        }
    }
}

