/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.gui.jobs.BackgroundJob;
import jadx.gui.ui.ProgressPanel;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.Utils;
import jadx.gui.utils.search.TextSearchIndex;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundWorker
extends SwingWorker<Void, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundWorker.class);
    private final CacheObject cache;
    private final ProgressPanel progressPane;

    public BackgroundWorker(CacheObject cacheObject, ProgressPanel progressPane) {
        this.cache = cacheObject;
        this.progressPane = progressPane;
    }

    public void exec() {
        if (this.isDone()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackgroundWorker.this.progressPane.setVisible(true);
            }
        });
        this.addPropertyChangeListener(this.progressPane);
        this.execute();
    }

    public void stop() {
        if (this.isDone()) {
            return;
        }
        LOG.debug("Canceling background jobs ...");
        this.cancel(false);
    }

    @Override
    protected Void doInBackground() throws Exception {
        try {
            System.gc();
            LOG.debug("Memory usage: Before decompile: {}", (Object)Utils.memoryInfo());
            this.runJob(this.cache.getDecompileJob());
            LOG.debug("Memory usage: Before index: {}", (Object)Utils.memoryInfo());
            this.runJob(this.cache.getIndexJob());
            LOG.debug("Memory usage: After index: {}", (Object)Utils.memoryInfo());
            System.gc();
            LOG.debug("Memory usage: After gc: {}", (Object)Utils.memoryInfo());
            TextSearchIndex searchIndex = this.cache.getTextIndex();
            if (searchIndex != null && searchIndex.getSkippedCount() > 0) {
                LOG.warn("Indexing of some classes skipped, count: {}, low memory: {}", (Object)searchIndex.getSkippedCount(), (Object)Utils.memoryInfo());
            }
        }
        catch (Exception e) {
            LOG.error("Exception in background worker", (Throwable)e);
        }
        return null;
    }

    private void runJob(BackgroundJob job) {
        if (this.isCancelled()) {
            return;
        }
        this.progressPane.changeLabel(this, job.getInfoString());
        Future<Boolean> future = job.process();
        while (!future.isDone()) {
            try {
                this.setProgress(job.getProgress());
                if (this.isCancelled()) {
                    future.cancel(false);
                }
                Thread.sleep(500L);
            }
            catch (Exception e) {
                LOG.error("Background worker error", (Throwable)e);
            }
        }
    }

    @Override
    protected void done() {
        this.progressPane.setVisible(false);
    }
}

