/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs2d;

import java.net.URL;
import javajs.api.GenericFileInterface;
import javajs.util.AjaxURLConnection;
import javajs.util.OC;
import javajs.util.PT;
import org.jmol.viewer.Viewer;

public class JSFile
implements GenericFileInterface {
    private String name;
    private String fullName;

    static GenericFileInterface newFile(String name) {
        return new JSFile(name);
    }

    JSFile(String name) {
        this.name = name.replace('\\', '/');
        this.fullName = name;
        if (!this.fullName.startsWith("/") && OC.urlTypeIndex(name) < 0) {
            this.fullName = Viewer.jsDocumentBase + "/" + this.fullName;
        }
        this.fullName = PT.rep(this.fullName, "/./", "/");
        name = name.substring(name.lastIndexOf("/") + 1);
    }

    @Override
    public GenericFileInterface getParentAsFile() {
        int pt = this.fullName.lastIndexOf("/");
        return pt < 0 ? null : new JSFile(this.fullName.substring(0, pt));
    }

    @Override
    public String getFullPath() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.fullName.endsWith("/");
    }

    @Override
    public long length() {
        return 0L;
    }

    public static Object getURLContents(URL url, byte[] outputBytes, String post) {
        try {
            AjaxURLConnection conn = (AjaxURLConnection)url.openConnection();
            if (outputBytes != null) {
                conn.outputBytes(outputBytes);
            } else if (post != null) {
                conn.outputString(post);
            }
            return conn.getContents();
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

