/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class StringTokenizer
implements Enumeration<String> {
    private int currentPosition;
    private int newPosition;
    private int maxPosition;
    private String str;
    private String delimiters;
    private final boolean retDelims;
    private boolean delimsChanged;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m = '\u0000';
        for (int i = 0; i < this.delimiters.length(); ++i) {
            char c = this.delimiters.charAt(i);
            if (m >= c) continue;
            m = c;
        }
        this.maxDelimChar = m;
    }

    public StringTokenizer(@NotNull String str, @NotNull String delim, boolean returnDelims) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/util/text/StringTokenizer", "<init>"));
        }
        if (delim == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delim", "com/intellij/util/text/StringTokenizer", "<init>"));
        }
        this.currentPosition = 0;
        this.newPosition = -1;
        this.delimsChanged = false;
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.setMaxDelimChar();
    }

    public StringTokenizer(@NotNull String str, @NotNull String delim) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/util/text/StringTokenizer", "<init>"));
        }
        if (delim == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delim", "com/intellij/util/text/StringTokenizer", "<init>"));
        }
        this(str, delim, false);
    }

    private int skipDelimiters(int startPos) {
        char c;
        int position;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (position = startPos; !this.retDelims && position < this.maxPosition && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0; ++position) {
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && ((c = this.str.charAt(position)) > this.maxDelimChar || this.delimiters.indexOf(c) < 0); ++position) {
        }
        if (this.retDelims && startPos == position && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    @NotNull
    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        String string = this.str.substring(start, this.currentPosition);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/StringTokenizer", "nextToken"));
        }
        return string;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    @NotNull
    public String nextElement() {
        String string = this.nextToken();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/StringTokenizer", "nextElement"));
        }
        return string;
    }
}

