/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class OWLClassExpressionCollector
extends OWLObjectVisitorExAdapter<Set<OWLClassExpression>> {
    public OWLClassExpressionCollector() {
        super(CollectionFactory.emptySet());
    }

    @Override
    public Set<OWLClassExpression> visit(SWRLClassAtom node) {
        return node.getPredicate().accept(this);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLSubClassOfAxiom axiom) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.addAll((Collection)axiom.getSubClass().accept(this));
        result.addAll((Collection)axiom.getSuperClass().accept(this));
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLOntology ontology) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (OWLAxiom oWLAxiom : ontology.getLogicalAxioms()) {
            result.addAll((Collection<OWLClassExpression>)oWLAxiom.accept(this));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLClass ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectIntersectionOf ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        for (OWLClassExpression op : ce.getOperands()) {
            result.addAll((Collection<OWLClassExpression>)op.accept(this));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectUnionOf ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        for (OWLClassExpression op : ce.getOperands()) {
            result.addAll((Collection<OWLClassExpression>)op.accept(this));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectComplementOf ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        result.addAll((Collection)ce.getOperand().accept(this));
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectSomeValuesFrom ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        result.addAll((Collection)((OWLClassExpression)ce.getFiller()).accept(this));
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectAllValuesFrom ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        result.addAll((Collection)((OWLClassExpression)ce.getFiller()).accept(this));
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDisjointClassesAxiom axiom) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (OWLClassExpression ce : axiom.getClassExpressions()) {
            result.addAll((Collection<OWLClassExpression>)ce.accept(this));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectHasValue ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataPropertyDomainAxiom axiom) {
        return axiom.getDomain().accept(this);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectMinCardinality ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        result.addAll((Collection)((OWLClassExpression)ce.getFiller()).accept(this));
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectPropertyDomainAxiom axiom) {
        return axiom.getDomain().accept(this);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectExactCardinality ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        result.addAll((Collection)((OWLClassExpression)ce.getFiller()).accept(this));
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectMaxCardinality ce) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(ce);
        result.addAll((Collection)((OWLClassExpression)ce.getFiller()).accept(this));
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectHasSelf ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectOneOf ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataSomeValuesFrom ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataAllValuesFrom ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataHasValue ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataMinCardinality ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectPropertyRangeAxiom axiom) {
        return ((OWLClassExpression)axiom.getRange()).accept(this);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataExactCardinality ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataMaxCardinality ce) {
        return OWLClassExpressionCollector.toSet(ce);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDisjointUnionAxiom axiom) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.add(axiom.getOWLClass());
        for (OWLClassExpression ce : axiom.getClassExpressions()) {
            result.addAll((Collection<OWLClassExpression>)ce.accept(this));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDeclarationAxiom axiom) {
        return axiom.getEntity().accept(this);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLClassAssertionAxiom axiom) {
        return axiom.getClassExpression().accept(this);
    }

    @Override
    public Set<OWLClassExpression> visit(OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (OWLClassExpression ce : axiom.getClassExpressions()) {
            result.addAll((Collection<OWLClassExpression>)ce.accept(this));
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLHasKeyAxiom axiom) {
        return axiom.getClassExpression().accept(this);
    }

    @Override
    public Set<OWLClassExpression> visit(SWRLRule rule) {
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (SWRLAtom atom : rule.getBody()) {
            result.addAll((Collection<OWLClassExpression>)atom.accept(this));
        }
        for (SWRLAtom atom : rule.getHead()) {
            result.addAll((Collection<OWLClassExpression>)atom.accept(this));
        }
        return result;
    }

    @Nonnull
    private static Set<OWLClassExpression> toSet(@Nonnull OWLClassExpression t) {
        return CollectionFactory.createSet(t);
    }
}

