/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public class ReferencedEntitySetProvider
implements OWLEntitySetProvider<OWLEntity> {
    @Nonnull
    private final Set<OWLOntology> ontologies;

    public ReferencedEntitySetProvider(@Nonnull Set<OWLOntology> ontologies) {
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
    }

    @Override
    public Set<OWLEntity> getEntities() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (OWLOntology ont : this.ontologies) {
            entities.addAll(ont.getClassesInSignature());
            entities.addAll(ont.getObjectPropertiesInSignature());
            entities.addAll(ont.getDataPropertiesInSignature());
            entities.addAll(ont.getIndividualsInSignature());
            entities.addAll(ont.getAnnotationPropertiesInSignature(Imports.EXCLUDED));
            entities.addAll(ont.getDatatypesInSignature());
        }
        return entities;
    }
}

