/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamExInternals;

abstract class TreeSpliterator<T, U>
extends StreamExInternals.CloneableSpliterator<U, TreeSpliterator<T, U>>
implements Consumer<T> {
    T cur;
    List<StreamExInternals.PairBox<Spliterator<T>, Stream<T>>> spliterators;
    Runnable closeHandler = null;
    long size = Long.MAX_VALUE;

    TreeSpliterator(T root) {
        this.cur = root;
    }

    boolean advance() {
        List<StreamExInternals.PairBox<Spliterator<T>, Stream<T>>> spltrs = this.spliterators;
        if (spltrs == null) {
            this.spliterators = new ArrayList<StreamExInternals.PairBox<Spliterator<T>, Stream<T>>>();
            spltrs = this.spliterators;
            return true;
        }
        for (int lastIdx = spltrs.size() - 1; lastIdx >= 0; --lastIdx) {
            StreamExInternals.PairBox<Spliterator<T>, Stream<T>> pair = spltrs.get(lastIdx);
            Spliterator spltr = (Spliterator)pair.a;
            if (spltr.tryAdvance(this)) {
                return true;
            }
            if (pair.b != null) {
                ((Stream)pair.b).close();
            }
            spltrs.remove(lastIdx);
        }
        return false;
    }

    boolean append(Stream<T> stream) {
        if (stream != null) {
            this.spliterators.add(new StreamExInternals.PairBox(stream.spliterator(), stream));
        }
        return true;
    }

    abstract Stream<T> getStart();

    abstract U getStartElement();

    @Override
    public Spliterator<U> trySplit() {
        if (this.spliterators == null) {
            this.spliterators = new ArrayList<StreamExInternals.PairBox<Spliterator<T>, Stream<T>>>();
            Stream<T> stream = this.getStart();
            if (stream != null) {
                this.spliterators.add(new StreamExInternals.PairBox(((Stream)stream.parallel()).spliterator(), null));
                this.closeHandler = stream::close;
            }
            return new ConstSpliterator.OfRef<U>(this.getStartElement(), 1L, true);
        }
        int size = this.spliterators.size();
        if (size != 1) {
            return null;
        }
        Spliterator prefix = ((Spliterator)this.spliterators.get((int)0).a).trySplit();
        if (prefix == null) {
            return null;
        }
        TreeSpliterator clone = (TreeSpliterator)this.doClone();
        clone.size /= 2L;
        this.size -= clone.size;
        clone.spliterators = new ArrayList<StreamExInternals.PairBox<Spliterator<T>, Stream<T>>>();
        clone.spliterators.add(new StreamExInternals.PairBox(prefix, null));
        this.closeHandler = StreamContext.compose(this.closeHandler, clone::close);
        return clone;
    }

    @Override
    public long estimateSize() {
        return this.size;
    }

    @Override
    public int characteristics() {
        return 16;
    }

    @Override
    public void accept(T t) {
        this.cur = t;
    }

    void close() {
        if (this.spliterators != null) {
            Throwable t = null;
            for (int i = this.spliterators.size() - 1; i >= 0; --i) {
                try {
                    Stream stream = (Stream)this.spliterators.get((int)i).b;
                    if (stream == null) continue;
                    stream.close();
                    continue;
                }
                catch (Error | RuntimeException e) {
                    if (t == null) {
                        t = e;
                        continue;
                    }
                    t.addSuppressed(e);
                }
            }
            if (this.closeHandler != null) {
                try {
                    this.closeHandler.run();
                }
                catch (Error | RuntimeException e) {
                    if (t == null) {
                        t = e;
                    }
                    t.addSuppressed(e);
                }
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
    }

    static class Depth<T>
    extends TreeSpliterator<T, Map.Entry<Integer, T>> {
        private final BiFunction<Integer, T, Stream<T>> mapper;

        Depth(T root, BiFunction<Integer, T, Stream<T>> mapper) {
            super(root);
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<Integer, T>> action) {
            if (!this.advance()) {
                return false;
            }
            Object e = this.cur;
            int depth = this.spliterators.size();
            action.accept(new StreamExInternals.ObjIntBox<Object>(e, depth));
            return this.append(this.mapper.apply(depth, (Integer)e));
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<Integer, T>> action) {
            DepthAcceptor<Object> acceptor = new DepthAcceptor<Object>(action, this.mapper, 0);
            if (this.spliterators != null) {
                for (int i = this.spliterators.size() - 1; i >= 0; --i) {
                    StreamExInternals.PairBox pair = (StreamExInternals.PairBox)this.spliterators.get(i);
                    ((DepthAcceptor)acceptor).depth = i + 1;
                    ((Spliterator)pair.a).forEachRemaining(acceptor);
                    if (pair.b == null) continue;
                    ((Stream)pair.b).close();
                }
            } else {
                this.spliterators = Collections.emptyList();
                acceptor.accept(this.cur);
            }
        }

        @Override
        Stream<T> getStart() {
            return this.mapper.apply(0, (Integer)this.cur);
        }

        @Override
        Map.Entry<Integer, T> getStartElement() {
            return new StreamExInternals.ObjIntBox<Object>(this.cur, 0);
        }
    }

    static class DepthAcceptor<T>
    implements Consumer<T> {
        private final Consumer<? super Map.Entry<Integer, T>> action;
        private final BiFunction<Integer, T, Stream<T>> mapper;
        private Integer depth;

        public DepthAcceptor(Consumer<? super Map.Entry<Integer, T>> action, BiFunction<Integer, T, Stream<T>> mapper, Integer depth) {
            this.action = action;
            this.mapper = mapper;
            this.depth = depth;
        }

        @Override
        public void accept(T t) {
            this.action.accept(new AbstractMap.SimpleImmutableEntry<Integer, T>(this.depth, t));
            try (Stream<T> stream = this.mapper.apply(this.depth, (Integer)t);){
                if (stream != null) {
                    Integer n = this.depth;
                    Integer n2 = this.depth = Integer.valueOf(this.depth + 1);
                    stream.spliterator().forEachRemaining(this);
                    n = this.depth;
                    n2 = this.depth = Integer.valueOf(this.depth - 1);
                }
            }
        }
    }

    static class Plain<T>
    extends TreeSpliterator<T, T> {
        private final Function<T, Stream<T>> mapper;

        Plain(T root, Function<T, Stream<T>> mapper) {
            super(root);
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (!this.advance()) {
                return false;
            }
            Object e = this.cur;
            action.accept(e);
            return this.append(this.mapper.apply(e));
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Acceptor<Object> acceptor = new Acceptor<Object>(action, this.mapper);
            if (this.spliterators != null) {
                for (int i = this.spliterators.size() - 1; i >= 0; --i) {
                    StreamExInternals.PairBox pair = (StreamExInternals.PairBox)this.spliterators.get(i);
                    ((Spliterator)pair.a).forEachRemaining(acceptor);
                    if (pair.b == null) continue;
                    ((Stream)pair.b).close();
                }
            } else {
                this.spliterators = Collections.emptyList();
                acceptor.accept(this.cur);
            }
        }

        @Override
        Stream<T> getStart() {
            return this.mapper.apply(this.cur);
        }

        @Override
        T getStartElement() {
            return (T)this.cur;
        }
    }

    static class Acceptor<T>
    implements Consumer<T> {
        private final Consumer<? super T> action;
        private final Function<T, Stream<T>> mapper;

        public Acceptor(Consumer<? super T> action, Function<T, Stream<T>> mapper) {
            this.action = action;
            this.mapper = mapper;
        }

        @Override
        public void accept(T t) {
            this.action.accept(t);
            try (Stream<T> stream = this.mapper.apply(t);){
                if (stream != null) {
                    stream.spliterator().forEachRemaining(this);
                }
            }
        }
    }
}

