/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericTask;
import com.intellij.tasks.generic.ResponseHandler;
import com.intellij.tasks.generic.ResponseType;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="RegExResponseHandler")
public final class RegExResponseHandler
extends ResponseHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.generic.RegExResponseHandler");
    private static final String ID_PLACEHOLDER = "{id}";
    private static final String SUMMARY_PLACEHOLDER = "{summary}";
    private String myTaskRegex = "";

    public RegExResponseHandler() {
    }

    public RegExResponseHandler(GenericRepository repository) {
        super(repository);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegExResponseHandler handler = (RegExResponseHandler)o;
        return this.myTaskRegex.equals(handler.myTaskRegex);
    }

    public int hashCode() {
        return this.myTaskRegex.hashCode();
    }

    @Override
    @NotNull
    public JComponent getConfigurationComponent(@NotNull Project project) {
        if (project == null) {
            RegExResponseHandler.$$$reportNull$$$0(0);
        }
        FormBuilder builder = FormBuilder.createFormBuilder();
        LanguageTextField taskPatternText = new LanguageTextField((Language)RegExpLanguage.INSTANCE, project, this.myTaskRegex, false);
        taskPatternText.addDocumentListener(new DocumentListener((EditorTextField)taskPatternText){
            final /* synthetic */ EditorTextField val$taskPatternText;
            {
                this.val$taskPatternText = editorTextField;
            }

            public void documentChanged(DocumentEvent e) {
                RegExResponseHandler.this.myTaskRegex = this.val$taskPatternText.getText();
            }
        });
        String tooltip = "<html>Task pattern should be a regexp with two matching groups: ({id}.+?) and ({summary}.+?)";
        builder.addLabeledComponent("Task Pattern:", (JComponent)new JBScrollPane((Component)taskPatternText)).addTooltip(tooltip);
        JPanel jPanel = builder.getPanel();
        if (jPanel == null) {
            RegExResponseHandler.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public Task[] parseIssues(@NotNull String response, int max) throws Exception {
        List<String> placeholders;
        if (response == null) {
            RegExResponseHandler.$$$reportNull$$$0(2);
        }
        if (!(placeholders = RegExResponseHandler.getPlaceholders(this.myTaskRegex)).contains(ID_PLACEHOLDER) || !placeholders.contains(SUMMARY_PLACEHOLDER)) {
            throw new Exception("Incorrect Task Pattern");
        }
        String taskPatternWithoutPlaceholders = this.myTaskRegex.replaceAll("\\{.+?\\}", "");
        Matcher matcher = Pattern.compile(taskPatternWithoutPlaceholders, 234).matcher(response);
        ArrayList<GenericTask> tasks = new ArrayList<GenericTask>();
        for (int i = 0; i < max && matcher.find(); ++i) {
            String id = matcher.group(placeholders.indexOf(ID_PLACEHOLDER) + 1);
            String summary = matcher.group(placeholders.indexOf(SUMMARY_PLACEHOLDER) + 1);
            tasks.add(new GenericTask(id, summary, (TaskRepository)this.myRepository));
        }
        Task[] taskArray = tasks.toArray(new Task[tasks.size()]);
        if (taskArray == null) {
            RegExResponseHandler.$$$reportNull$$$0(3);
        }
        return taskArray;
    }

    @Override
    @Nullable
    public Task parseIssue(@NotNull String response) throws Exception {
        if (response == null) {
            RegExResponseHandler.$$$reportNull$$$0(4);
        }
        return null;
    }

    private static List<String> getPlaceholders(String value) {
        if (value == null) {
            return ContainerUtil.emptyList();
        }
        ArrayList<String> vars = new ArrayList<String>();
        Matcher m = Pattern.compile("\\{(.+?)\\}").matcher(value);
        while (m.find()) {
            vars.add(m.group(0));
        }
        return vars;
    }

    public String getTaskRegex() {
        return this.myTaskRegex;
    }

    public void setTaskRegex(String taskRegex) {
        this.myTaskRegex = taskRegex;
    }

    @Override
    public boolean isConfigured() {
        return !StringUtil.isEmpty((String)this.myTaskRegex);
    }

    @Override
    @NotNull
    public ResponseType getResponseType() {
        ResponseType responseType = ResponseType.TEXT;
        if (responseType == null) {
            RegExResponseHandler.$$$reportNull$$$0(5);
        }
        return responseType;
    }

    @Override
    public RegExResponseHandler clone() {
        RegExResponseHandler clone = (RegExResponseHandler)super.clone();
        clone.myTaskRegex = this.myTaskRegex;
        return clone;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/generic/RegExResponseHandler";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/generic/RegExResponseHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIssues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationComponent";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseIssues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

