/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;

final class ScrollSettings {
    private static final RegistryValue PIXEL_PERFECT_SCROLLING = Registry.get((String)"idea.true.smooth.scrolling.pixel.perfect");
    private static final RegistryValue HIGH_PRECISION_SCROLLING = Registry.get((String)"idea.true.smooth.scrolling.high.precision");
    private static final RegistryValue DEBUG_ENABLED = Registry.get((String)"idea.true.smooth.scrolling.debug");
    private static final RegistryValue BACKGROUND_FROM_VIEW = Registry.get((String)"ide.scroll.background.auto");
    private static final RegistryValue HEADER_OVER_CORNER = Registry.get((String)"ide.scroll.layout.header.over.corner");
    private static final RegistryValue GAP_NEEDED_FOR_ANY_COMPONENT = Registry.get((String)"ide.scroll.align.component");
    private static final RegistryValue HORIZONTAL_GAP_NEEDED_ON_MAC = Registry.get((String)"mac.scroll.horizontal.gap");
    private static final RegistryValue THUMB_SMALL_IF_OPAQUE = Registry.get((String)"ide.scroll.thumb.small.if.opaque");

    ScrollSettings() {
    }

    static boolean isEligibleFor(Component component) {
        if (component == null || !component.isShowing()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return false;
        }
        if (PowerSaveMode.isEnabled()) {
            return false;
        }
        if (RemoteDesktopService.isRemoteSession()) {
            return false;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getSmoothScrolling();
    }

    static boolean isHighPrecisionEnabled() {
        return HIGH_PRECISION_SCROLLING.asBoolean();
    }

    static boolean isPixelPerfectEnabled() {
        return PIXEL_PERFECT_SCROLLING.asBoolean();
    }

    static boolean isDebugEnabled() {
        return DEBUG_ENABLED.asBoolean();
    }

    static boolean isBackgroundFromView() {
        return BACKGROUND_FROM_VIEW.asBoolean();
    }

    static boolean isHeaderOverCorner(JViewport viewport) {
        Component view = viewport == null ? null : viewport.getView();
        return !ScrollSettings.isNotSupportedYet(view) && HEADER_OVER_CORNER.asBoolean();
    }

    static boolean isNotSupportedYet(Component view) {
        return view instanceof JTable;
    }

    static boolean isGapNeededForAnyComponent() {
        return GAP_NEEDED_FOR_ANY_COMPONENT.asBoolean();
    }

    static boolean isHorizontalGapNeededOnMac() {
        return HORIZONTAL_GAP_NEEDED_ON_MAC.asBoolean();
    }

    static boolean isThumbSmallIfOpaque() {
        return THUMB_SMALL_IF_OPAQUE.asBoolean();
    }

    static boolean isInterpolationEligibleFor(JScrollBar scrollbar) {
        String name;
        Component[] subComponents;
        Window window = (Window)scrollbar.getTopLevelAncestor();
        if (window instanceof JDialog && "Commit Changes".equals(((JDialog)window).getTitle())) {
            return false;
        }
        if (!(window instanceof RootPaneContainer)) {
            return true;
        }
        Component[] components = ((RootPaneContainer)((Object)window)).getContentPane().getComponents();
        if (components.length == 1 && components[0].getClass().getName().contains("DiffWindow")) {
            return false;
        }
        return components.length != 2 || !(components[0] instanceof Container) || (subComponents = ((Container)components[0]).getComponents()).length != 1 || !(name = subComponents[0].getClass().getName()).contains("DiffWindow") && !name.contains("MergeWindow");
    }
}

