/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messager;

import com.intellij.ui.DrawUtil;
import com.intellij.ui.LineEndDecorator;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.geom.Line2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class CalloutComponent {
    private static final int POINTER_LENGTH = 20;
    private final JDialog myFrame;
    private final JComponent myInnerComponent;
    private ComponentListener myComponentListener;
    private WindowListener myWindowListener;
    private WindowStateListener myWindowStateListener;
    private AWTEventListener myMulticastListener;
    private KeyEventDispatcher myKeyEventDispatcher;
    protected JComponent myTargetComponent;
    protected Window myTargetWindow;
    protected Pointer myPointerComponent;
    private final KeyboardFocusManager myKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

    public CalloutComponent(JComponent component) {
        this.myInnerComponent = component;
        this.myInnerComponent.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.myFrame = new JDialog();
        this.myFrame.setUndecorated(true);
        this.myFrame.setFocusable(false);
        this.myFrame.setDefaultCloseOperation(0);
        this.myFrame.setFocusableWindowState(false);
        this.myFrame.getContentPane().setLayout(new BorderLayout());
        this.myFrame.getContentPane().add((Component)new Wrapper(this.myInnerComponent), "Center");
    }

    public void show(int location, RelativePoint target) {
        this.myFrame.pack();
        Dimension frameSize = this.myFrame.getPreferredSize();
        Point targetScreenPoint = target.getScreenPoint();
        Point framePoint = new Point();
        switch (location) {
            case 1: {
                framePoint.x = targetScreenPoint.x - frameSize.width - this.getPointerShift();
                framePoint.y = targetScreenPoint.y - frameSize.height - this.getPointerShift();
                break;
            }
            case 2: {
                framePoint.x = targetScreenPoint.x + this.getPointerShift();
                framePoint.y = targetScreenPoint.y - frameSize.height - this.getPointerShift();
                break;
            }
            case 4: {
                framePoint.x = targetScreenPoint.x + this.getPointerShift();
                framePoint.y = targetScreenPoint.y + this.getPointerShift();
                break;
            }
            case 3: {
                framePoint.x = targetScreenPoint.x - frameSize.width - this.getPointerShift();
                framePoint.y = targetScreenPoint.y + this.getPointerShift();
            }
        }
        this.myPointerComponent = new Pointer(location);
        Rectangle frameBounds = new Rectangle(framePoint, frameSize);
        ScreenUtil.moveRectangleToFitTheScreen(frameBounds);
        this.myTargetComponent = (JComponent)target.getComponent();
        this.myTargetWindow = SwingUtilities.getWindowAncestor(this.myTargetComponent);
        JLayeredPane layered = this.getLayeredPane(this.myTargetWindow);
        Rectangle layeredBounds = new RelativeRectangle((JComponent)layered).getScreenRectangle();
        boolean[] outside = this.getOutsideAxisCodes(layeredBounds, frameBounds);
        if (outside != null) {
            boolean x = outside[0];
            boolean y = outside[1];
            switch (location) {
                case 1: {
                    if (x) {
                        frameBounds.x = layeredBounds.x - frameBounds.width;
                    }
                    if (!y) break;
                    frameBounds.y = layeredBounds.y - frameBounds.height;
                    break;
                }
                case 2: {
                    if (x) {
                        frameBounds.x = (int)layeredBounds.getMaxX();
                    }
                    if (!y) break;
                    frameBounds.y = layeredBounds.y - frameBounds.height;
                    break;
                }
                case 4: {
                    if (x) {
                        frameBounds.x = (int)layeredBounds.getMaxX();
                    }
                    if (!y) break;
                    frameBounds.y = (int)layeredBounds.getMaxY();
                    break;
                }
                case 3: {
                    if (x) {
                        frameBounds.x = layeredBounds.x - frameBounds.width;
                    }
                    if (!y) break;
                    frameBounds.y = (int)layeredBounds.getMaxY();
                }
            }
        }
        Point targetLayeredPoint = target.getPoint((Component)layered);
        Rectangle frameLayeredBounds = RelativeRectangle.fromScreen((JComponent)layered, (Rectangle)frameBounds).getRectangleOn((Component)layered);
        Rectangle pointerBounds = new Rectangle();
        boolean extraPoint = true;
        switch (location) {
            case 1: {
                pointerBounds.x = (int)frameLayeredBounds.getMaxX() - 1;
                pointerBounds.y = (int)frameLayeredBounds.getMaxY() - 1;
                pointerBounds.width = targetLayeredPoint.x - pointerBounds.x;
                pointerBounds.height = targetLayeredPoint.y - pointerBounds.y;
                break;
            }
            case 2: {
                pointerBounds.x = targetLayeredPoint.x;
                pointerBounds.y = (int)frameLayeredBounds.getMaxY() - 1;
                pointerBounds.width = frameLayeredBounds.x + 1 - targetLayeredPoint.x;
                pointerBounds.height = targetLayeredPoint.y - pointerBounds.y;
                break;
            }
            case 4: {
                pointerBounds.x = targetLayeredPoint.x;
                pointerBounds.y = targetLayeredPoint.y;
                pointerBounds.width = frameLayeredBounds.x + 1 - targetLayeredPoint.x;
                pointerBounds.height = (int)frameLayeredBounds.getMaxY() + 1 - targetLayeredPoint.y - frameLayeredBounds.height;
                break;
            }
            case 3: {
                pointerBounds.x = (int)frameLayeredBounds.getMaxX() - 1;
                pointerBounds.y = targetLayeredPoint.y;
                pointerBounds.width = targetLayeredPoint.x - pointerBounds.x;
                pointerBounds.height = frameLayeredBounds.y + 1 - targetLayeredPoint.y;
            }
        }
        layered.add((Component)this.myPointerComponent, JLayeredPane.POPUP_LAYER);
        this.myPointerComponent.setBounds(pointerBounds);
        this.myFrame.setBounds(frameBounds);
        this.myFrame.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            this.installDisposeListeners();
            this.myFrame.setVisible(true);
        });
    }

    private boolean[] getOutsideAxisCodes(Rectangle layeredBounds, Rectangle frameBounds) {
        boolean y;
        boolean x = frameBounds.getMaxX() < (double)layeredBounds.x || layeredBounds.getMaxX() < (double)frameBounds.x;
        boolean bl = y = frameBounds.getMaxY() < (double)layeredBounds.y || layeredBounds.getMaxY() < (double)frameBounds.y;
        if (x || y) {
            return new boolean[]{x, y};
        }
        return null;
    }

    private void installDisposeListeners() {
        this.myKeyEventDispatcher = e -> {
            this.dispose();
            return false;
        };
        this.myKeyboardFocusManager.addKeyEventDispatcher(this.myKeyEventDispatcher);
        this.myMulticastListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                switch (event.getID()) {
                    case 501: {
                        CalloutComponent.this.dispose();
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myMulticastListener, 16L);
        this.myComponentListener = new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                CalloutComponent.this.dispose();
            }
        };
        this.myWindowListener = new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                CalloutComponent.this.dispose();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                CalloutComponent.this.dispose();
            }
        };
        this.myTargetWindow.addWindowListener(this.myWindowListener);
        this.myWindowStateListener = new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                CalloutComponent.this.dispose();
            }
        };
        this.myTargetWindow.addWindowStateListener(this.myWindowStateListener);
    }

    private void dispose() {
        Runnable runnable = () -> {
            this.myFrame.dispose();
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myMulticastListener);
            this.myKeyboardFocusManager.removeKeyEventDispatcher(this.myKeyEventDispatcher);
            this.myTargetComponent.removeComponentListener(this.myComponentListener);
            this.myTargetWindow.removeWindowListener(this.myWindowListener);
            this.myTargetWindow.removeWindowStateListener(this.myWindowStateListener);
            Container parent = this.myPointerComponent.getParent();
            Rectangle bounds = this.myPointerComponent.getBounds();
            if (parent != null) {
                parent.remove(this.myPointerComponent);
                parent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private int getPointerShift() {
        return (int)Math.sqrt(200.0);
    }

    private Color getFillColor() {
        return UI.getColor("callout.background");
    }

    private Color getBoundsColor() {
        return UI.getColor("callout.frame.color");
    }

    private JLayeredPane getLayeredPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane().getLayeredPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane().getLayeredPane();
        }
        return null;
    }

    private class Pointer
    extends NonOpaquePanel {
        private final int myOrientation;

        public Pointer(int orientation) {
            this.myOrientation = orientation;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Object old = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(CalloutComponent.this.getBoundsColor());
            Line2D.Double line = new Line2D.Double();
            switch (this.myOrientation) {
                case 1: {
                    ((Line2D)line).setLine(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1);
                    break;
                }
                case 2: {
                    ((Line2D)line).setLine(this.getWidth() - 1, 0.0, 0.0, this.getHeight() - 1);
                    break;
                }
                case 4: {
                    ((Line2D)line).setLine(this.getWidth() - 1, this.getHeight() - 1, 0.0, 0.0);
                    break;
                }
                case 3: {
                    ((Line2D)line).setLine(0.0, this.getHeight() - 1, this.getWidth() - 1, 0.0);
                }
            }
            UIUtil.drawLine((Graphics)g2, (int)((int)((Line2D)line).getX1()), (int)((int)((Line2D)line).getY1()), (int)((int)((Line2D)line).getX2()), (int)((int)((Line2D)line).getY2()));
            Shape arrow = LineEndDecorator.getArrowShape(line, ((Line2D)line).getP2());
            g2.fill(arrow);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }
    }

    private class Wrapper
    extends NonOpaquePanel {
        public Wrapper(JComponent component) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
            this.setLayout(new BorderLayout());
            this.add((Component)component, "Center");
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Object old = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(CalloutComponent.this.getFillColor());
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            DrawUtil.drawRoundRect(g, 0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, CalloutComponent.this.getBoundsColor());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }
    }
}

