/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMergeChange
extends ThreesideDiffChangeBase {
    private static final String CTRL_CLICK_TO_RESOLVE = "Ctrl+click to resolve conflict";
    @NotNull
    private final TextMergeViewer myMergeViewer;
    @NotNull
    private final TextMergeViewer.MyThreesideViewer myViewer;
    @NotNull
    private final List<MyGutterOperation> myOperations;
    private final int myIndex;
    @NotNull
    private final MergeLineFragment myFragment;
    private final boolean[] myResolved;
    private boolean myOnesideAppliedConflict;
    @Nullable
    private MergeInnerDifferences myInnerFragments;

    public TextMergeChange(int index, @NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @NotNull TextMergeViewer viewer) {
        if (fragment == null) {
            TextMergeChange.$$$reportNull$$$0(0);
        }
        if (conflictType == null) {
            TextMergeChange.$$$reportNull$$$0(1);
        }
        if (viewer == null) {
            TextMergeChange.$$$reportNull$$$0(2);
        }
        super(conflictType);
        this.myOperations = new ArrayList<MyGutterOperation>();
        this.myResolved = new boolean[2];
        this.myMergeViewer = viewer;
        this.myViewer = viewer.getViewer();
        this.myIndex = index;
        this.myFragment = fragment;
        this.reinstallHighlighters();
    }

    public void destroy() {
        this.destroyHighlighters();
        this.destroyOperations();
        this.destroyInnerHighlighters();
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyOperations();
        this.installOperations();
        this.myViewer.repaintDividers();
    }

    public int getIndex() {
        return this.myIndex;
    }

    void setResolved(@NotNull Side side, boolean value) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(3);
        }
        this.myResolved[side.getIndex()] = value;
        if (this.isResolved()) {
            this.destroyInnerHighlighters();
        } else {
            DocumentEx document = this.myViewer.getEditor((ThreeSide)side.select((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT)).getDocument();
            for (RangeHighlighter highlighter : this.myInnerHighlighters) {
                if (!document.equals(highlighter.getDocument())) continue;
                highlighter.dispose();
            }
        }
    }

    public boolean isResolved() {
        return this.myResolved[0] && this.myResolved[1];
    }

    public boolean isResolved(@NotNull Side side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(4);
        }
        return side.select(this.myResolved);
    }

    public boolean isOnesideAppliedConflict() {
        return this.myOnesideAppliedConflict;
    }

    public void markOnesideAppliedConflict() {
        this.myOnesideAppliedConflict = true;
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(5);
        }
        switch (side) {
            case LEFT: {
                return this.isResolved(Side.LEFT);
            }
            case BASE: {
                return this.isResolved();
            }
            case RIGHT: {
                return this.isResolved(Side.RIGHT);
            }
        }
        throw new IllegalArgumentException(side.toString());
    }

    public int getStartLine() {
        return this.myViewer.getModel().getLineStart(this.myIndex);
    }

    public int getEndLine() {
        return this.myViewer.getModel().getLineEnd(this.myIndex);
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(6);
        }
        if (side == ThreeSide.BASE) {
            return this.getStartLine();
        }
        return this.myFragment.getStartLine(side);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(7);
        }
        if (side == ThreeSide.BASE) {
            return this.getEndLine();
        }
        return this.myFragment.getEndLine(side);
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(8);
        }
        EditorEx editorEx = this.myViewer.getEditor(side);
        if (editorEx == null) {
            TextMergeChange.$$$reportNull$$$0(9);
        }
        return editorEx;
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    @NotNull
    public MergeLineFragment getFragment() {
        MergeLineFragment mergeLineFragment = this.myFragment;
        if (mergeLineFragment == null) {
            TextMergeChange.$$$reportNull$$$0(10);
        }
        return mergeLineFragment;
    }

    public void setInnerFragments(@Nullable MergeInnerDifferences innerFragments) {
        if (this.myInnerFragments == null && innerFragments == null) {
            return;
        }
        this.myInnerFragments = innerFragments;
        this.reinstallHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    private void installOperations() {
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.BASE, OperationType.RESOLVE));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.LEFT, OperationType.APPLY));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.LEFT, OperationType.IGNORE));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.RIGHT, OperationType.APPLY));
        ContainerUtil.addIfNotNull(this.myOperations, (Object)this.createOperation(ThreeSide.RIGHT, OperationType.IGNORE));
    }

    private void destroyOperations() {
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    @Nullable
    private MyGutterOperation createOperation(@NotNull ThreeSide side, @NotNull OperationType type) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(11);
        }
        if (type == null) {
            TextMergeChange.$$$reportNull$$$0(12);
        }
        if (this.isResolved(side)) {
            return null;
        }
        EditorEx editor = this.myViewer.getEditor(side);
        DocumentEx document = editor.getDocument();
        int line = this.getStartLine(side);
        int offset = line == DiffUtil.getLineCount(document) ? document.getTextLength() : document.getLineStartOffset(line);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        return new MyGutterOperation(side, highlighter, type);
    }

    public void updateGutterActions(boolean force) {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(13);
        }
        if (this.isResolved(side)) {
            return null;
        }
        Icon icon = this.isOnesideAppliedConflict() ? DiffUtil.getArrowDownIcon(side) : DiffUtil.getArrowIcon(side);
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), icon, this.isConflict(), () -> {
            if (side == null) {
                TextMergeChange.$$$reportNull$$$0(23);
            }
            this.myViewer.executeMergeCommand("Accept change", Collections.singletonList(this), () -> {
                if (side == null) {
                    TextMergeChange.$$$reportNull$$$0(24);
                }
                this.myViewer.replaceChange(this, side, modifier);
            });
        });
    }

    @Nullable
    private GutterIconRenderer createIgnoreRenderer(@NotNull Side side, boolean modifier) {
        if (side == null) {
            TextMergeChange.$$$reportNull$$$0(14);
        }
        if (this.isResolved(side)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), AllIcons.Diff.Remove, this.isConflict(), () -> {
            if (side == null) {
                TextMergeChange.$$$reportNull$$$0(21);
            }
            this.myViewer.executeMergeCommand("Ignore change", Collections.singletonList(this), () -> {
                if (side == null) {
                    TextMergeChange.$$$reportNull$$$0(22);
                }
                this.myViewer.ignoreChange(this, side, modifier);
            });
        });
    }

    @Nullable
    private GutterIconRenderer createResolveRenderer() {
        if (!this.isConflict() || !this.myViewer.canResolveChangeAutomatically(this, ThreeSide.BASE)) {
            return null;
        }
        return TextMergeChange.createIconRenderer(DiffBundle.message((String)"merge.dialog.resolve.change.action.name", (Object[])new Object[0]), AllIcons.Diff.MagicResolve, false, () -> this.myViewer.executeMergeCommand("Resolve conflict", Collections.singletonList(this), () -> this.myViewer.resolveChangeAutomatically(this, ThreeSide.BASE)));
    }

    @NotNull
    private static GutterIconRenderer createIconRenderer(@NotNull String text, @NotNull Icon icon, boolean ctrlClickVisible, final @NotNull Runnable perform2) {
        if (text == null) {
            TextMergeChange.$$$reportNull$$$0(15);
        }
        if (icon == null) {
            TextMergeChange.$$$reportNull$$$0(16);
        }
        if (perform2 == null) {
            TextMergeChange.$$$reportNull$$$0(17);
        }
        String tooltipText = DiffUtil.createTooltipText(text, ctrlClickVisible ? CTRL_CLICK_TO_RESOLVE : null);
        DiffGutterRenderer diffGutterRenderer = new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void performAction(AnActionEvent e) {
                perform2.run();
            }
        };
        if (diffGutterRenderer == null) {
            TextMergeChange.$$$reportNull$$$0(18);
        }
        return diffGutterRenderer;
    }

    @NotNull
    State storeState() {
        State state2 = new State(this.myIndex, this.getStartLine(), this.getEndLine(), this.myResolved[0], this.myResolved[1], this.myOnesideAppliedConflict);
        if (state2 == null) {
            TextMergeChange.$$$reportNull$$$0(19);
        }
        return state2;
    }

    void restoreState(@NotNull State state2) {
        if (state2 == null) {
            TextMergeChange.$$$reportNull$$$0(20);
        }
        this.myResolved[0] = state2.myResolved1;
        this.myResolved[1] = state2.myResolved2;
        this.myOnesideAppliedConflict = state2.myOnesideAppliedConflict;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/TextMergeChange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/TextMergeChange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragment";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconRenderer";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "storeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setResolved";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createApplyRenderer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createIgnoreRenderer";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createIgnoreRenderer$3";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createApplyRenderer$1";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State
    extends MergeModelBase.State {
        private final boolean myResolved1;
        private final boolean myResolved2;
        private final boolean myOnesideAppliedConflict;

        public State(int index, int startLine, int endLine, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict) {
            super(index, startLine, endLine);
            this.myResolved1 = resolved1;
            this.myResolved2 = resolved2;
            this.myOnesideAppliedConflict = onesideAppliedConflict;
        }
    }

    private static enum OperationType {
        APPLY,
        IGNORE,
        RESOLVE;

    }

    private class MyGutterOperation {
        @NotNull
        private final ThreeSide mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;
        @NotNull
        private final OperationType myType;
        private boolean myCtrlPressed;
        private boolean myShiftPressed;

        private MyGutterOperation(@NotNull ThreeSide side, @NotNull RangeHighlighter highlighter, OperationType type) {
            if (side == null) {
                MyGutterOperation.$$$reportNull$$$0(0);
            }
            if (highlighter == null) {
                MyGutterOperation.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyGutterOperation.$$$reportNull$$$0(2);
            }
            this.mySide = side;
            this.myHighlighter = highlighter;
            this.myType = type;
            this.update(true);
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update(boolean force) {
            if (!force && !this.areModifiersChanged()) {
                return;
            }
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        private boolean areModifiersChanged() {
            return this.myCtrlPressed != TextMergeChange.this.myViewer.getModifierProvider().isCtrlPressed() || this.myShiftPressed != TextMergeChange.this.myViewer.getModifierProvider().isShiftPressed();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            this.myCtrlPressed = TextMergeChange.this.myViewer.getModifierProvider().isCtrlPressed();
            this.myShiftPressed = TextMergeChange.this.myViewer.getModifierProvider().isShiftPressed();
            if (this.mySide == ThreeSide.BASE) {
                switch (this.myType) {
                    case RESOLVE: {
                        if (!Registry.is((String)"diff.merge.resolve.conflict.action.visible")) {
                            return null;
                        }
                        return TextMergeChange.this.createResolveRenderer();
                    }
                }
                throw new IllegalArgumentException(this.myType.name());
            }
            Side versionSide = (Side)this.mySide.select((Object)Side.LEFT, null, (Object)Side.RIGHT);
            assert (versionSide != null);
            if (!TextMergeChange.this.isChange(versionSide)) {
                return null;
            }
            switch (this.myType) {
                case APPLY: {
                    return TextMergeChange.this.createApplyRenderer(versionSide, this.myCtrlPressed);
                }
                case IGNORE: {
                    return TextMergeChange.this.createIgnoreRenderer(versionSide, this.myCtrlPressed);
                }
            }
            throw new IllegalArgumentException(this.myType.name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "side";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlighter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/merge/TextMergeChange$MyGutterOperation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

