/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.diff.impl.external.ContentExternalizer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.Nullable;

class LocalFileExternalizer
implements ContentExternalizer {
    private final File myFile;

    public LocalFileExternalizer(File file2) {
        this.myFile = file2;
    }

    @Override
    public File getContentFile() {
        return this.myFile;
    }

    @Nullable
    public static LocalFileExternalizer tryCreate(VirtualFile file2) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        if (!file2.isInLocalFileSystem()) {
            return null;
        }
        return new LocalFileExternalizer(new File(file2.getPath().replace('/', File.separatorChar)));
    }

    static boolean canExternalizeAsFile(VirtualFile file2) {
        if (file2 == null || file2.isDirectory()) {
            return false;
        }
        FileType fileType = file2.getFileType();
        return !fileType.isBinary() || fileType == FileTypes.UNKNOWN;
    }
}

