/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdateInfoDialogAction
extends AnAction {
    private static final String PARAGRAPH = "    <li><strong>Refactoring to Java 8</strong>: more powerful inspections.</li>\n    <li><strong>JVM Debugger</strong>: Class-level Watches; the JVM Memory View plugin.</li>\n    <li><strong>User Interface</strong>: Parameter Hints; Semantic Highlighting; flat file icons.</li>\n    <li><strong>Build Tools</strong>: Delegate IDE build/run actions to Gradle; Composite <br>\n        Builds support; Polyglot Maven.</li>\n    <li><strong>Scala</strong>: scala.meta and Scala.js</li>\n    <li><strong>JavaScript</strong>: refactoring to ECMAScript 6; Flow-based inspections; <br>\n        React Native debugger, Protractor, Stylelint, PostCSS, and more.</li>\n    <li><strong>VCS</strong>: Faster and more ergonomic Log for Git/Mercurial; automatic <br>\n        resolving conflicts; managing Git remotes.</li>\n    <li><strong>Android</strong>: Blueprint; Constraint Layout, APK Analyzer, and better Instant Run.</li>\n    <li><strong>Database</strong>: editing multiple cells at once; submit changes in bulk; <br>\n        find usages of objects within the source code of other objects.</li>\n";
    private static final String CHANNEL_XML_START = "<!DOCTYPE products SYSTEM \"updates.dtd\">\n<channel id=\"IDEA_EAP\" name=\"IntelliJ IDEA EAP\" status=\"eap\"\n             url=\"https://confluence.jetbrains.com/display/IDEADEV/IDEA+2016.3+EAP\"\n             feedback=\"http://youtrack.jetbrains.net\"\n             majorVersion=\"2016\" licensing=\"eap\">\n      <build number=\"163.7743.44\" version=\"2016.3\" releaseDate=\"20161122\">\n        <message><![CDATA[\n        <p>Please meet IntelliJ IDEA 2016.3, the third update planned for 2016!</p>\n\n<p>Visit <a href=\"https://www.jetbrains.com/idea/whatsnew/?landing\">What's New</a> page for a full list of new features and an overview video.</p>\n\n<p>And here're the highlights:</p>\n\n<ul>\n";
    private static final String CHANNEL_XML_END = "</ul>\n]]></message>\n        <button name=\"Download\" url=\"https://www.jetbrains.com/idea/download/\" download=\"true\"/>\n        <button name=\"What's New\" url=\"https://www.jetbrains.com/idea/whatsnew/?landing\"/>\n        <patch from=\"163.7743.17\" size=\"from 2 to 18\"/>\n        <patch from=\"163.7743.37\" size=\"from 2 to 18\"/>\n      </build>\n      <build number=\"162.2228.15\" version=\"2016.2.5\" releaseDate=\"20160712\">\n        <message><![CDATA[\n        <p>The <strong>IntelliJ IDEA 2016.2.5</strong> update is available. <br>\n    Apart from bugfixes, the update brings support for <strong>macOS Sierra</strong>.</p>\n]]></message>\n        <button name=\"Download\" url=\"https://www.jetbrains.com/idea/download/\" download=\"true\"/>\n        <button name=\"Release Notes\" url=\"https://confluence.jetbrains.com/display/IDEADEV/IntelliJ+IDEA+2016.2.5+Release+Notes\"/>\n        <patch from=\"162.2032.8\" size=\"from 1 to 13\"/>\n        <patch from=\"162.2228.14\" size=\"from 21 to 53\"/>\n        <patch from=\"162.1812.17\" size=\"from 21 to 55\"/>\n        <patch from=\"162.1628.40\" size=\"from 21 to 59\"/>\n        <patch from=\"162.1447.26\" size=\"from 21 to 67\"/>\n        <patch from=\"162.1121.32\" size=\"from 33 to 80\"/>\n      </build>\n      <build number=\"162.1121.32\" version=\"2016.2\" releaseDate=\"20160712\">\n        <message><![CDATA[\n        <p>Welcome <strong>IntelliJ IDEA 2016.2</strong>, a second update planned for this year.<br>\n    The update brings lots of new features and improvements across the <br>\n    built-in tools, UI, and support for languages and frameworks.\n</p>\n\n<p>Learn more about the update by reading the <a href=\"http://blog.jetbrains.com/idea/2016/07/intellij-idea-2016-2-is-here/\">blog post</a>.</p>\n]]></message>\n        <button name=\"What's New\" url=\"https://www.jetbrains.com/idea/whatsnew/\"/>\n        <button name=\"Download\" url=\"https://www.jetbrains.com/idea/download/\" download=\"true\"/>\n        <patch from=\"162.1121.10\" size=\"from 1 to 12\"/>\n      </build>\n      <build number=\"145.2070\" version=\"2016.1.4\" releaseDate=\"20160316\">\n        <message><![CDATA[\n        <p>IntelliJ IDEA 2016.1.4 build 145.2070 is available with important bugfixes.</p>\n]]></message>\n        <button name=\"Release Notes\" url=\"https://confluence.jetbrains.com/display/IDEADEV/IntelliJ+IDEA+2016.1.4+Release+Notes\"/>\n        <button name=\"Download\" url=\"https://confluence.jetbrains.com/display/IntelliJIDEA/Previous+IntelliJ+IDEA+Releases\"\n                download=\"true\"/>\n        <patch from=\"145.1617\" size=\"from 42 to 58\"/>\n      </build>\n    </channel>\n";

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        String title = "Updates.xml <channel> Text";
        JBList list2 = new JBList(new Object[]{"Manual Text", "Sample Text (short)", "Sample Text (long)"});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setFilteringEnabled(o -> (String)o).setItemChoosenCallback(() -> {
            int index = list2.getSelectedIndex();
            Pair info = index == 0 ? ShowUpdateInfoDialogAction.getUserText(project, title) : Pair.create((Object)ShowUpdateInfoDialogAction.getXML(index == 2), null);
            this.showDialog((String)info.first, (VirtualFile)info.second);
        }).createPopup().showCenteredInCurrentWindow(project);
    }

    @NotNull
    private static Pair<String, VirtualFile> getUserText(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            ShowUpdateInfoDialogAction.$$$reportNull$$$0(0);
        }
        if (title == null) {
            ShowUpdateInfoDialogAction.$$$reportNull$$$0(1);
        }
        JTextArea textArea = new JTextArea(10, 50);
        UIUtil.addUndoRedoActions((JTextComponent)textArea);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        JPanel panel2 = new JPanel(new BorderLayout(0, 10));
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)textArea), "Center");
        Disposable disposable = Disposer.newDisposable();
        FileTextField fileField = FileChooserFactory.getInstance().createFileTextField(BrowseFilesListener.SINGLE_FILE_DESCRIPTOR, disposable);
        TextFieldWithBrowseButton fileCompo = new TextFieldWithBrowseButton(fileField.getField());
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        fileCompo.addBrowseFolderListener("Patch File", "Patch file", project, fileDescriptor);
        panel2.add((Component)LabeledComponent.create((JComponent)fileCompo, (String)"Patch file:"), "South");
        DialogBuilder builder = new DialogBuilder(project);
        builder.addDisposable(disposable);
        builder.setCenterPanel((JComponent)panel2);
        builder.setPreferredFocusComponent((JComponent)textArea);
        builder.setTitle(title);
        builder.addOkAction();
        builder.addCancelAction();
        Pair pair = builder.showAndGet() ? Pair.create((Object)textArea.getText(), (Object)fileField.getSelectedFile()) : Pair.empty();
        if (pair == null) {
            ShowUpdateInfoDialogAction.$$$reportNull$$$0(2);
        }
        return pair;
    }

    protected void showDialog(@Nullable String text, final @Nullable VirtualFile patchFile) {
        Element element;
        String trim = StringUtil.trim((String)text);
        if (StringUtil.isEmpty((String)trim)) {
            return;
        }
        try {
            element = JdomKt.loadElement((CharSequence)trim);
            if (!"channel".equals(element.getName())) {
                return;
            }
        }
        catch (Exception ex) {
            Logger.getInstance(ShowUpdateInfoDialogAction.class).error((Throwable)ex);
            return;
        }
        UpdateChannel channel = new UpdateChannel(element);
        BuildInfo newBuild = (BuildInfo)ContainerUtil.getFirstItem(channel.getBuilds());
        if (newBuild == null) {
            return;
        }
        PatchInfo patch = (PatchInfo)ContainerUtil.getFirstItem(newBuild.getPatches());
        UpdateInfoDialog dialog2 = new UpdateInfoDialog(channel, newBuild, patch, true, UpdateSettings.getInstance().canUseSecureConnection(), Collections.emptyList(), Collections.emptyList()){

            @Override
            @NotNull
            File doDownloadPatch(@NotNull ProgressIndicator indicator) throws IOException {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                File file2 = patchFile == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)patchFile);
                File file3 = file2 != null ? file2 : super.doDownloadPatch(indicator);
                if (file3 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/ShowUpdateInfoDialogAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/ShowUpdateInfoDialogAction$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doDownloadPatch";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doDownloadPatch";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        dialog2.setTitle("[TEST] " + dialog2.getTitle());
        dialog2.show();
    }

    private static String getXML(boolean bigData) {
        StringBuilder sb = new StringBuilder(CHANNEL_XML_START);
        int count = bigData ? 4 : 1;
        for (int i = 0; i < count; ++i) {
            sb.append(PARAGRAPH);
        }
        sb.append(CHANNEL_XML_END);
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/ShowUpdateInfoDialogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/ShowUpdateInfoDialogAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserText";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

