/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.actions.AnnotationsSettings;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsPreviewPanel
implements PreviewPanel {
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final EditorEx myEditor;

    public VcsPreviewPanel() {
        DocumentImpl document = new DocumentImpl("", true);
        this.myEditor = (EditorEx)EditorFactory.getInstance().createViewer((Document)document);
        this.myEditor.getGutterComponentEx().setForceShowRightFreePaintersArea(true);
        this.myEditor.getSettings().setFoldingOutlineShown(true);
    }

    @Override
    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void blinkSelectedHighlightType(Object selected) {
    }

    @Override
    public void updateView() {
        EditorColorsScheme colorsScheme = this.myEditor.getColorsScheme();
        StringBuilder sb = new StringBuilder();
        sb.append("Deleted line below\n\nModified line\n\nAdded line\n\nLine with modified whitespaces\n\nAdded line\nLine with modified whitespaces and deletion after\n");
        int additionalLines = Math.max(0, AnnotationsSettings.getInstance().getOrderedColors(colorsScheme).size() - StringUtil.countNewLines((CharSequence)sb));
        sb.append(StringUtil.repeat((String)"\n", (int)additionalLines));
        this.myEditor.getDocument().setText(sb);
        this.myEditor.getMarkupModel().removeAllHighlighters();
        this.myEditor.getGutterComponentEx().closeAllAnnotations();
        this.addHighlighter(new Range(1, 1, 0, 1), EditorColors.DELETED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(2, 1), EditorColors.MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(4, 2), EditorColors.ADDED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(6, 0), EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        this.addHighlighter(VcsPreviewPanel.createModifiedRange(8, 2, 0, 3), EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        List<Color> annotationColors = AnnotationsSettings.getInstance().getOrderedColors(colorsScheme);
        List<Integer> anchorIndexes = AnnotationsSettings.getInstance().getAnchorIndexes(colorsScheme);
        this.myEditor.getGutterComponentEx().registerTextAnnotation(new MyTextAnnotationGutterProvider(annotationColors, anchorIndexes));
    }

    @NotNull
    private static Range createModifiedRange(int currentLine, byte ... inner) {
        ArrayList<Range.InnerRange> innerRanges = new ArrayList<Range.InnerRange>();
        int currentInnerLine = currentLine;
        block4: for (byte type : inner) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine + 1, type));
                    ++currentInnerLine;
                    continue block4;
                }
                case 3: {
                    innerRanges.add(new Range.InnerRange(currentInnerLine, currentInnerLine, type));
                }
            }
        }
        Range range = new Range(currentLine, currentInnerLine, 0, 1, innerRanges);
        if (range == null) {
            VcsPreviewPanel.$$$reportNull$$$0(0);
        }
        return range;
    }

    private void addHighlighter(@NotNull Range range, final @NotNull ColorKey colorKey) {
        if (range == null) {
            VcsPreviewPanel.$$$reportNull$$$0(1);
        }
        if (colorKey == null) {
            VcsPreviewPanel.$$$reportNull$$$0(2);
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myEditor.getDocument(), range.getLine1(), range.getLine2());
        RangeHighlighter highlighter = LineStatusMarkerRenderer.createRangeHighlighter(range, textRange, this.myEditor.getMarkupModel());
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new LineStatusMarkerRenderer(range){

            @Override
            public boolean canDoAction(MouseEvent e) {
                return 1.isInsideMarkerArea(e);
            }

            @Override
            public void doAction(Editor editor, MouseEvent e) {
                ((ColorAndFontSettingsListener)VcsPreviewPanel.this.myDispatcher.getMulticaster()).selectionInPreviewChanged(colorKey.getExternalName());
            }
        });
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            VcsPreviewPanel.$$$reportNull$$$0(3);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void setColorScheme(EditorColorsScheme highlighterSettings) {
        this.myEditor.setColorsScheme(highlighterSettings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsPreviewPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createModifiedRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsPreviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTextAnnotationGutterProvider
    implements TextAnnotationGutterProvider {
        @NotNull
        private final List<Color> myBackgroundColors;
        @NotNull
        private final List<Integer> myAnchorIndexes;

        public MyTextAnnotationGutterProvider(@NotNull List<Color> backgroundColors, @NotNull List<Integer> anchorIndexes) {
            if (backgroundColors == null) {
                MyTextAnnotationGutterProvider.$$$reportNull$$$0(0);
            }
            if (anchorIndexes == null) {
                MyTextAnnotationGutterProvider.$$$reportNull$$$0(1);
            }
            this.myBackgroundColors = backgroundColors;
            this.myAnchorIndexes = anchorIndexes;
        }

        @Nullable
        public String getLineText(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                int anchorIndex = this.myAnchorIndexes.indexOf(line);
                String text = "Annotation background";
                if (anchorIndex != -1) {
                    text = text + " #" + (anchorIndex + 1);
                }
                return text;
            }
            return null;
        }

        @Nullable
        public String getToolTip(int line, Editor editor) {
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            return null;
        }

        @Nullable
        public ColorKey getColor(int line, Editor editor) {
            return EditorColors.ANNOTATIONS_COLOR;
        }

        @Nullable
        public Color getBgColor(int line, Editor editor) {
            if (line < this.myBackgroundColors.size()) {
                return this.myBackgroundColors.get(line);
            }
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "backgroundColors";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchorIndexes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/VcsPreviewPanel$MyTextAnnotationGutterProvider";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

