/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import org.jetbrains.annotations.NotNull;

public class PermanentListIntToIntMap
extends AbstractIntToIntMap
implements IntToIntMap {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    @NotNull
    private final Flags myVisibleIndexes;
    private final int myLongSize;
    private final int myShortSize;
    private final int myBlockSize;
    @NotNull
    private final int[] myStrongShortIndexes;

    @NotNull
    public static IntToIntMap newInstance(@NotNull Flags visibleIndexes, int shortSize) {
        if (visibleIndexes == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(0);
        }
        IntToIntMap intToIntMap = PermanentListIntToIntMap.newInstance(visibleIndexes, shortSize, 30);
        if (intToIntMap == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(1);
        }
        return intToIntMap;
    }

    @NotNull
    public static IntToIntMap newInstance(@NotNull Flags visibleIndexes, int shortSize, int blockSize) {
        if (visibleIndexes == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(2);
        }
        if (shortSize < 0) {
            throw new NegativeArraySizeException("shortSize < 0: " + shortSize);
        }
        if (shortSize == 0) {
            IntToIntMap intToIntMap = PermanentListIntToIntMap.createEmptyIntToIntMap(visibleIndexes);
            if (intToIntMap == null) {
                PermanentListIntToIntMap.$$$reportNull$$$0(3);
            }
            return intToIntMap;
        }
        int[] strongShortIndexes = new int[(shortSize - 1) / blockSize + 1];
        int currentShortIndex = -1;
        for (int longIndex = 0; longIndex < visibleIndexes.size(); ++longIndex) {
            if (!visibleIndexes.get(longIndex) || ++currentShortIndex % blockSize != 0) continue;
            strongShortIndexes[currentShortIndex / blockSize] = longIndex;
        }
        PermanentListIntToIntMap permanentListIntToIntMap = new PermanentListIntToIntMap(visibleIndexes, shortSize, blockSize, strongShortIndexes);
        if (permanentListIntToIntMap == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(4);
        }
        return permanentListIntToIntMap;
    }

    @NotNull
    private static IntToIntMap createEmptyIntToIntMap(final @NotNull Flags visibleIndexes) {
        if (visibleIndexes == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(5);
        }
        IntToIntMap intToIntMap = new IntToIntMap(){

            @Override
            public int shortSize() {
                return 0;
            }

            @Override
            public int longSize() {
                return visibleIndexes.size();
            }

            @Override
            public int getLongIndex(int shortIndex) {
                return 0;
            }

            @Override
            public int getShortIndex(int longIndex) {
                return 0;
            }
        };
        if (intToIntMap == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(6);
        }
        return intToIntMap;
    }

    private PermanentListIntToIntMap(@NotNull Flags visibleIndexes, int shortSize, int blockSize, @NotNull int[] strongShortIndexes) {
        if (visibleIndexes == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(7);
        }
        if (strongShortIndexes == null) {
            PermanentListIntToIntMap.$$$reportNull$$$0(8);
        }
        this.myVisibleIndexes = visibleIndexes;
        this.myLongSize = visibleIndexes.size();
        this.myShortSize = shortSize;
        this.myBlockSize = blockSize;
        this.myStrongShortIndexes = strongShortIndexes;
    }

    @Override
    public int shortSize() {
        return this.myShortSize;
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int strongIndex = shortIndex / this.myBlockSize;
        int sub = shortIndex - strongIndex * this.myBlockSize;
        for (int longIndex = this.myStrongShortIndexes[strongIndex]; longIndex < this.myLongSize; ++longIndex) {
            if (this.myVisibleIndexes.get(longIndex)) {
                --sub;
            }
            if (sub != -1) continue;
            return longIndex;
        }
        throw new IllegalStateException("Not found long index for short index: " + shortIndex + ". Long & short size is: " + this.myLongSize + ", " + this.myShortSize + ".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleIndexes";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strongShortIndexes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIntToIntMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyIntToIntMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

