/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyIndexPatternBuilder;
import com.jetbrains.python.PyTokenTypes;

public class PyFilterLexer
extends BaseFilterLexer {
    private static final TokenSet ourSkipWordsScanSet = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, PyTokenTypes.LPAR, PyTokenTypes.RPAR, PyTokenTypes.LBRACE, PyTokenTypes.RBRACE, PyTokenTypes.LBRACKET, PyTokenTypes.RBRACKET, PyTokenTypes.SEMICOLON, PyTokenTypes.COMMA, PyTokenTypes.DOT, PyTokenTypes.AT}), PyTokenTypes.OPERATIONS});

    protected PyFilterLexer(Lexer originalLexer, OccurrenceConsumer occurrenceConsumer) {
        super(originalLexer, occurrenceConsumer);
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (tokenType == PyTokenTypes.IDENTIFIER || PyTokenTypes.SCALAR_LITERALS.contains(tokenType)) {
            this.addOccurrenceInToken(1);
        } else if (PyTokenTypes.STRING_NODES.contains(tokenType)) {
            this.scanWordsInToken(12, false, true);
            if (tokenType == PyTokenTypes.DOCSTRING) {
                this.advanceTodoItemCountsInToken();
            }
        } else if (PyIndexPatternBuilder.COMMENTS.contains(tokenType)) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        } else if (!ourSkipWordsScanSet.contains(tokenType)) {
            this.scanWordsInToken(16, false, false);
        }
        this.myDelegate.advance();
    }
}

