/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyBaseDocstringInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.quickfix.DocstringQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class PyMissingOrEmptyDocstringInspection
extends PyBaseDocstringInspection {
    @Override
    @NotNull
    public PyBaseDocstringInspection.Visitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(1);
        }
        PyBaseDocstringInspection.Visitor visitor2 = new PyBaseDocstringInspection.Visitor(holder, session2){

            @Override
            protected void checkDocString(@NotNull PyDocStringOwner node) {
                PyStringLiteralExpression docStringExpression;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((docStringExpression = node.getDocStringExpression()) == null) {
                    for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                        if (!extension.ignoreMissingDocstring(node)) continue;
                        return;
                    }
                    Object marker = null;
                    if (node instanceof PyClass) {
                        ASTNode n = ((PyClass)node).getNameNode();
                        if (n != null) {
                            marker = n.getPsi();
                        }
                    } else if (node instanceof PyFunction) {
                        ASTNode n = ((PyFunction)node).getNameNode();
                        if (n != null) {
                            marker = n.getPsi();
                        }
                    } else if (node instanceof PyFile) {
                        TextRange tr = new TextRange(0, 0);
                        ProblemsHolder holder = this.getHolder();
                        if (holder != null) {
                            holder.registerProblem((PsiElement)node, tr, PyBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[0]);
                        }
                        return;
                    }
                    if (marker == null) {
                        marker = node;
                    }
                    if (node instanceof PyFunction || node instanceof PyClass && ((PyClass)node).findInitOrNew(false, null) != null) {
                        this.registerProblem((PsiElement)marker, PyBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[]{new DocstringQuickFix(null, null)});
                    } else {
                        this.registerProblem((PsiElement)marker, PyBundle.message("INSP.no.docstring", new Object[0]));
                    }
                } else if (StringUtil.isEmptyOrSpaces((String)docStringExpression.getStringValue())) {
                    this.registerProblem(docStringExpression, PyBundle.message("INSP.empty.docstring", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyMissingOrEmptyDocstringInspection$1", "checkDocString"));
            }
        };
        if (visitor2 == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(2);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMissingOrEmptyDocstringInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMissingOrEmptyDocstringInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

