/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeChecker {
    private PyTypeChecker() {
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(0);
        }
        return PyTypeChecker.match(expected, actual, context, null, true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @Nullable Map<PyGenericType, PyType> substitutions) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(1);
        }
        return PyTypeChecker.match(expected, actual, context, substitutions, true);
    }

    private static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @Nullable Map<PyGenericType, PyType> substitutions, boolean recursive) {
        Set<String> expectedAttributes;
        PyClass superClass;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(2);
        }
        PyClassType expectedClassType = PyUtil.as(expected, PyClassType.class);
        PyClassType actualClassType = PyUtil.as(actual, PyClassType.class);
        if (expectedClassType != null && ArrayUtil.contains((String)expectedClassType.getName(), (String[])new String[]{"object", "type"})) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)expectedClassType.getPyClass());
            if (expectedClassType.equals(builtinCache.getObjectType())) {
                return true;
            }
            if (expectedClassType.equals(builtinCache.getTypeType()) && actual instanceof PyInstantiableType && ((PyInstantiableType)actual).isDefinition()) {
                return true;
            }
        }
        if (expected instanceof PyInstantiableType && actual instanceof PyInstantiableType && (!(expected instanceof PyGenericType) || !PyTypeChecker.typeVarAcceptsBothClassAndInstanceTypes((PyGenericType)expected)) && ((PyInstantiableType)expected).isDefinition() ^ ((PyInstantiableType)actual).isDefinition()) {
            return ((PyInstantiableType)actual).isDefinition() && !((PyInstantiableType)expected).isDefinition() && actual instanceof PyClassLikeType && PyTypeChecker.matchClassObjectAndMetaclass(expected, (PyClassLikeType)actual, context);
        }
        if (expected instanceof PyGenericType && substitutions != null) {
            PyGenericType generic = (PyGenericType)expected;
            PyType subst = substitutions.get(generic);
            PyType bound = generic.getBound();
            if (generic.isDefinition() && bound instanceof PyInstantiableType) {
                bound = ((PyInstantiableType)bound).toClass();
            }
            if (!PyTypeChecker.match(bound, actual, context, substitutions, recursive)) {
                return false;
            }
            if (subst != null) {
                if (expected.equals(actual) || subst.equals(generic)) {
                    return true;
                }
                if (recursive) {
                    return PyTypeChecker.match(subst, actual, context, substitutions, false);
                }
                return false;
            }
            if (actual != null) {
                substitutions.put(generic, actual);
            } else if (bound != null) {
                substitutions.put(generic, bound);
            }
            return true;
        }
        if (expected == null || actual == null) {
            return true;
        }
        if (PyTypeChecker.isUnknown(actual, context)) {
            return true;
        }
        if (actual instanceof PyUnionType) {
            PyUnionType actualUnionType = (PyUnionType)actual;
            if (expected instanceof PyTupleType) {
                PyTupleType expectedTupleType = (PyTupleType)expected;
                int elementCount = expectedTupleType.getElementCount();
                if (!expectedTupleType.isHomogeneous() && PyTypeChecker.consistsOfSameElementNumberTuples(actualUnionType, elementCount)) {
                    return PyTypeChecker.substituteExpectedElementsWithUnions(expectedTupleType, elementCount, actualUnionType, context, substitutions, recursive);
                }
            }
            for (PyType m : actualUnionType.getMembers()) {
                if (!PyTypeChecker.match(expected, m, context, substitutions, recursive)) continue;
                return true;
            }
            return false;
        }
        if (expected instanceof PyUnionType) {
            Collection<PyType> expectedUnionTypeMembers = ((PyUnionType)expected).getMembers();
            StreamEx notGenericTypes = (StreamEx)StreamEx.of(expectedUnionTypeMembers).filter(type -> !PyGenericType.class.isInstance(type));
            StreamEx genericTypes = StreamEx.of(expectedUnionTypeMembers).select(PyGenericType.class);
            for (PyType t : (StreamEx)notGenericTypes.append((Stream)genericTypes)) {
                if (!PyTypeChecker.match(t, actual, context, substitutions, recursive)) continue;
                return true;
            }
            return false;
        }
        if (expectedClassType != null && actualClassType != null) {
            superClass = expectedClassType.getPyClass();
            PyClass subClass = actualClassType.getPyClass();
            if (expected instanceof PyTupleType && actual instanceof PyTupleType) {
                PyTupleType superTupleType = (PyTupleType)expected;
                PyTupleType subTupleType = (PyTupleType)actual;
                if (!superTupleType.isHomogeneous() && !subTupleType.isHomogeneous()) {
                    if (superTupleType.getElementCount() != subTupleType.getElementCount()) {
                        return false;
                    }
                    for (int i = 0; i < superTupleType.getElementCount(); ++i) {
                        if (PyTypeChecker.match(superTupleType.getElementType(i), subTupleType.getElementType(i), context, substitutions, recursive)) continue;
                        return false;
                    }
                    return true;
                }
                if (superTupleType.isHomogeneous() && !subTupleType.isHomogeneous()) {
                    PyType expectedElementType = superTupleType.getIteratedItemType();
                    for (int i = 0; i < subTupleType.getElementCount(); ++i) {
                        if (PyTypeChecker.match(expectedElementType, subTupleType.getElementType(i), context, substitutions, recursive)) continue;
                        return false;
                    }
                    return true;
                }
                if (!superTupleType.isHomogeneous() && subTupleType.isHomogeneous()) {
                    return false;
                }
                return PyTypeChecker.match(superTupleType.getIteratedItemType(), subTupleType.getIteratedItemType(), context, substitutions, recursive);
            }
            if (expected instanceof PyCollectionType && actual instanceof PyTupleType) {
                PyType subElementType;
                if (!PyTypeChecker.matchClasses(superClass, subClass, context)) {
                    return false;
                }
                PyType superElementType = ((PyCollectionType)expected).getIteratedItemType();
                return PyTypeChecker.match(superElementType, subElementType = ((PyTupleType)actual).getIteratedItemType(), context, substitutions, recursive);
            }
            if (expected instanceof PyCollectionType) {
                if (!PyTypeChecker.matchClasses(superClass, subClass, context)) {
                    return false;
                }
                List<PyType> superElementTypes = ((PyCollectionType)expected).getElementTypes();
                PyCollectionType actualCollectionType = PyUtil.as(actual, PyCollectionType.class);
                List<Object> subElementTypes = actualCollectionType != null ? actualCollectionType.getElementTypes() : Collections.emptyList();
                for (int i = 0; i < superElementTypes.size(); ++i) {
                    PyType subElementType;
                    PyType pyType = subElementType = i < subElementTypes.size() ? (PyType)subElementTypes.get(i) : null;
                    if (PyTypeChecker.match(superElementTypes.get(i), subElementType, context, substitutions, recursive)) continue;
                    return false;
                }
                return true;
            }
            if (PyTypeChecker.matchClasses(superClass, subClass, context)) {
                return true;
            }
            if (actualClassType.isDefinition() && "Callable".equals(expected.getName())) {
                return true;
            }
            if (expected.equals(actual)) {
                return true;
            }
        }
        if (actual instanceof PyFunctionTypeImpl && expectedClassType != null && "Callable".equals((superClass = expectedClassType.getPyClass()).getName())) {
            return true;
        }
        if (actual instanceof PyStructuralType && ((PyStructuralType)actual).isInferredFromUsages()) {
            return true;
        }
        if (expected instanceof PyStructuralType && actual instanceof PyStructuralType) {
            PyStructuralType expectedStructural = (PyStructuralType)expected;
            PyStructuralType actualStructural = (PyStructuralType)actual;
            if (expectedStructural.isInferredFromUsages()) {
                return true;
            }
            return expectedStructural.getAttributeNames().containsAll(actualStructural.getAttributeNames());
        }
        if (expected instanceof PyStructuralType && actualClassType != null) {
            if (PyTypeChecker.overridesGetAttr(actualClassType.getPyClass(), context)) {
                return true;
            }
            Set<String> actualAttributes = actualClassType.getMemberNames(true, context);
            return actualAttributes.containsAll(((PyStructuralType)expected).getAttributeNames());
        }
        if (expected instanceof PyStructuralType) {
            expectedAttributes = ((PyStructuralType)expected).getAttributeNames();
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
            return expectedAttributes.stream().noneMatch(attribute -> ContainerUtil.isEmpty(actual.resolveMember((String)attribute, null, AccessDirection.READ, resolveContext)));
        }
        if (actual instanceof PyStructuralType && expectedClassType != null) {
            expectedAttributes = expectedClassType.getMemberNames(true, context);
            return expectedAttributes.containsAll(((PyStructuralType)actual).getAttributeNames());
        }
        if (actual instanceof PyCallableType && expected instanceof PyCallableType) {
            PyCallableType expectedCallable = (PyCallableType)expected;
            PyCallableType actualCallable = (PyCallableType)actual;
            if (expectedCallable.isCallable() && actualCallable.isCallable()) {
                List<PyCallableParameter> expectedParameters = expectedCallable.getParameters(context);
                List<PyCallableParameter> actualParameters = actualCallable.getParameters(context);
                if (expectedParameters != null && actualParameters != null) {
                    int size = Math.min(expectedParameters.size(), actualParameters.size());
                    for (int i = 0; i < size; ++i) {
                        PyCallableParameter expectedParam = expectedParameters.get(i);
                        PyCallableParameter actualParam = actualParameters.get(i);
                        if (PyTypeChecker.match(expectedParam.getType(context), actualParam.getType(context), context, substitutions, recursive)) continue;
                        return false;
                    }
                }
                return PyTypeChecker.match(expectedCallable.getReturnType(context), actualCallable.getReturnType(context), context, substitutions, recursive);
            }
        }
        return PyTypeChecker.matchNumericTypes(expected, actual);
    }

    private static boolean matchClassObjectAndMetaclass(@NotNull PyType expected, @NotNull PyClassLikeType actual, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(3);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(5);
        }
        if (!actual.isDefinition()) {
            return false;
        }
        PyClassLikeType metaClass = actual.getMetaClassType(context, true);
        return metaClass != null && PyTypeChecker.match(expected, metaClass, context);
    }

    private static boolean typeVarAcceptsBothClassAndInstanceTypes(@NotNull PyGenericType typeVar) {
        if (typeVar == null) {
            PyTypeChecker.$$$reportNull$$$0(6);
        }
        return !typeVar.isDefinition() && typeVar.getBound() == null;
    }

    private static boolean consistsOfSameElementNumberTuples(@NotNull PyUnionType unionType, int elementCount) {
        if (unionType == null) {
            PyTypeChecker.$$$reportNull$$$0(7);
        }
        for (PyType type : unionType.getMembers()) {
            if (type instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)type;
                if (tupleType.isHomogeneous() || elementCount == tupleType.getElementCount()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean substituteExpectedElementsWithUnions(@NotNull PyTupleType expected, int elementCount, @NotNull PyUnionType actual, @NotNull TypeEvalContext context, @Nullable Map<PyGenericType, PyType> substitutions, boolean recursive) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(8);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(10);
        }
        for (int i = 0; i < elementCount; ++i) {
            int currentIndex = i;
            PyType elementType = PyUnionType.union(StreamEx.of(actual.getMembers()).select(PyTupleType.class).map(type -> type.getElementType(currentIndex)).toList());
            if (PyTypeChecker.match(expected.getElementType(i), elementType, context, substitutions, recursive)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchNumericTypes(PyType expected, PyType actual) {
        String superName = expected.getName();
        String subName = actual.getName();
        boolean subIsBool = "bool".equals(subName);
        boolean subIsInt = "int".equals(subName);
        boolean subIsLong = "long".equals(subName);
        boolean subIsFloat = "float".equals(subName);
        boolean subIsComplex = "complex".equals(subName);
        return !(superName != null && subName != null && !superName.equals(subName) && (!"int".equals(superName) || !subIsBool) && (!"long".equals(superName) && !"Integral".equals(superName) || !subIsBool && !subIsInt) && (!"float".equals(superName) && !"Real".equals(superName) || !subIsBool && !subIsInt && !subIsLong) && (!"complex".equals(superName) && !"Complex".equals(superName) || !subIsBool && !subIsInt && !subIsLong && !subIsFloat) && (!"Number".equals(superName) || !subIsBool && !subIsInt && !subIsLong && !subIsFloat && !subIsComplex));
    }

    public static boolean isUnknown(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(11);
        }
        return PyTypeChecker.isUnknown(type, true, context);
    }

    public static boolean isUnknown(@Nullable PyType type, boolean genericsAreUnknown, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(12);
        }
        if (type == null || genericsAreUnknown && type instanceof PyGenericType) {
            return true;
        }
        if (type instanceof PyFunctionType && (callable = ((PyFunctionType)type).getCallable()) instanceof PyDecoratable && PyKnownDecoratorUtil.hasUnknownOrChangingReturnTypeDecorator((PyDecoratable)((Object)callable), context)) {
            return true;
        }
        if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            for (PyType t : union.getMembers()) {
                if (!PyTypeChecker.isUnknown(t, genericsAreUnknown, context)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PyType toNonWeakType(@Nullable PyType type, @NotNull TypeEvalContext context) {
        PyUnionType unionType;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(13);
        }
        if (type instanceof PyUnionType && (unionType = (PyUnionType)type).isWeak()) {
            return unionType.excludeNull(context);
        }
        return type;
    }

    public static boolean hasGenerics(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(14);
        }
        HashSet<PyGenericType> collected = new HashSet<PyGenericType>();
        PyTypeChecker.collectGenerics(type, context, collected, new HashSet<PyType>());
        return !collected.isEmpty();
    }

    private static void collectGenerics(@Nullable PyType type, @NotNull TypeEvalContext context, @NotNull Set<PyGenericType> collected, @NotNull Set<PyType> visited) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(15);
        }
        if (collected == null) {
            PyTypeChecker.$$$reportNull$$$0(16);
        }
        if (visited == null) {
            PyTypeChecker.$$$reportNull$$$0(17);
        }
        if (visited.contains(type)) {
            return;
        }
        visited.add(type);
        if (type instanceof PyGenericType) {
            collected.add((PyGenericType)type);
        } else if (type instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type;
            for (PyType t : union.getMembers()) {
                PyTypeChecker.collectGenerics(t, context, collected, visited);
            }
        } else if (type instanceof PyTupleType) {
            PyTupleType tuple = (PyTupleType)type;
            int n = tuple.isHomogeneous() ? 1 : tuple.getElementCount();
            for (int i = 0; i < n; ++i) {
                PyTypeChecker.collectGenerics(tuple.getElementType(i), context, collected, visited);
            }
        } else if (type instanceof PyCollectionType) {
            PyCollectionType collection = (PyCollectionType)type;
            for (PyType elementType : collection.getElementTypes()) {
                PyTypeChecker.collectGenerics(elementType, context, collected, visited);
            }
        } else if (type instanceof PyCallableType) {
            PyCallableType callable = (PyCallableType)type;
            List<PyCallableParameter> parameters = callable.getParameters(context);
            if (parameters != null) {
                for (PyCallableParameter parameter : parameters) {
                    if (parameter == null) continue;
                    PyTypeChecker.collectGenerics(parameter.getType(context), context, collected, visited);
                }
            }
            PyTypeChecker.collectGenerics(callable.getReturnType(context), context, collected, visited);
        }
    }

    @Nullable
    public static PyType substitute(@Nullable PyType type, @NotNull Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(18);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(19);
        }
        if (PyTypeChecker.hasGenerics(type, context)) {
            if (type instanceof PyGenericType) {
                PyGenericType typeVar = (PyGenericType)type;
                PyType substitution = substitutions.get(typeVar);
                if (substitution == null) {
                    if (!typeVar.isDefinition()) {
                        PyInstantiableType classType = PyUtil.as(substitutions.get(typeVar.toClass()), PyInstantiableType.class);
                        if (classType != null) {
                            substitution = classType.toInstance();
                        }
                    } else {
                        PyInstantiableType instanceType = PyUtil.as(substitutions.get(typeVar.toInstance()), PyInstantiableType.class);
                        if (instanceType != null) {
                            substitution = instanceType.toClass();
                        }
                    }
                }
                if (substitution instanceof PyGenericType && !typeVar.equals(substitution) && substitutions.containsKey(substitution)) {
                    return PyTypeChecker.substitute(substitution, substitutions, context);
                }
                return substitution;
            }
            if (type instanceof PyUnionType) {
                PyUnionType union = (PyUnionType)type;
                ArrayList<PyType> results = new ArrayList<PyType>();
                for (PyType t : union.getMembers()) {
                    PyType subst = PyTypeChecker.substitute(t, substitutions, context);
                    results.add(subst);
                }
                return PyUnionType.union(results);
            }
            if (type instanceof PyCollectionTypeImpl) {
                PyCollectionTypeImpl collection = (PyCollectionTypeImpl)type;
                List<PyType> elementTypes = collection.getElementTypes();
                ArrayList<PyType> substitutes = new ArrayList<PyType>();
                for (PyType elementType2 : elementTypes) {
                    substitutes.add(PyTypeChecker.substitute(elementType2, substitutions, context));
                }
                return new PyCollectionTypeImpl(collection.getPyClass(), collection.isDefinition(), substitutes);
            }
            if (type instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)type;
                PyClass tupleClass = tupleType.getPyClass();
                List<PyType> oldElementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
                List newElementTypes = ContainerUtil.map(oldElementTypes, elementType -> {
                    if (substitutions == null) {
                        PyTypeChecker.$$$reportNull$$$0(53);
                    }
                    if (context == null) {
                        PyTypeChecker.$$$reportNull$$$0(54);
                    }
                    return PyTypeChecker.substitute(elementType, substitutions, context);
                });
                return new PyTupleType(tupleClass, newElementTypes, tupleType.isHomogeneous());
            }
            if (type instanceof PyCallableType) {
                PyCallableType callable = (PyCallableType)type;
                ArrayList<PyCallableParameter> substParams = null;
                List<PyCallableParameter> parameters = callable.getParameters(context);
                if (parameters != null) {
                    substParams = new ArrayList<PyCallableParameter>();
                    for (PyCallableParameter parameter : parameters) {
                        PyType substType = PyTypeChecker.substitute(parameter.getType(context), substitutions, context);
                        PyParameter psi = parameter.getParameter();
                        PyCallableParameter subst = psi != null ? PyCallableParameterImpl.psi(psi, substType) : PyCallableParameterImpl.nonPsi(parameter.getName(), substType, parameter.getDefaultValue());
                        substParams.add(subst);
                    }
                }
                PyType substResult = PyTypeChecker.substitute(callable.getReturnType(context), substitutions, context);
                return new PyCallableTypeImpl(substParams, substResult);
            }
        }
        return type;
    }

    @Nullable
    public static Map<PyGenericType, PyType> unifyGenericCall(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(20);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(21);
        }
        Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyReceiver(receiver, context);
        for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType argumentType = context.getType(entry.getKey());
            PyCallableParameter parameter = entry.getValue();
            if (PyTypeChecker.match(parameter.getArgumentType(context), argumentType, context, substitutions)) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedPositionalContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), substitutions, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedKeywordContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), substitutions, context)) {
            return null;
        }
        return substitutions;
    }

    private static boolean matchContainer(@Nullable PyCallableParameter container, @NotNull List<PyExpression> arguments, @NotNull Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(22);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(23);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(24);
        }
        if (container == null) {
            return true;
        }
        List types = ContainerUtil.map(arguments, context::getType);
        return PyTypeChecker.match(container.getArgumentType(context), PyUnionType.union(types), context, substitutions);
    }

    @NotNull
    public static Map<PyGenericType, PyType> unifyReceiver(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(25);
        }
        LinkedHashMap<PyGenericType, PyType> substitutions = new LinkedHashMap<PyGenericType, PyType>();
        LinkedHashSet<PyGenericType> generics = new LinkedHashSet<PyGenericType>();
        PyType qualifierType = receiver != null ? context.getType(receiver) : null;
        PyTypeChecker.collectGenerics(qualifierType, context, generics, new HashSet<PyType>());
        for (PyGenericType t : generics) {
            substitutions.put(t, t);
        }
        if (qualifierType != null) {
            for (PyClassType type : PyTypeChecker.toPossibleClassTypes(qualifierType)) {
                for (PyTypeProvider provider : (PyTypeProvider[])Extensions.getExtensions(PyTypeProvider.EP_NAME)) {
                    PyType genericType = provider.getGenericType(type.getPyClass(), context);
                    if (genericType != null) {
                        PyTypeChecker.match(genericType, type, context, substitutions);
                    }
                    for (Map.Entry<PyType, PyType> entry : provider.getGenericSubstitutions(type.getPyClass(), context).entrySet()) {
                        PyGenericType genericKey = PyUtil.as(entry.getKey(), PyGenericType.class);
                        PyType value = entry.getValue();
                        if (genericKey == null || value == null || substitutions.containsKey(genericKey)) continue;
                        substitutions.put(genericKey, value);
                    }
                }
            }
        }
        PyTypeChecker.replaceUnresolvedGenericsWithAny(substitutions);
        LinkedHashMap<PyGenericType, PyType> linkedHashMap = substitutions;
        if (linkedHashMap == null) {
            PyTypeChecker.$$$reportNull$$$0(26);
        }
        return linkedHashMap;
    }

    @NotNull
    private static List<PyClassType> toPossibleClassTypes(@NotNull PyType type) {
        PyClassType classType;
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(27);
        }
        if ((classType = PyUtil.as(type, PyClassType.class)) != null) {
            List<PyClassType> list2 = Collections.singletonList(classType);
            if (list2 == null) {
                PyTypeChecker.$$$reportNull$$$0(28);
            }
            return list2;
        }
        PyUnionType unionType = PyUtil.as(type, PyUnionType.class);
        if (unionType != null) {
            List list3 = StreamEx.of(unionType.getMembers()).nonNull().flatMap(t -> PyTypeChecker.toPossibleClassTypes(t).stream()).toList();
            if (list3 == null) {
                PyTypeChecker.$$$reportNull$$$0(29);
            }
            return list3;
        }
        List<PyClassType> list4 = Collections.emptyList();
        if (list4 == null) {
            PyTypeChecker.$$$reportNull$$$0(30);
        }
        return list4;
    }

    private static void replaceUnresolvedGenericsWithAny(@NotNull Map<PyGenericType, PyType> substitutions) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(31);
        }
        List unresolvedGenerics = ContainerUtil.filter(substitutions.values(), type -> {
            if (substitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(52);
            }
            return type instanceof PyGenericType && !substitutions.containsKey(type);
        });
        for (PyType unresolvedGeneric : unresolvedGenerics) {
            substitutions.put((PyGenericType)unresolvedGeneric, null);
        }
    }

    private static boolean matchClasses(@Nullable PyClass superClass, @Nullable PyClass subClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(32);
        }
        if (superClass == null || subClass == null || subClass.isSubclass(superClass, context) || PyABCUtil.isSubclass(subClass, superClass, context) || PyTypeChecker.isStrUnicodeMatch(subClass, superClass) || PyTypeChecker.isBytearrayBytesStringMatch(subClass, superClass) || PyUtil.hasUnresolvedAncestors(subClass, context)) {
            return true;
        }
        String superName = superClass.getName();
        return superName != null && superName.equals(subClass.getName());
    }

    private static boolean isStrUnicodeMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(33);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(34);
        }
        return "str".equals(subClass.getName()) && "unicode".equals(superClass.getName());
    }

    private static boolean isBytearrayBytesStringMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(35);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(36);
        }
        if (!"bytearray".equals(subClass.getName())) {
            return false;
        }
        PsiFile subClassFile = subClass.getContainingFile();
        boolean isPy2 = subClassFile instanceof PyiFile ? PyBuiltinCache.getInstance((PsiElement)subClass).getObjectType("unicode") != null : LanguageLevel.forElement((PsiElement)subClass).isOlderThan(LanguageLevel.PYTHON30);
        String superClassName = superClass.getName();
        return isPy2 && "str".equals(superClassName) || !isPy2 && "bytes".equals(superClassName);
    }

    @Nullable
    public static Boolean isCallable(@Nullable PyType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PyUnionType) {
            return PyTypeChecker.isUnionCallable((PyUnionType)type);
        }
        if (type instanceof PyCallableType) {
            return ((PyCallableType)type).isCallable();
        }
        if (type instanceof PyStructuralType && ((PyStructuralType)type).isInferredFromUsages()) {
            return true;
        }
        return false;
    }

    @Nullable
    private static Boolean isUnionCallable(@NotNull PyUnionType type) {
        if (type == null) {
            PyTypeChecker.$$$reportNull$$$0(37);
        }
        for (PyType member : type.getMembers()) {
            Boolean callable = PyTypeChecker.isCallable(member);
            if (callable == null) {
                return null;
            }
            if (!callable.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean overridesGetAttr(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PsiElement method;
        if (cls == null) {
            PyTypeChecker.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(39);
        }
        if ((method = PyTypeChecker.resolveClassMember(cls, "__getattr__", context)) != null) {
            return true;
        }
        method = PyTypeChecker.resolveClassMember(cls, "__getattribute__", context);
        return method != null && !PyBuiltinCache.getInstance((PsiElement)cls).isBuiltin(method);
    }

    @Nullable
    private static PsiElement resolveClassMember(@NotNull PyClass cls, @NotNull String name, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        PyType type;
        if (cls == null) {
            PyTypeChecker.$$$reportNull$$$0(40);
        }
        if (name == null) {
            PyTypeChecker.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(42);
        }
        if ((type = context.getType(cls)) != null && (results = type.resolveMember(name, null, AccessDirection.READ, resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context))) != null && !results.isEmpty()) {
            return results.get(0).getElement();
        }
        return null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target2, @NotNull PyTupleExpression parentTuple, @NotNull PyType assignedType, @NotNull TypeEvalContext context) {
        if (target2 == null) {
            PyTypeChecker.$$$reportNull$$$0(43);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(44);
        }
        if (assignedType == null) {
            PyTypeChecker.$$$reportNull$$$0(45);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(46);
        }
        if (assignedType instanceof PyTupleType) {
            return PyTypeChecker.getTargetTypeFromTupleAssignment(target2, parentTuple, (PyTupleType)assignedType);
        }
        if (assignedType instanceof PyClassLikeType) {
            return StreamEx.of(((PyClassLikeType)assignedType).getAncestorTypes(context)).select(PyNamedTupleType.class).findFirst().map(t -> {
                if (target2 == null) {
                    PyTypeChecker.$$$reportNull$$$0(50);
                }
                if (parentTuple == null) {
                    PyTypeChecker.$$$reportNull$$$0(51);
                }
                return PyTypeChecker.getTargetTypeFromTupleAssignment(target2, parentTuple, t);
            }).orElse(null);
        }
        return null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target2, @NotNull PyTupleExpression parentTuple, @NotNull PyTupleType assignedTupleType) {
        if (target2 == null) {
            PyTypeChecker.$$$reportNull$$$0(47);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(48);
        }
        if (assignedTupleType == null) {
            PyTypeChecker.$$$reportNull$$$0(49);
        }
        int count = assignedTupleType.getElementCount();
        Object[] elements = parentTuple.getElements();
        if (elements.length == count || assignedTupleType.isHomogeneous()) {
            int index = ArrayUtil.indexOf((Object[])elements, (Object)target2);
            if (index >= 0) {
                return assignedTupleType.getElementType(index);
            }
            for (int i = 0; i < count; ++i) {
                PyType result2;
                PyType elementType;
                Object element = elements[i];
                while (element instanceof PyParenthesizedExpression) {
                    element = ((PyParenthesizedExpression)element).getContainedExpression();
                }
                if (!(element instanceof PyTupleExpression) || !((elementType = assignedTupleType.getElementType(i)) instanceof PyTupleType) || (result2 = PyTypeChecker.getTargetTypeFromTupleAssignment(target2, (PyTupleExpression)element, (PyTupleType)elementType)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVar";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collected";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 18: 
            case 23: 
            case 31: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 27: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 43: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 44: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTuple";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedType";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTupleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyReceiver";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "toPossibleClassTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchClassObjectAndMetaclass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "typeVarAcceptsBothClassAndInstanceTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "consistsOfSameElementNumberTuples";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substituteExpectedElementsWithUnions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toNonWeakType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasGenerics";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectGenerics";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCall";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchContainer";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "unifyReceiver";
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toPossibleClassTypes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceUnresolvedGenericsWithAny";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "matchClasses";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isStrUnicodeMatch";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isBytearrayBytesStringMatch";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isUnionCallable";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "overridesGetAttr";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassMember";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromTupleAssignment";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTargetTypeFromTupleAssignment$6";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$replaceUnresolvedGenericsWithAny$5";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$substitute$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

