/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.validation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.XmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.ext.Locator2Impl;

class Psi2SaxAdapter
extends XmlElementVisitor
implements PsiElementProcessor<PsiElement> {
    private final ContentHandler myHandler;

    public Psi2SaxAdapter(ContentHandler handler2) {
        this.myHandler = handler2;
    }

    public void visitXmlElement(XmlElement element) {
        if (element instanceof XmlEntityRef) {
            XmlUtil.processXmlElements(element, this, false, true);
        }
        super.visitXmlElement(element);
    }

    public void visitXmlToken(XmlToken token) {
        if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
            this.handleText((XmlElement)token, token.getText());
        }
    }

    private void handleText(XmlElement element, String text) {
        try {
            this.setLocation((PsiElement)element);
            this.myHandler.characters(text.toCharArray(), 0, text.length());
        }
        catch (SAXException e) {
            throw new ParseError(e);
        }
    }

    public boolean execute(@NotNull PsiElement element) {
        if (element == null) {
            Psi2SaxAdapter.$$$reportNull$$$0(0);
        }
        element.accept((PsiElementVisitor)this);
        return true;
    }

    public void visitXmlDocument(XmlDocument document) {
        try {
            this.myHandler.startDocument();
            XmlTag rootTag = document.getRootTag();
            if (rootTag != null) {
                rootTag.accept((PsiElementVisitor)this);
            }
            this.myHandler.endDocument();
        }
        catch (SAXException e) {
            throw new ParseError(e);
        }
    }

    public void visitXmlTag(XmlTag tag) {
        try {
            XmlAttribute[] xmlAttributes;
            String[] prefixes;
            this.setLocation((PsiElement)tag);
            Map map2 = tag.getLocalNamespaceDeclarations();
            for (String prefix : prefixes = map2.keySet().toArray(new String[map2.size()])) {
                this.myHandler.startPrefixMapping(prefix, (String)map2.get(prefix));
            }
            Attributes2Impl atts = new Attributes2Impl();
            for (XmlAttribute attribute : xmlAttributes = tag.getAttributes()) {
                String s = attribute.getName();
                if ("xmlns".equals(s) || s.startsWith("xmlns:")) continue;
                String uri = attribute.getNamespace();
                atts.addAttribute(s.contains(":") ? uri : "", attribute.getLocalName(), s, "PCDATA", attribute.getValue());
            }
            String namespace = tag.getNamespace();
            String localName = tag.getLocalName();
            String name = tag.getName();
            this.myHandler.startElement(namespace, localName, name, atts);
            for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
                child.accept((PsiElementVisitor)this);
            }
            this.myHandler.endElement(namespace, localName, name);
            for (int i = prefixes.length - 1; i >= 0; --i) {
                String prefix = prefixes[i];
                this.myHandler.endPrefixMapping(prefix);
            }
        }
        catch (SAXException e) {
            throw new ParseError(e);
        }
    }

    public void visitXmlText(XmlText text) {
        this.handleText((XmlElement)text, text.getValue());
    }

    private void setLocation(PsiElement text) {
        PsiFile psiFile = text.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)text.getProject()).getDocument(psiFile);
        if (document == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Locator2Impl locator = new Locator2Impl();
        locator.setSystemId(VfsUtilCore.fixIDEAUrl((String)virtualFile.getUrl()));
        int offset = text.getTextRange().getEndOffset();
        int lineNumber = document.getLineNumber(offset);
        locator.setLineNumber(lineNumber + 1);
        locator.setColumnNumber(1 + offset - document.getLineStartOffset(lineNumber));
        this.myHandler.setDocumentLocator(locator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/validation/Psi2SaxAdapter", "execute"));
    }

    public static class ParseError
    extends RuntimeException {
        public ParseError(SAXException e) {
            super(e);
        }
    }
}

