/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class RelativeRectangle {
    private RelativePoint myPoint;
    private Dimension myDimension;

    public RelativeRectangle() {
        this(new RelativePoint(new JLabel(), new Point()), new Dimension());
    }

    public RelativeRectangle(MouseEvent event, Dimension size) {
        this(event.getComponent(), new Rectangle(event.getPoint(), size));
    }

    public RelativeRectangle(JComponent component) {
        this(new RelativePoint(component.getParent(), component.getBounds().getLocation()), component.getBounds().getSize());
    }

    public RelativeRectangle(Component component, Rectangle rectangle) {
        this(new RelativePoint(component, rectangle.getLocation()), rectangle.getSize());
    }

    public RelativeRectangle(RelativePoint point, Dimension dimension) {
        this.myDimension = dimension;
        this.myPoint = point;
    }

    public Dimension getDimension() {
        return this.myDimension;
    }

    public RelativePoint getPoint() {
        return this.myPoint;
    }

    public RelativePoint getMaxPoint() {
        return new RelativePoint(this.myPoint.getComponent(), new Point(this.myPoint.getPoint().x + this.myDimension.width, this.myPoint.getPoint().y + this.myDimension.height));
    }

    public Rectangle getRectangleOn(Component target) {
        return new Rectangle(this.getPoint().getPoint(target), this.getDimension());
    }

    public Rectangle getScreenRectangle() {
        return new Rectangle(this.getPoint().getScreenPoint(), this.getDimension());
    }

    public static RelativeRectangle fromScreen(JComponent target, Rectangle screenRectangle) {
        Point relativePoint = screenRectangle.getLocation();
        SwingUtilities.convertPointFromScreen(relativePoint, target);
        return new RelativeRectangle(new RelativePoint(target, relativePoint), screenRectangle.getSize());
    }

    public Component getComponent() {
        return this.getPoint().getComponent();
    }

    public boolean contains(RelativePoint relativePoint) {
        return this.getScreenRectangle().contains(relativePoint.getScreenPoint());
    }
}

