/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryCollectorContext;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.sort.SortAndFormats;

abstract class TopDocsCollectorContext
extends QueryCollectorContext {
    protected final int numHits;

    TopDocsCollectorContext(String profilerName, int numHits) {
        super(profilerName);
        this.numHits = numHits;
    }

    final int numHits() {
        return this.numHits;
    }

    boolean shouldRescore() {
        return false;
    }

    static int shortcutTotalHitCount(IndexReader reader, Query query) throws IOException {
        while (true) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (!(query instanceof BoostQuery)) break;
            query = ((BoostQuery)query).getQuery();
        }
        if (query.getClass() == MatchAllDocsQuery.class) {
            return reader.numDocs();
        }
        if (query.getClass() == TermQuery.class && !reader.hasDeletions()) {
            Term term = ((TermQuery)query).getTerm();
            int count = 0;
            for (LeafReaderContext context : reader.leaves()) {
                count += context.reader().docFreq(term);
            }
            return count;
        }
        return -1;
    }

    static TopDocsCollectorContext createTopDocsCollectorContext(SearchContext searchContext, IndexReader reader, boolean shouldCollect) throws IOException {
        boolean rescore;
        Query query = searchContext.query();
        int totalNumDocs = Math.max(1, reader.numDocs());
        if (searchContext.size() == 0) {
            return new TotalHitCountCollectorContext(reader, query, shouldCollect);
        }
        if (searchContext.scrollContext() != null) {
            int numDocs = Math.min(searchContext.size(), totalNumDocs);
            return new ScrollingTopDocsCollectorContext(searchContext.scrollContext(), searchContext.sort(), numDocs, searchContext.trackScores(), searchContext.numberOfShards());
        }
        if (searchContext.collapse() != null) {
            boolean trackScores = searchContext.sort() == null ? true : searchContext.trackScores();
            int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
            return new CollapsingTopDocsCollectorContext(searchContext.collapse(), searchContext.sort(), numDocs, trackScores);
        }
        int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
        boolean bl = rescore = !searchContext.rescore().isEmpty();
        if (rescore) {
            assert (searchContext.sort() == null);
            for (RescoreContext rescoreContext : searchContext.rescore()) {
                numDocs = Math.max(numDocs, rescoreContext.getWindowSize());
            }
        }
        return new SimpleTopDocsCollectorContext(searchContext.sort(), (ScoreDoc)searchContext.searchAfter(), numDocs, searchContext.trackScores()){

            @Override
            boolean shouldRescore() {
                return rescore;
            }
        };
    }

    static class ScrollingTopDocsCollectorContext
    extends SimpleTopDocsCollectorContext {
        private final ScrollContext scrollContext;
        private final int numberOfShards;

        private ScrollingTopDocsCollectorContext(ScrollContext scrollContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore, int numberOfShards) throws IOException {
            super(sortAndFormats, scrollContext.lastEmittedDoc, numHits, trackMaxScore);
            this.scrollContext = Objects.requireNonNull(scrollContext);
            this.numberOfShards = numberOfShards;
        }

        @Override
        void postProcess(QuerySearchResult result, boolean hasCollected) throws IOException {
            super.postProcess(result, hasCollected);
            TopDocs topDocs = result.topDocs();
            if (this.scrollContext.totalHits == -1L) {
                this.scrollContext.totalHits = topDocs.totalHits;
                this.scrollContext.maxScore = topDocs.getMaxScore();
            } else {
                topDocs.totalHits = this.scrollContext.totalHits;
                topDocs.setMaxScore(this.scrollContext.maxScore);
            }
            if (this.numberOfShards == 1 && topDocs.scoreDocs.length > 0) {
                this.scrollContext.lastEmittedDoc = topDocs.scoreDocs[topDocs.scoreDocs.length - 1];
            }
            result.topDocs(topDocs, result.sortValueFormats());
        }
    }

    static abstract class SimpleTopDocsCollectorContext
    extends TopDocsCollectorContext {
        @Nullable
        private final SortAndFormats sortAndFormats;
        private final TopDocsCollector<?> topDocsCollector;

        private SimpleTopDocsCollectorContext(@Nullable SortAndFormats sortAndFormats, @Nullable ScoreDoc searchAfter, int numHits, boolean trackMaxScore) throws IOException {
            super("search_top_hits", numHits);
            this.sortAndFormats = sortAndFormats;
            this.topDocsCollector = sortAndFormats == null ? TopScoreDocCollector.create((int)numHits, (ScoreDoc)searchAfter) : TopFieldCollector.create((Sort)sortAndFormats.sort, (int)numHits, (FieldDoc)((FieldDoc)searchAfter), (boolean)true, (boolean)trackMaxScore, (boolean)trackMaxScore);
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.topDocsCollector;
        }

        @Override
        void postProcess(QuerySearchResult result, boolean hasCollected) throws IOException {
            assert (hasCollected);
            TopDocs topDocs = this.topDocsCollector.topDocs();
            result.topDocs(topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.formats);
        }
    }

    static class CollapsingTopDocsCollectorContext
    extends TopDocsCollectorContext {
        private final DocValueFormat[] sortFmt;
        private final CollapsingTopDocsCollector<?> topDocsCollector;

        private CollapsingTopDocsCollectorContext(CollapseContext collapseContext, @Nullable SortAndFormats sortAndFormats, int numHits, boolean trackMaxScore) {
            super("search_top_hits", numHits);
            DocValueFormat[] docValueFormatArray;
            Sort sort;
            assert (numHits > 0);
            assert (collapseContext != null);
            Sort sort2 = sort = sortAndFormats == null ? Sort.RELEVANCE : sortAndFormats.sort;
            if (sortAndFormats == null) {
                DocValueFormat[] docValueFormatArray2 = new DocValueFormat[1];
                docValueFormatArray = docValueFormatArray2;
                docValueFormatArray2[0] = DocValueFormat.RAW;
            } else {
                docValueFormatArray = sortAndFormats.formats;
            }
            this.sortFmt = docValueFormatArray;
            this.topDocsCollector = collapseContext.createTopDocs(sort, numHits, trackMaxScore);
        }

        @Override
        Collector create(Collector in) throws IOException {
            assert (in == null);
            return this.topDocsCollector;
        }

        @Override
        void postProcess(QuerySearchResult result, boolean hasCollected) throws IOException {
            assert (hasCollected);
            result.topDocs((TopDocs)this.topDocsCollector.getTopDocs(), this.sortFmt);
        }
    }

    static class TotalHitCountCollectorContext
    extends TopDocsCollectorContext {
        private final TotalHitCountCollector collector = new TotalHitCountCollector();
        private final int hitCount;

        private TotalHitCountCollectorContext(IndexReader reader, Query query, boolean shouldCollect) throws IOException {
            super("search_count", 0);
            this.hitCount = shouldCollect ? -1 : TotalHitCountCollectorContext.shortcutTotalHitCount(reader, query);
        }

        @Override
        boolean shouldCollect() {
            return this.hitCount == -1;
        }

        @Override
        Collector create(Collector in) {
            assert (in == null);
            return this.collector;
        }

        @Override
        void postProcess(QuerySearchResult result, boolean hasCollected) {
            int totalHitCount;
            if (hasCollected) {
                totalHitCount = this.collector.getTotalHits();
            } else {
                assert (this.hitCount != -1);
                totalHitCount = this.hitCount;
            }
            result.topDocs(new TopDocs((long)totalHitCount, Lucene.EMPTY_SCORE_DOCS, 0.0f), null);
        }
    }
}

